/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotAttribute;
import com.amazon.aes.webservices.client.SnapshotListAttribute;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.SnapshotAttributeBaseCmd;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ModifySnapshotAttribute
extends SnapshotAttributeBaseCmd {
    private static final String[] REMOVE_DESC = new String[]{"Remove a stated attribute, e.g create volume permissions, from the ENTITY", "specified. Valid ENTITY values are:", "  AWS Account ID:  User ID to lose stated snapshot attribute.", "  all:             All users to lose the stated snapshot attribute."};
    private static final String REMOVE_ARG = "ENTITY [--remove ENTITY...]";
    private static final String[] ADD_DESC = new String[]{"Add a stated attribute, e.g create volume permissions, to the specified", "ENTITY. Valid ENTITY values are:", "  AWS Account ID:  User ID to receive stated snapshot attribute.", "  all:             All users to receive the stated snapshot attribute."};
    private static final String ADD_ARG = "ENTITY [--add ENTITY...]";
    private static final String[] CREATE_VOLUME_PERMISSION_DESC = new String[]{"Used together with the --add or --remove flags to, respectively,", "grant or revoke create volume permissions on the specified snapshot for", "the specified ENTITY."};
    private static final String[] MODIFY_ATTRIBUTE_ARGS = new String[]{"create-volume-permission"};

    public ModifySnapshotAttribute(String[] args) {
        super("ec2msnapatt", "ec2-modify-snapshot-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"create-volume-permission");
        OptionBuilder.withDescription((String)ModifySnapshotAttribute.joinDescription(CREATE_VOLUME_PERMISSION_DESC));
        result.addOption(OptionBuilder.create((String)"c"));
        OptionBuilder.withLongOpt((String)"add");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifySnapshotAttribute.joinDescription(ADD_DESC));
        OptionBuilder.withArgName((String)ADD_ARG);
        result.addOption(OptionBuilder.create((String)"a"));
        OptionBuilder.withLongOpt((String)"remove");
        OptionBuilder.hasArgs();
        OptionBuilder.withDescription((String)ModifySnapshotAttribute.joinDescription(REMOVE_DESC));
        OptionBuilder.withArgName((String)REMOVE_ARG);
        result.addOption(OptionBuilder.create((String)"r"));
        return result;
    }

    protected String getOptionString() {
        return "SNAPSHOT (-c ( -a ENTITY | -r ENTITY ))";
    }

    public void printOptions() {
        super.printOptions(true);
        this.printOption("create-volume-permission");
        this.printOption("add");
        this.printOption("remove");
    }

    public void printDescription() {
        super.printDescription();
        System.out.println("     Modify an attribute on a snapshot. The SNAPSHOT parameter is the ID of");
        System.out.println("     the snapshot for which to modify an attribute.");
    }

    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        RequestResultPair rsp;
        String snapshotId = this.getSnapshotId();
        this.assertOnlyOneOptionSet(MODIFY_ATTRIBUTE_ARGS);
        SnapshotAttribute attribute = this.getSnapshotAttribute(jec2);
        SnapshotListAttribute.SnapshotListAttributeOperationType operationType = null;
        if (attribute instanceof SnapshotListAttribute) {
            operationType = this.getAttributeListOperationType();
        }
        if (((Boolean)(rsp = jec2.modifySnapshotAttribute(snapshotId, attribute, operationType)).getResponse()).booleanValue()) {
            out.output(System.out, snapshotId, attribute, operationType);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    public static void main(String[] args) {
        new ModifySnapshotAttribute(args).invoke();
    }
}

