/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.indexlifecycle;

import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.indexlifecycle.ClusterStateWaitStep;
import org.elasticsearch.xpack.core.indexlifecycle.InitializePolicyContextStep;
import org.elasticsearch.xpack.core.indexlifecycle.Step;

public class ShrunkenIndexCheckStep
extends ClusterStateWaitStep {
    public static final String NAME = "is-shrunken-index";
    private static final Logger logger = LogManager.getLogger(InitializePolicyContextStep.class);
    private String shrunkIndexPrefix;

    public ShrunkenIndexCheckStep(Step.StepKey key, Step.StepKey nextStepKey, String shrunkIndexPrefix) {
        super(key, nextStepKey);
        this.shrunkIndexPrefix = shrunkIndexPrefix;
    }

    String getShrunkIndexPrefix() {
        return this.shrunkIndexPrefix;
    }

    @Override
    public ClusterStateWaitStep.Result isConditionMet(Index index, ClusterState clusterState) {
        boolean isConditionMet;
        IndexMetaData idxMeta = clusterState.getMetaData().index(index);
        if (idxMeta == null) {
            logger.debug("[{}] lifecycle action for index [{}] executed but index no longer exists", (Object)this.getKey().getAction(), (Object)index.getName());
            return new ClusterStateWaitStep.Result(false, null);
        }
        String shrunkenIndexSource = (String)IndexMetaData.INDEX_SHRINK_SOURCE_NAME.get(clusterState.metaData().index(index).getSettings());
        if (Strings.isNullOrEmpty((String)shrunkenIndexSource)) {
            throw new IllegalStateException("step[is-shrunken-index] is checking an un-shrunken index[" + index.getName() + "]");
        }
        boolean bl = isConditionMet = index.getName().equals(this.shrunkIndexPrefix + shrunkenIndexSource) && clusterState.metaData().index(shrunkenIndexSource) == null;
        if (isConditionMet) {
            return new ClusterStateWaitStep.Result(true, null);
        }
        return new ClusterStateWaitStep.Result(false, new Info(shrunkenIndexSource));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shrunkIndexPrefix);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShrunkenIndexCheckStep other = (ShrunkenIndexCheckStep)obj;
        return super.equals(obj) && Objects.equals(this.shrunkIndexPrefix, other.shrunkIndexPrefix);
    }

    public static final class Info
    implements ToXContentObject {
        private final String originalIndexName;
        private final String message;
        static final ParseField ORIGINAL_INDEX_NAME = new ParseField("original_index_name", new String[0]);
        static final ParseField MESSAGE = new ParseField("message", new String[0]);
        static final ConstructingObjectParser<Info, Void> PARSER = new ConstructingObjectParser("shrunken_index_check_step_info", a -> new Info((String)a[0]));

        public Info(String originalIndexName) {
            this.originalIndexName = originalIndexName;
            this.message = "Waiting for original index [" + originalIndexName + "] to be deleted";
        }

        public String getOriginalIndexName() {
            return this.originalIndexName;
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(MESSAGE.getPreferredName(), this.message);
            builder.field(ORIGINAL_INDEX_NAME.getPreferredName(), this.originalIndexName);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.originalIndexName);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Info other = (Info)obj;
            return Objects.equals(this.originalIndexName, other.originalIndexName);
        }

        public String toString() {
            return Strings.toString((ToXContent)this);
        }

        static {
            PARSER.declareString(ConstructingObjectParser.constructorArg(), ORIGINAL_INDEX_NAME);
            PARSER.declareString((i, s) -> {}, MESSAGE);
        }
    }
}

