/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.epubcheck.xml;

import com.adobe.epubcheck.api.Report;
import com.adobe.epubcheck.util.ResourceUtil;
import com.adobe.epubcheck.xml.XMLAttribute;
import com.adobe.epubcheck.xml.XMLElement;
import com.adobe.epubcheck.xml.XMLHandler;
import com.adobe.epubcheck.xml.XMLValidator;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    ZipFile zip;
    SAXParser parser;
    Report report;
    String resource;
    Vector contentHandlers = new Vector();
    XMLElement currentElement;
    ContentHandler validatorContentHandler;
    DTDHandler validatorDTDHandler;
    Locator documentLocator;
    static String zipRoot = "file:///epub-root/";
    static Hashtable systemIdMap;

    public XMLParser(ZipFile zip, String entryName, Report report) {
        this.report = report;
        this.resource = entryName;
        this.zip = zip;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        boolean hasXML11 = false;
        try {
            hasXML11 = factory.getFeature("http://xml.org/sax/features/xml-1.1");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!hasXML11) {
            System.err.println("Your configuration does not support XML 1.1 parsing");
            System.err.println("\tAre you using off-the-shelf saxon.jar? It contains file named");
            System.err.println("\tMETA-INF/services/javax.xml.parsers.SAXParserFactory");
            System.err.println("\tThis interferes with Java default XML-1.1-compliant parser.");
            System.err.println("\tEither remove that file from saxon.jar or define");
            System.err.println("\tjavax.xml.parsers.SAXParserFactory system property");
            System.err.println("\tto point to XML-1.1-compliant parser.");
        }
        try {
            this.parser = factory.newSAXParser();
            XMLReader reader = this.parser.getXMLReader();
            reader.setDTDHandler(this);
            reader.setContentHandler(this);
            reader.setEntityResolver(this);
            reader.setErrorHandler(this);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    public void addXMLHandler(XMLHandler handler) {
        this.contentHandlers.add(handler);
    }

    public void addValidator(XMLValidator xv) {
        PropertyMapBuilder propertyMapBuilder = new PropertyMapBuilder();
        propertyMapBuilder.put(ValidateProperty.ERROR_HANDLER, this);
        Validator validator = xv.schema.createValidator(propertyMapBuilder.toPropertyMap());
        this.validatorContentHandler = validator.getContentHandler();
        this.validatorDTDHandler = validator.getDTDHandler();
    }

    public void process() {
        try {
            InputStream in = this.zip.getInputStream(this.zip.getEntry(this.resource));
            InputSource ins = new InputSource(in);
            ins.setSystemId(zipRoot + this.resource);
            this.parser.parse(ins, (DefaultHandler)this);
            in.close();
        }
        catch (IOException e) {
            this.report.error(null, 0, "I/O error reading " + this.resource);
        }
        catch (IllegalArgumentException e) {
            this.report.error(null, 0, "could not parse " + this.resource + ": " + e.getMessage());
        }
        catch (SAXException e) {
            this.report.error(this.resource, 0, e.getMessage());
        }
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String resourcePath = (String)systemIdMap.get(systemId);
        if (resourcePath != null) {
            InputStream resourceStream = ResourceUtil.getResourceStream(resourcePath);
            if (systemId.equals("xhtml-lat1.ent") || systemId.equals("xhtml-symbol.ent") || systemId.equals("xhtml-special.ent")) {
                System.err.println("A problem in XML parser detected: external XML entity URLs are not resolved");
                System.err.println("\tPlease configure your runtime environment to use a different XML parser");
                System.err.println("\t(e.g. using javax.xml.parsers.SAXParserFactory system property)");
            }
            InputSource source = new InputSource(resourceStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        if (systemId.startsWith(zipRoot)) {
            String rname = systemId.substring(zipRoot.length());
            ZipEntry entry = this.zip.getEntry(rname);
            if (entry == null) {
                throw new SAXException("Could not resolve local XML entity '" + rname + "'");
            }
            InputStream resourceStream = this.zip.getInputStream(entry);
            InputSource source = new InputSource(resourceStream);
            source.setPublicId(publicId);
            source.setSystemId(systemId);
            return source;
        }
        this.report.warning(this.resource, 0, "Unresolved external XML entity '" + systemId + "'");
        InputStream urlStream = new URL(systemId).openStream();
        InputSource source = new InputSource(urlStream);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        return source;
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
        if (this.validatorDTDHandler != null) {
            this.validatorDTDHandler.notationDecl(name, publicId, systemId);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
        if (this.validatorDTDHandler != null) {
            this.validatorDTDHandler.unparsedEntityDecl(name, publicId, systemId, notationName);
        }
    }

    public void error(SAXParseException ex) throws SAXException {
        this.report.error(this.resource, ex.getLineNumber(), ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        this.report.error(this.resource, ex.getLineNumber(), ex.getMessage());
    }

    public void warning(SAXParseException ex) throws SAXException {
        this.report.warning(this.resource, ex.getLineNumber(), ex.getMessage());
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.characters(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            ((XMLHandler)this.contentHandlers.elementAt(i)).characters(arg0, arg1, arg2);
        }
    }

    public void endDocument() throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.endDocument();
        }
    }

    public void endElement(String arg0, String arg1, String arg2) throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.endElement(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            ((XMLHandler)this.contentHandlers.elementAt(i)).endElement();
        }
        this.currentElement = this.currentElement.getParent();
    }

    public void endPrefixMapping(String arg0) throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.endPrefixMapping(arg0);
        }
    }

    public void ignorableWhitespace(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.ignorableWhitespace(arg0, arg1, arg2);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            ((XMLHandler)this.contentHandlers.elementAt(i)).ignorableWhitespace(arg0, arg1, arg2);
        }
    }

    public void processingInstruction(String arg0, String arg1) throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.processingInstruction(arg0, arg1);
        }
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            ((XMLHandler)this.contentHandlers.elementAt(i)).processingInstruction(arg0, arg1);
        }
    }

    public void setDocumentLocator(Locator locator) {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.setDocumentLocator(locator);
        }
        this.documentLocator = locator;
    }

    public void skippedEntity(String arg0) throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.skippedEntity(arg0);
        }
    }

    public void startDocument() throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.startDocument();
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String name;
        String prefix;
        int index;
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.startElement(namespaceURI, localName, qName, atts);
        }
        if ((index = qName.indexOf(58)) < 0) {
            prefix = null;
            name = qName;
        } else {
            prefix = qName.substring(0, index);
            name = qName.substring(index + 1);
        }
        int count = atts.getLength();
        XMLAttribute[] attributes = count == 0 ? null : new XMLAttribute[count];
        for (int i = 0; i < count; ++i) {
            String attPrefix;
            String attName = atts.getLocalName(i);
            String attNamespace = atts.getURI(i);
            String attQName = atts.getQName(i);
            int attIndex = attQName.indexOf(58);
            if (attIndex < 0) {
                attPrefix = null;
                attNamespace = null;
            } else {
                attPrefix = attQName.substring(0, attIndex);
            }
            String attValue = atts.getValue(i);
            attributes[i] = new XMLAttribute(attNamespace, attPrefix, attName, attValue);
        }
        this.currentElement = new XMLElement(namespaceURI, prefix, name, attributes, this.currentElement);
        int len = this.contentHandlers.size();
        for (int i = 0; i < len; ++i) {
            ((XMLHandler)this.contentHandlers.elementAt(i)).startElement();
        }
    }

    public void startPrefixMapping(String arg0, String arg1) throws SAXException {
        if (this.validatorContentHandler != null) {
            this.validatorContentHandler.startPrefixMapping(arg0, arg1);
        }
    }

    public XMLElement getCurrentElement() {
        return this.currentElement;
    }

    public Report getReport() {
        return this.report;
    }

    public int getLineNumber() {
        return this.documentLocator.getLineNumber();
    }

    static {
        Hashtable<String, String> map = new Hashtable<String, String>();
        map.put("http://www.idpf.org/dtds/2007/opf.dtd", ResourceUtil.getResourcePath("dtd/opf20.dtd"));
        map.put("http://openebook.org/dtds/oeb-1.2/oeb12.ent", ResourceUtil.getResourcePath("dtd/oeb12.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd", ResourceUtil.getResourcePath("dtd/xhtml1-transitional.dtd"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd", ResourceUtil.getResourcePath("dtd/xhtml1-strict.dtd"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-lat1.ent", ResourceUtil.getResourcePath("dtd/xhtml-lat1.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-symbol.ent", ResourceUtil.getResourcePath("dtd/xhtml-symbol.dtdinc"));
        map.put("http://www.w3.org/TR/xhtml1/DTD/xhtml-special.ent", ResourceUtil.getResourcePath("dtd/xhtml-special.dtdinc"));
        map.put("http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd", ResourceUtil.getResourcePath("dtd/svg11.dtd"));
        map.put("http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd", ResourceUtil.getResourcePath("dtd/opf20.dtd"));
        map.put("http://www.daisy.org/z3986/2005/dtbook-2005-2.dtd", ResourceUtil.getResourcePath("dtd/dtbook-2005-2.dtd"));
        map.put("http://www.daisy.org/z3986/2005/ncx-2005-1.dtd", ResourceUtil.getResourcePath("dtd/ncx-2005-1.dtd"));
        map.put("xhtml-lat1.ent", ResourceUtil.getResourcePath("dtd/xhtml-lat1.dtdinc"));
        map.put("xhtml-symbol.ent", ResourceUtil.getResourcePath("dtd/xhtml-symbol.dtdinc"));
        map.put("xhtml-special.ent", ResourceUtil.getResourcePath("dtd/xhtml-special.dtdinc"));
        systemIdMap = map;
    }
}

