/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.parser.audio;

import com.sun.media.format.WavAudioFormat;
import com.sun.media.parser.BasicPullParser;
import com.sun.media.parser.BasicTrack;
import com.sun.media.util.SettableTime;
import java.io.IOException;
import javax.media.BadHeaderException;
import javax.media.Duration;
import javax.media.Format;
import javax.media.Time;
import javax.media.Track;
import javax.media.protocol.ContentDescriptor;
import javax.media.protocol.PullSourceStream;

public class WavParser
extends BasicPullParser {
    private Time duration = Duration.DURATION_UNKNOWN;
    private WavAudioFormat format = null;
    private Track[] tracks = new Track[1];
    private int numBuffers = 4;
    private int bufferSize;
    private int dataSize;
    private SettableTime mediaTime = new SettableTime(0L);
    private int encoding;
    private String encodingString;
    private int sampleRate;
    private int channels;
    private int sampleSizeInBits;
    private int blockAlign;
    private int samplesPerBlock;
    private long minLocation;
    private long maxLocation;
    private double locationToMediaTime = -1.0;
    private double timePerBlockNano = -1.0;
    private PullSourceStream stream = null;
    private static ContentDescriptor[] supportedFormat = new ContentDescriptor[]{new ContentDescriptor("audio.x_wav")};

    public ContentDescriptor[] getSupportedInputContentDescriptors() {
        return supportedFormat;
    }

    public Track[] getTracks() throws IOException, BadHeaderException {
        if (this.tracks[0] != null) {
            return this.tracks;
        }
        this.stream = (PullSourceStream)this.streams[0];
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(false);
        }
        this.readHeader();
        if (this.cacheStream != null) {
            this.cacheStream.setEnabledBuffering(true);
        }
        this.minLocation = this.getLocation(this.stream);
        this.maxLocation = this.minLocation + (long)this.dataSize;
        this.tracks[0] = new WavTrack(this.format, true, new Time(0L), this.numBuffers, this.bufferSize, this.minLocation, this.maxLocation);
        return this.tracks;
    }

    private void readHeader() throws IOException, BadHeaderException {
        int formatSize;
        String magicRIFF = this.readString(this.stream);
        if (!magicRIFF.equals("RIFF")) {
            throw new BadHeaderException("WAVE Parser: expected magic string RIFF, got " + magicRIFF);
        }
        int length = this.readInt(this.stream, false);
        String magicWAVE = this.readString(this.stream);
        if (!magicWAVE.equals("WAVE")) {
            throw new BadHeaderException("WAVE Parser: expected magic string WAVE, got " + magicWAVE);
        }
        length += 8;
        while (!this.readString(this.stream).equals("fmt ")) {
            int size = this.readInt(this.stream, false);
            this.skip(this.stream, size);
        }
        int remainingFormatSize = formatSize = this.readInt(this.stream, false);
        if (formatSize < 16) {
            // empty if block
        }
        this.encoding = this.readShort(this.stream, false);
        this.encodingString = (String)WavAudioFormat.formatMapper.get(new Integer(this.encoding));
        if (this.encodingString == null) {
            this.encodingString = "unknown";
        }
        this.channels = this.readShort(this.stream, false);
        this.sampleRate = this.readInt(this.stream, false);
        int bytesPerSecond = this.readInt(this.stream, false);
        this.blockAlign = this.readShort(this.stream, false);
        this.sampleSizeInBits = this.readShort(this.stream, false);
        if (this.encoding == 85) {
            this.sampleSizeInBits = 16;
        }
        this.samplesPerBlock = -1;
        if ((remainingFormatSize -= 16) > 0 && this.encoding == 1 || remainingFormatSize <= 2) {
            this.skip(this.stream, remainingFormatSize);
            remainingFormatSize = 0;
        }
        byte[] codecSpecificHeader = null;
        short extraFieldsSize = 0;
        if (remainingFormatSize >= 2) {
            extraFieldsSize = this.readShort(this.stream, false);
            remainingFormatSize -= 2;
            if (extraFieldsSize > 0) {
                codecSpecificHeader = new byte[extraFieldsSize];
                this.readBytes(this.stream, codecSpecificHeader, codecSpecificHeader.length);
                remainingFormatSize -= extraFieldsSize;
            }
        }
        switch (this.encoding) {
            case 2: 
            case 17: 
            case 49: {
                if (extraFieldsSize < 2) {
                    throw new BadHeaderException("msadpcm: samplesPerBlock field not available");
                }
                this.samplesPerBlock = BasicPullParser.parseShortFromArray(codecSpecificHeader, false);
                this.locationToMediaTime = (double)this.samplesPerBlock / (double)(this.sampleRate * this.blockAlign);
                break;
            }
            default: {
                this.locationToMediaTime = 1.0 / (double)(this.sampleRate * this.blockAlign);
            }
        }
        if (remainingFormatSize < 0) {
            throw new BadHeaderException("WAVE Parser: incorrect chunkSize in the fmt chunk");
        }
        if (remainingFormatSize > 0) {
            this.skip(this.stream, remainingFormatSize);
        }
        while (!this.readString(this.stream).equals("data")) {
            int size = this.readInt(this.stream, false);
            this.skip(this.stream, size);
        }
        this.dataSize = this.readInt(this.stream, false);
        this.bufferSize = this.blockAlign != 0 ? (bytesPerSecond < this.dataSize ? bytesPerSecond - bytesPerSecond % this.blockAlign : this.dataSize - this.dataSize % this.blockAlign) : (bytesPerSecond < this.dataSize ? bytesPerSecond : this.dataSize);
        double durationSeconds = -1.0;
        if (this.channels * this.sampleSizeInBits / 8 == this.blockAlign) {
            durationSeconds = (float)this.dataSize / (float)bytesPerSecond;
        } else if (this.samplesPerBlock > 0) {
            durationSeconds = (float)this.dataSize / (float)this.blockAlign * (float)this.samplesPerBlock / (float)this.sampleRate;
            this.timePerBlockNano = (double)this.samplesPerBlock * 1.0E9 / (double)this.sampleRate;
        } else {
            this.timePerBlockNano = (double)this.blockAlign * 1.0E9 / (double)bytesPerSecond;
            durationSeconds = (float)this.dataSize / (float)bytesPerSecond;
        }
        this.duration = new Time(durationSeconds);
        boolean signed = this.sampleSizeInBits > 8;
        this.format = new WavAudioFormat(this.encodingString, this.sampleRate, this.sampleSizeInBits, this.channels, this.blockAlign * 8, bytesPerSecond, 0, signed ? 1 : 0, -1.0f, Format.byteArray, codecSpecificHeader);
    }

    public Time setPosition(Time where, int rounding) {
        long newPos;
        if (!this.seekable) {
            return this.getMediaTime();
        }
        long time = where.getNanoseconds();
        if (time < 0L) {
            time = 0L;
        }
        if (this.timePerBlockNano <= 0.0) {
            int bytesPerSecond = this.sampleRate * this.blockAlign;
            double newPosd = (double)(time * (long)this.sampleRate * (long)this.blockAlign) / 1.0E9;
            double remainder = newPosd % (double)this.blockAlign;
            newPos = (long)(newPosd - remainder);
            if (remainder > 0.0) {
                switch (rounding) {
                    case 1: {
                        newPos += (long)this.blockAlign;
                        break;
                    }
                    case 3: {
                        if (!(remainder > (double)this.blockAlign / 2.0)) break;
                        newPos += (long)this.blockAlign;
                    }
                }
            }
        } else {
            double blockNum = (double)time / this.timePerBlockNano;
            int blockNumInt = (int)blockNum;
            double remainder = blockNum - (double)blockNumInt;
            if (remainder > 0.0) {
                switch (rounding) {
                    case 1: {
                        ++blockNumInt;
                        break;
                    }
                    case 3: {
                        if (!(remainder > 0.5)) break;
                        ++blockNumInt;
                    }
                }
            }
            newPos = blockNumInt * this.blockAlign;
        }
        ((BasicTrack)this.tracks[0]).setSeekLocation(newPos += this.minLocation);
        if (this.cacheStream != null) {
            WavParser wavParser = this;
            synchronized (wavParser) {
                this.cacheStream.abortRead();
            }
        }
        return where;
    }

    public Time getMediaTime() {
        long seekLocation = ((BasicTrack)this.tracks[0]).getSeekLocation();
        long location = seekLocation != -1L ? seekLocation - this.minLocation : this.getLocation(this.stream) - this.minLocation;
        SettableTime settableTime = this.mediaTime;
        synchronized (settableTime) {
            this.mediaTime.set((double)location * this.locationToMediaTime);
        }
        return this.mediaTime;
    }

    public Time getDuration() {
        return this.duration;
    }

    public String getName() {
        return "Parser for WAV file format";
    }

    class WavTrack
    extends BasicTrack {
        private double sampleRate;
        private float timePerFrame;
        private SettableTime frameToTime = new SettableTime();

        WavTrack(WavAudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize, long minLocation, long maxLocation) {
            super(WavParser.this, format, enabled, WavParser.this.duration, startTime, numBuffers, bufferSize, WavParser.this.stream, minLocation, maxLocation);
            double sampleRate = format.getSampleRate();
            int channels = format.getChannels();
            int sampleSizeInBits = format.getSampleSizeInBits();
            int blockSize = format.getFrameSizeInBits() / 8;
            if (WavParser.this.encoding == 1 || WavParser.this.encoding == 7 || WavParser.this.encoding == 6 || WavParser.this.encoding == 257 || WavParser.this.encoding == 258) {
                float bytesPerSecond = (float)sampleRate * (float)blockSize;
                float bytesPerFrame = bufferSize;
                this.timePerFrame = (float)bufferSize / bytesPerSecond;
            } else if (WavParser.this.encoding == 2 || WavParser.this.encoding == 17 || WavParser.this.encoding == 49) {
                float bytesPerFrame = bufferSize;
                float blocksPerFrame = (float)bufferSize / (float)blockSize;
                float samplesPerFrame = blocksPerFrame * (float)WavParser.this.samplesPerBlock;
                this.timePerFrame = (float)((double)samplesPerFrame / sampleRate);
            } else {
                float bytesPerSecond = (float)sampleRate * (float)blockSize;
                float bytesPerFrame = bufferSize;
                this.timePerFrame = (float)bufferSize / bytesPerSecond;
            }
        }

        WavTrack(WavAudioFormat format, boolean enabled, Time startTime, int numBuffers, int bufferSize) {
            this(format, enabled, startTime, numBuffers, bufferSize, 0L, Long.MAX_VALUE);
        }
    }
}

