/*
 * Decompiled with CFR 0.152.
 */
package org.flexdock.demos.raw.elegant;

import java.awt.Component;
import java.awt.Container;
import javax.swing.JFrame;
import org.flexdock.demos.raw.elegant.ElegantPanel;
import org.flexdock.demos.util.DemoUtility;
import org.flexdock.docking.DockingConstants;
import org.flexdock.docking.DockingManager;
import org.flexdock.docking.DockingPort;
import org.flexdock.docking.defaults.DefaultDockingPort;
import org.flexdock.docking.defaults.StandardBorderManager;
import org.flexdock.plaf.common.border.ShadowBorder;

public class ElegantDemo
extends JFrame
implements DockingConstants {
    private ElegantPanel j2eeHierarchyView;
    private ElegantPanel j2eeNavView;
    private ElegantPanel consoleView;
    private ElegantPanel serversView;
    private ElegantPanel tasksView;
    private ElegantPanel searchView;
    private ElegantPanel synchronizeView;
    private ElegantPanel outlineView;
    private ElegantPanel editorView;
    private DockingPort rootDockingPort;

    public ElegantDemo() {
        super("Elegant Docking Demo");
        this.init();
    }

    private void init() {
        this.createViews();
        this.setContentPane((Container)((Object)this.getRootDockingPort()));
        this.initLayout();
    }

    private DockingPort getRootDockingPort() {
        if (this.rootDockingPort == null) {
            DefaultDockingPort port = new DefaultDockingPort();
            port.setBorderManager(new StandardBorderManager(new ShadowBorder()));
            this.rootDockingPort = port;
        }
        return this.rootDockingPort;
    }

    private void createViews() {
        this.j2eeHierarchyView = new ElegantPanel("J2EE Hierarchy");
        this.j2eeNavView = new ElegantPanel("J2EE Navigator");
        this.consoleView = new ElegantPanel("Console");
        this.serversView = new ElegantPanel("Servers");
        this.tasksView = new ElegantPanel("Tasks");
        this.searchView = new ElegantPanel("Search");
        this.synchronizeView = new ElegantPanel("Synchronize");
        this.outlineView = new ElegantPanel("Outline");
        this.editorView = new ElegantPanel("Editor");
    }

    private void initLayout() {
        DockingManager.setDefaultPersistenceKey("ElegantDemo.xml");
        try {
            if (!DockingManager.restoreLayout(true)) {
                this.setupDefaultLayout();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setupDefaultLayout();
        }
        DockingManager.setAutoPersist(true);
    }

    private void setupDefaultLayout() {
        this.getRootDockingPort().clear();
        DockingManager.dock((Component)this.editorView, this.getRootDockingPort());
        this.editorView.dock(this.j2eeHierarchyView, "WEST", 0.3f);
        this.j2eeHierarchyView.dock(this.outlineView, "SOUTH", 0.3f);
        this.editorView.dock(this.tasksView, "SOUTH", 0.3f);
        this.j2eeHierarchyView.dock(this.j2eeNavView);
        this.tasksView.dock(this.serversView);
        this.tasksView.dock(this.consoleView);
        this.tasksView.dock(this.searchView);
        this.tasksView.dock(this.synchronizeView);
    }

    public static void main(String[] args) {
        ElegantDemo demo = new ElegantDemo();
        DemoUtility.setCloseOperation(demo);
        demo.setSize(800, 600);
        demo.setVisible(true);
    }
}

