/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Component;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.FontLibrary;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.SwingGUI;
import net.sf.freecol.client.gui.panel.FreeColProgressBar;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.util.StringUtils;

public class ConstructionPanel
extends MigPanel
implements PropertyChangeListener {
    public static final String EVENT = Colony.ColonyChangeEvent.BUILD_QUEUE_CHANGE.toString();
    private final FreeColClient freeColClient;
    private final boolean openBuildQueue;
    private Colony colony;
    private StringTemplate defaultLabel = StringTemplate.key("constructionPanel.clickToBuild");

    public ConstructionPanel(FreeColClient freeColClient, Colony colony, boolean openBuildQueue) {
        super("ConstructionPanelUI");
        this.freeColClient = freeColClient;
        this.colony = colony;
        this.openBuildQueue = openBuildQueue;
        this.setLayout(new MigLayout("fill, gapy 2:5, wrap 2", "push[]10[center]push"));
        this.setOpaque(openBuildQueue);
    }

    public void setColony(Colony newColony) {
        if (newColony != this.colony) {
            this.cleanup();
            this.colony = newColony;
            this.initialize();
        }
    }

    public void initialize() {
        if (this.colony != null) {
            this.colony.addPropertyChangeListener(EVENT, this);
            if (this.openBuildQueue) {
                this.addMouseListener(new MouseAdapter(){

                    @Override
                    public void mousePressed(MouseEvent e) {
                        ((SwingGUI)ConstructionPanel.this.freeColClient.getGUI()).showBuildQueuePanel(ConstructionPanel.this.colony);
                    }
                });
            }
        }
        this.update();
    }

    public void cleanup() {
        if (this.colony != null) {
            this.colony.removePropertyChangeListener(EVENT, this);
        }
        for (MouseListener listener : this.getMouseListeners()) {
            this.removeMouseListener(listener);
        }
    }

    public void update() {
        this.update(this.colony == null ? null : this.colony.getCurrentlyBuilding());
    }

    public void update(BuildableType buildable) {
        this.removeAll();
        ImageLibrary lib = ((SwingGUI)this.freeColClient.getGUI()).getTileImageLibrary();
        Font font = FontLibrary.createFont(FontLibrary.FontType.NORMAL, FontLibrary.FontSize.SMALLER, lib.getScaleFactor());
        if (buildable == null) {
            String clickToBuild = Messages.message(this.getDefaultLabel());
            int breakingPoint = StringUtils.getBreakingPoint(clickToBuild);
            if (breakingPoint > 0) {
                JLabel label0 = new JLabel(clickToBuild.substring(0, breakingPoint));
                label0.setFont(font);
                this.add((Component)label0, "span, align center");
                JLabel label1 = new JLabel(clickToBuild.substring(breakingPoint + 1));
                label1.setFont(font);
                this.add((Component)label1, "span, align center");
            } else {
                JLabel label = new JLabel(clickToBuild);
                label.setFont(font);
                this.add((Component)label, "span, align center");
            }
        } else {
            int turns = this.colony.getTurnsToComplete(buildable);
            BufferedImage image = lib.getSmallBuildableImage(buildable, this.colony.getOwner());
            this.add((Component)new JLabel(new ImageIcon(image)), "spany");
            JLabel label0 = Utility.localizedLabel(buildable.getCurrentlyBuildingLabel());
            label0.setFont(font);
            this.add(label0);
            JLabel label1 = Utility.localizedLabel(StringTemplate.template("constructionPanel.turnsToComplete").addName("%number%", Turn.getTurnsText(turns)));
            label1.setFont(font);
            this.add(label1);
            for (AbstractGoods ag : buildable.getRequiredGoods()) {
                int amountNeeded = ag.getAmount();
                int amountAvailable = this.colony.getGoodsCount(ag.getType());
                int amountProduced = this.colony.getAdjustedNetProductionOf(ag.getType());
                this.add((Component)new FreeColProgressBar(ag.getType(), 0, amountNeeded, amountAvailable, amountProduced), "height 20:");
            }
        }
        this.revalidate();
        this.repaint();
    }

    public final StringTemplate getDefaultLabel() {
        return this.defaultLabel;
    }

    public final void setDefaultLabel(StringTemplate newDefaultLabel) {
        this.defaultLabel = newDefaultLabel;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        this.update();
    }
}

