/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.option;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.option.AbstractOption;

public class IntegerOption
extends AbstractOption<Integer> {
    private static final Logger logger = Logger.getLogger(IntegerOption.class.getName());
    private int value;
    private int maximumValue = Integer.MAX_VALUE;
    private int minimumValue = Integer.MIN_VALUE;
    private static final String MAXIMUM_VALUE_TAG = "maximumValue";
    private static final String MINIMUM_VALUE_TAG = "minimumValue";

    public IntegerOption(Specification specification) {
        super(specification);
    }

    public IntegerOption(String id, Specification specification) {
        super(id, specification);
    }

    public int getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(int minimumValue) {
        this.minimumValue = minimumValue;
    }

    public int getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(int maximumValue) {
        this.maximumValue = maximumValue;
    }

    public int limitValue(int value) {
        return Math.min(Math.max(value, this.minimumValue), this.maximumValue);
    }

    @Override
    public IntegerOption clone() {
        IntegerOption result = new IntegerOption(this.getId(), this.getSpecification());
        result.setValues(this);
        result.minimumValue = this.minimumValue;
        result.maximumValue = this.maximumValue;
        return result;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }

    @Override
    public void setValue(Integer value) {
        int oldValue = this.value;
        this.value = this.limitValue(value);
        if (value != oldValue && this.isDefined) {
            this.firePropertyChange("value", oldValue, value);
        }
        this.isDefined = true;
    }

    @Override
    protected void setValue(String valueString, String defaultValueString) {
        String str = valueString != null ? valueString : defaultValueString;
        try {
            this.setValue(Integer.valueOf(str));
        }
        catch (NumberFormatException nfe) {
            logger.log(Level.WARNING, "IntegerOption fail: " + str, nfe);
        }
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        xw.writeAttribute("value", this.value);
        if (this.maximumValue < Integer.MAX_VALUE) {
            xw.writeAttribute(MAXIMUM_VALUE_TAG, this.maximumValue);
        }
        if (this.minimumValue > Integer.MIN_VALUE) {
            xw.writeAttribute(MINIMUM_VALUE_TAG, this.minimumValue);
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        this.maximumValue = xr.getAttribute(MAXIMUM_VALUE_TAG, Integer.MAX_VALUE);
        this.minimumValue = xr.getAttribute(MINIMUM_VALUE_TAG, Integer.MIN_VALUE);
        this.value = this.limitValue(this.value);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(16);
        sb.append("[").append(this.getId()).append(" value=").append(this.value).append("]");
        return sb.toString();
    }

    @Override
    public String getXMLTagName() {
        return IntegerOption.getXMLElementTagName();
    }

    public static String getXMLElementTagName() {
        return "integerOption";
    }
}

