/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap.stringparsers;

import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.ParseException;
import com.martiansoftware.jsap.PropertyStringParser;
import com.martiansoftware.jsap.stringparsers.BooleanStringParser;
import java.io.File;

public class FileStringParser
extends PropertyStringParser {
    public static final String MUSTBEFILE = "mustBeFile";
    public static final String MUSTBEDIRECTORY = "mustBeDirectory";
    public static final String MUSTEXIST = "mustExist";
    private boolean mustExist = false;
    private boolean mustBeDirectory = false;
    private boolean mustBeFile = false;

    public static FileStringParser getParser() {
        return new FileStringParser();
    }

    @Override
    public void setUp() throws ParseException {
        BooleanStringParser bool = JSAP.BOOLEAN_PARSER;
        this.setMustExist((Boolean)bool.parse(this.getProperty(MUSTEXIST, new Boolean(this.mustExist).toString())));
        this.setMustBeDirectory((Boolean)bool.parse(this.getProperty(MUSTBEDIRECTORY, new Boolean(this.mustBeDirectory).toString())));
        this.setMustBeFile((Boolean)bool.parse(this.getProperty(MUSTBEFILE, new Boolean(this.mustBeFile).toString())));
    }

    public FileStringParser setMustBeDirectory(boolean mustBeDirectory) {
        this.mustBeDirectory = mustBeDirectory;
        return this;
    }

    public FileStringParser setMustBeFile(boolean mustBeFile) {
        this.mustBeFile = mustBeFile;
        return this;
    }

    public FileStringParser setMustExist(boolean mustExist) {
        this.mustExist = mustExist;
        return this;
    }

    public boolean mustBeDirectory() {
        return this.mustBeDirectory;
    }

    public boolean mustBeFile() {
        return this.mustBeFile;
    }

    public boolean mustExist() {
        return this.mustExist;
    }

    @Override
    public void tearDown() {
    }

    @Override
    public Object parse(String arg) throws ParseException {
        File result = null;
        try {
            result = new File(arg);
            if (this.mustExist() && !result.exists()) {
                throw new ParseException(result + " does not exist.");
            }
            if (this.mustBeDirectory() && result.exists() && !result.isDirectory()) {
                throw new ParseException(result + " is not a directory.");
            }
            if (this.mustBeFile() && result.exists() && result.isDirectory()) {
                throw new ParseException(result + " is not a file.");
            }
        }
        catch (NullPointerException e) {
            throw new ParseException("No File given to parse", e);
        }
        return result;
    }
}

