/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.instruction.bytecode.factory;

import java.util.List;
import java.util.Stack;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Method;
import jd.core.model.instruction.bytecode.ByteCodeConstants;
import jd.core.model.instruction.bytecode.instruction.BinaryOperatorInstruction;
import jd.core.model.instruction.bytecode.instruction.Instruction;
import jd.core.process.analyzer.instruction.bytecode.factory.InstructionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryOperatorFactory
extends InstructionFactory {
    protected int priority;
    protected String signature;
    protected String operator;

    public BinaryOperatorFactory(int priority, String signature, String operator) {
        this.priority = priority;
        this.signature = signature;
        this.operator = operator;
    }

    @Override
    public int create(ClassFile classFile, Method method, List<Instruction> list, List<Instruction> listForAnalyze, Stack<Instruction> stack, byte[] code, int offset, int lineNumber, boolean[] jumps) {
        int opcode = code[offset] & 0xFF;
        Instruction i2 = stack.pop();
        Instruction i1 = stack.pop();
        BinaryOperatorInstruction instruction = new BinaryOperatorInstruction(267, offset, lineNumber, this.priority, this.signature, this.operator, i1, i2);
        stack.push(instruction);
        listForAnalyze.add(instruction);
        return ByteCodeConstants.NO_OF_OPERANDS[opcode];
    }
}

