/*
 * Decompiled with CFR 0.152.
 */
package jd.core.process.analyzer.variable;

import java.util.HashSet;
import jd.core.model.classfile.ClassFile;
import jd.core.model.classfile.Field;
import jd.core.process.analyzer.variable.VariableNameGenerator;

public class DefaultVariableNameGenerator
implements VariableNameGenerator {
    private HashSet<String> fieldNames = new HashSet();
    private HashSet<String> localNames = new HashSet();

    public DefaultVariableNameGenerator(ClassFile classFile) {
        Field[] fields = classFile.getFields();
        if (fields != null) {
            int i = 0;
            while (i < fields.length) {
                this.fieldNames.add(classFile.getConstantPool().getConstantUtf8(fields[i].name_index));
                ++i;
            }
        }
    }

    public void clearLocalNames() {
        this.localNames.clear();
    }

    public String generateParameterNameFromSignature(String signature, boolean appearsOnceFlag, boolean varargsFlag, int anonymousClassDepth) {
        String prefix;
        switch (anonymousClassDepth) {
            case 0: {
                prefix = "param";
                break;
            }
            case 1: {
                prefix = "paramAnonymous";
                break;
            }
            default: {
                prefix = "paramAnonymous" + anonymousClassDepth;
            }
        }
        if (varargsFlag) {
            return String.valueOf(prefix) + "VarArgs";
        }
        int index = DefaultVariableNameGenerator.CountDimensionOfArray(signature);
        if (index > 0) {
            prefix = String.valueOf(prefix) + "ArrayOf";
        }
        return this.generateValidName(String.valueOf(prefix) + DefaultVariableNameGenerator.GetSuffixFromSignature(signature.substring(index)), appearsOnceFlag);
    }

    public String generateLocalVariableNameFromSignature(String signature, boolean appearsOnce) {
        int index = DefaultVariableNameGenerator.CountDimensionOfArray(signature);
        if (index > 0) {
            return this.generateValidName("arrayOf" + DefaultVariableNameGenerator.GetSuffixFromSignature(signature.substring(index)), appearsOnce);
        }
        switch (signature.charAt(0)) {
            case 'L': {
                String s = DefaultVariableNameGenerator.FormatSignature(signature);
                if (s.equals("String")) {
                    return this.generateValidName("str", appearsOnce);
                }
                return this.generateValidName("local" + s, appearsOnce);
            }
            case 'B': {
                return this.generateValidName("b", appearsOnce);
            }
            case 'C': {
                return this.generateValidName("c", appearsOnce);
            }
            case 'D': {
                return this.generateValidName("d", appearsOnce);
            }
            case 'F': {
                return this.generateValidName("f", appearsOnce);
            }
            case 'I': {
                return this.generateValidIntName(appearsOnce);
            }
            case 'J': {
                return this.generateValidName("l", appearsOnce);
            }
            case 'S': {
                return this.generateValidName("s", appearsOnce);
            }
            case 'Z': {
                return this.generateValidName("bool", appearsOnce);
            }
        }
        new Throwable("NameGenerator.generateParameterNameFromSignature: invalid signature '" + signature + "'").printStackTrace();
        return "?";
    }

    private static int CountDimensionOfArray(String signature) {
        int index = 0;
        int length = signature.length();
        if (signature.charAt(index) == '[') {
            while (++index < length) {
                if (signature.charAt(index) == 'L' && index + 1 < length && signature.charAt(index + 1) == '[') {
                    ++index;
                    --length;
                    continue;
                }
                if (signature.charAt(index) != '[') break;
            }
        }
        return index;
    }

    private static String GetSuffixFromSignature(String signature) {
        switch (signature.charAt(0)) {
            case 'L': {
                return DefaultVariableNameGenerator.FormatSignature(signature);
            }
            case 'B': {
                return "Byte";
            }
            case 'C': {
                return "Char";
            }
            case 'D': {
                return "Double";
            }
            case 'F': {
                return "Float";
            }
            case 'I': {
                return "Int";
            }
            case 'J': {
                return "Long";
            }
            case 'S': {
                return "Short";
            }
            case 'Z': {
                return "Boolean";
            }
            case '[': {
                return "Array";
            }
            case 'T': {
                return DefaultVariableNameGenerator.FormatTemplate(signature);
            }
        }
        new Throwable("NameGenerator.generateParameterNameFromSignature: invalid signature '" + signature + "'").printStackTrace();
        return "?";
    }

    private static String FormatSignature(String signature) {
        int index = (signature = signature.substring(1, signature.length() - 1)).indexOf(60);
        if (index != -1) {
            signature = signature.substring(0, index);
        }
        if ((index = signature.lastIndexOf(36)) != -1) {
            signature = signature.substring(index + 1);
        }
        if ((index = signature.lastIndexOf(47)) != -1) {
            signature = signature.substring(index + 1);
        }
        return signature;
    }

    private static String FormatTemplate(String signature) {
        return signature.substring(1, signature.length() - 1);
    }

    private String generateValidName(String name, boolean appearsOnceFlag) {
        if (Character.isUpperCase(name.charAt(0))) {
            name = String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
        }
        if (appearsOnceFlag && !this.fieldNames.contains(name) && !this.localNames.contains(name)) {
            this.localNames.add(name);
            return name;
        }
        int index = 1;
        while (true) {
            String newName;
            if (!this.fieldNames.contains(newName = String.valueOf(name) + index) && !this.localNames.contains(newName)) {
                this.localNames.add(newName);
                return newName;
            }
            ++index;
        }
    }

    private String generateValidIntName(boolean appearsOnce) {
        if (!this.fieldNames.contains("i") && !this.localNames.contains("i")) {
            this.localNames.add("i");
            return "i";
        }
        if (!this.fieldNames.contains("j") && !this.localNames.contains("j")) {
            this.localNames.add("j");
            return "j";
        }
        if (!this.fieldNames.contains("k") && !this.localNames.contains("k")) {
            this.localNames.add("k");
            return "k";
        }
        if (!this.fieldNames.contains("m") && !this.localNames.contains("m")) {
            this.localNames.add("m");
            return "m";
        }
        if (!this.fieldNames.contains("n") && !this.localNames.contains("n")) {
            this.localNames.add("n");
            return "n";
        }
        return this.generateValidName("i", false);
    }
}

