/*
 * Decompiled with CFR 0.152.
 */
package free.jin;

import free.jin.I18n;
import free.jin.Server;
import free.jin.User;
import free.jin.UsernamePolicy;
import free.util.IOUtilities;
import free.util.TextUtilities;
import java.io.IOException;
import java.util.Properties;

public abstract class AbstractServer
implements Server {
    private I18n i18n;
    private final Properties props;
    private final UsernamePolicy usernamePolicy;
    private User guest;

    protected AbstractServer() {
        try {
            this.props = IOUtilities.loadProperties(this.getClass().getResource("properties"), true);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("No properties file found");
        }
        this.usernamePolicy = this.createUsernamePolicy();
    }

    protected abstract UsernamePolicy createUsernamePolicy();

    public I18n getI18n() {
        if (this.i18n == null) {
            this.i18n = I18n.get(this.getClass(), AbstractServer.class);
        }
        return this.i18n;
    }

    public final UsernamePolicy getUsernamePolicy() {
        return this.usernamePolicy;
    }

    public synchronized void setGuestUser(User user) {
        if (this.guest != null) {
            throw new IllegalStateException("Guest already created");
        }
        String string = this.usernamePolicy.getGuestUsername();
        this.guest = user != null ? user : new User(this, string);
    }

    public User getGuest() {
        return this.guest;
    }

    public String getDefaultHost() {
        return this.props.getProperty("defaultHost");
    }

    public String[] getHosts() {
        return TextUtilities.getTokens(this.props.getProperty("hosts"), " ");
    }

    public void setHost(String string) {
        this.props.put("defaultHost", string);
        this.props.put("hosts", string);
    }

    public int[] getPorts() {
        return TextUtilities.parseIntList(this.props.getProperty("ports"), " ");
    }

    public void setPort(int n) {
        this.props.put("ports", String.valueOf(n));
    }

    public String getId() {
        return this.props.getProperty("id");
    }

    public String getShortName() {
        return this.getI18n().getString(this.props.getProperty("shortNameKey"));
    }

    public String getLongName() {
        return this.getI18n().getString(this.props.getProperty("longNameKey"));
    }

    public String getWebsite() {
        return this.props.getProperty("website");
    }

    public String getRegistrationPage() {
        return this.props.getProperty("registrationPage");
    }

    public String getPasswordRetrievalPage() {
        return this.props.getProperty("passwordRetrievalPage");
    }

    public String toString() {
        return this.getLongName() + " (" + this.getWebsite() + ")";
    }
}

