/*
 * Decompiled with CFR 0.152.
 */
package free.chess;

import free.chess.AbstractChessClock;
import free.util.GraphicsUtilities;
import free.util.TextUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class JChessClock
extends AbstractChessClock {
    private Color activeBG = Color.blue;
    private Color activeFG = Color.white;
    private Color inactiveBG = null;
    private Color inactiveFG = Color.black;
    private final Dimension lastSize = new Dimension();
    private Font lastFont = null;
    private FontMetrics lastFontMetrics = null;

    public JChessClock(int n) {
        super(n);
        this.setFont(new Font("Monospaced", 1, 50));
    }

    public void setActiveBackground(Color color) {
        this.activeBG = color;
    }

    public Color getActiveBackground() {
        return this.activeBG;
    }

    public void setActiveForeground(Color color) {
        this.activeFG = color;
    }

    public Color getActiveForeground() {
        return this.activeFG;
    }

    public void setInactiveBackground(Color color) {
        this.inactiveBG = color;
    }

    public Color getInactiveBackground() {
        return this.inactiveBG;
    }

    public void setInactiveForeground(Color color) {
        this.inactiveFG = color;
    }

    public Color getInactiveForeground() {
        return this.inactiveFG;
    }

    public void setActive(boolean bl) {
        super.setActive(bl);
        this.repaint();
    }

    protected String createTimeString(int n) {
        boolean bl = n < 0;
        n = Math.abs(n);
        int n2 = n / 3600000;
        int n3 = (n -= n2 * 1000 * 60 * 60) / 60000;
        int n4 = (n -= n3 * 1000 * 60) / 1000;
        int n5 = (n -= n4 * 1000) / 100;
        n -= n5 * 100;
        String string = bl ? "-" : "";
        switch (this.getActualDisplayMode()) {
            case 0: {
                String string2 = Math.abs(n5) > 4 || !this.isRunning() ? ":" : " ";
                return string + String.valueOf(n2) + string2 + TextUtilities.padStart((String)String.valueOf(n3), (char)'0', (int)2);
            }
            case 1: {
                return string + TextUtilities.padStart((String)String.valueOf(60 * n2 + n3), (char)'0', (int)2) + "." + TextUtilities.padStart((String)String.valueOf(n4), (char)'0', (int)2);
            }
            case 2: {
                return string + TextUtilities.padStart((String)String.valueOf(60 * n2 + n3), (char)'0', (int)2) + "." + TextUtilities.padStart((String)String.valueOf(n4), (char)'0', (int)2) + "." + String.valueOf(n5);
            }
        }
        throw new IllegalStateException("Bad display mode value: " + this.getDisplayMode());
    }

    protected Font findLargestFittingFont(String string, int n, int n2, Graphics graphics, Font font) {
        int n3 = GraphicsUtilities.getMaxFittingFontSize((Graphics)graphics, (Font)font, (String)string, (Dimension)new Dimension(n, n2));
        return new Font(font.getName(), font.getStyle(), n3);
    }

    public void paintComponent(Graphics graphics) {
        Color color;
        String string = this.createTimeString(this.getTime());
        int n = this.getWidth();
        int n2 = this.getHeight();
        if (n != this.lastSize.width || n2 != this.lastSize.height) {
            this.lastSize.width = this.getWidth();
            this.lastSize.height = this.getHeight();
            this.lastFont = this.findLargestFittingFont(string, this.lastSize.width, this.lastSize.height, graphics, this.getFont());
            this.lastFontMetrics = graphics.getFontMetrics(this.lastFont);
        }
        Color color2 = color = this.isActive() ? this.getActiveBackground() : this.getInactiveBackground();
        if (color != null) {
            graphics.setColor(color);
            graphics.fillRect(0, 0, n, n2);
        }
        Color color3 = this.isActive() ? this.getActiveForeground() : this.getInactiveForeground();
        graphics.setColor(color3);
        graphics.setFont(this.lastFont);
        int n3 = 0;
        int n4 = this.lastFontMetrics.getMaxAscent();
        graphics.drawString(string, n3, n4);
    }

    public Dimension getPreferredSize() {
        String string = this.createTimeString(this.getTime());
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), 50);
        FontMetrics fontMetrics = GraphicsUtilities.getFontMetrics((Font)font2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        return new Dimension(n, n2);
    }

    public Dimension getMinimumSize() {
        String string = this.createTimeString(this.getTime());
        Font font = this.getFont();
        Font font2 = new Font(font.getName(), font.getStyle(), 12);
        FontMetrics fontMetrics = GraphicsUtilities.getFontMetrics((Font)font2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent();
        return new Dimension(n, n2);
    }
}

