/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.transform.node.incoming;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.config.JitsiConfig;
import org.jitsi.metaconfig.ConfigDelegate;
import org.jitsi.metaconfig.SupplierBuilder;
import org.jitsi.metaconfig.supplier.FallbackSupplier;
import org.jitsi.nlj.AudioLevelListener;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.rtp.AudioRtpPacket;
import org.jitsi.nlj.rtp.RtpExtensionType;
import org.jitsi.nlj.stats.NodeStatsBlock;
import org.jitsi.nlj.transform.node.ObserverNode;
import org.jitsi.nlj.transform.node.incoming.Stats;
import org.jitsi.nlj.util.ReadOnlyStreamInformationStore;
import org.jitsi.rtp.extensions.unsigned.UnsignedKt;
import org.jitsi.rtp.rtp.RtpPacket;
import org.jitsi.rtp.rtp.header_extensions.AudioLevelHeaderExtension;
import org.jitsi.utils.OrderedJsonObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u0000 #2\u00020\u0001:\u0002\"#B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0015\u0010\u0006\u001a\u00060\u0007R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0015\u0010\n\u001a\u00060\u0007R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0012\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0015\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u0006$"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader;", "", "streamInformationStore", "Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;", "<init>", "(Lorg/jitsi/nlj/util/ReadOnlyStreamInformationStore;)V", "preDecryptNode", "Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader$AudioLevelReaderNode;", "getPreDecryptNode", "()Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader$AudioLevelReaderNode;", "postDecryptNode", "getPostDecryptNode", "audioLevelExtId", "", "Ljava/lang/Integer;", "audioLevelListener", "Lorg/jitsi/nlj/AudioLevelListener;", "getAudioLevelListener", "()Lorg/jitsi/nlj/AudioLevelListener;", "setAudioLevelListener", "(Lorg/jitsi/nlj/AudioLevelListener;)V", "forwardedSilencePackets", "getForwardedSilencePackets", "()I", "setForwardedSilencePackets", "(I)V", "stats", "Lorg/jitsi/nlj/transform/node/incoming/Stats;", "forceMute", "", "getForceMute", "()Z", "setForceMute", "(Z)V", "AudioLevelReaderNode", "Companion", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nAudioLevelReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AudioLevelReader.kt\norg/jitsi/nlj/transform/node/incoming/AudioLevelReader\n+ 2 Delegates.kt\norg/jitsi/metaconfig/DelegatesKt\n*L\n1#1,153:1\n68#2,6:154\n68#2,6:160\n*S KotlinDebug\n*F\n+ 1 AudioLevelReader.kt\norg/jitsi/nlj/transform/node/incoming/AudioLevelReader\n*L\n118#1:154,6\n121#1:160,6\n*E\n"})
public final class AudioLevelReader {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final AudioLevelReaderNode preDecryptNode;
    @NotNull
    private final AudioLevelReaderNode postDecryptNode;
    @Nullable
    private Integer audioLevelExtId;
    @Nullable
    private AudioLevelListener audioLevelListener;
    private int forwardedSilencePackets;
    @NotNull
    private final Stats stats;
    private boolean forceMute;
    public static final int MUTED_LEVEL = 127;
    @NotNull
    private static final ConfigDelegate<Integer> forwardedSilencePacketsLimit$delegate;
    @NotNull
    private static final ConfigDelegate<Boolean> discardSilence$delegate;

    public AudioLevelReader(@NotNull ReadOnlyStreamInformationStore streamInformationStore) {
        Intrinsics.checkNotNullParameter(streamInformationStore, "streamInformationStore");
        this.preDecryptNode = new AudioLevelReaderNode("AudioLevelReader_pre_srtp", AudioLevelReader::preDecryptNode$lambda$0);
        this.postDecryptNode = new AudioLevelReaderNode("AudioLevelReader_post_srtp", AudioLevelReader::postDecryptNode$lambda$1);
        this.stats = new Stats(0L, 0L, 0L, 0L, 0L, 0L, 63, null);
        streamInformationStore.onRtpExtensionMapping(RtpExtensionType.SSRC_AUDIO_LEVEL, arg_0 -> AudioLevelReader._init_$lambda$2(this, arg_0));
    }

    @NotNull
    public final AudioLevelReaderNode getPreDecryptNode() {
        return this.preDecryptNode;
    }

    @NotNull
    public final AudioLevelReaderNode getPostDecryptNode() {
        return this.postDecryptNode;
    }

    @Nullable
    public final AudioLevelListener getAudioLevelListener() {
        return this.audioLevelListener;
    }

    public final void setAudioLevelListener(@Nullable AudioLevelListener audioLevelListener) {
        this.audioLevelListener = audioLevelListener;
    }

    public final int getForwardedSilencePackets() {
        return this.forwardedSilencePackets;
    }

    public final void setForwardedSilencePackets(int n) {
        this.forwardedSilencePackets = n;
    }

    public final boolean getForceMute() {
        return this.forceMute;
    }

    public final void setForceMute(boolean bl) {
        this.forceMute = bl;
    }

    private static final boolean preDecryptNode$lambda$0(PacketInfo it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return !it.getOriginalHadCryptex();
    }

    private static final boolean postDecryptNode$lambda$1(PacketInfo it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return it.getOriginalHadCryptex();
    }

    private static final Unit _init_$lambda$2(AudioLevelReader this$0, Integer it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        this$0.audioLevelExtId = it;
        return Unit.INSTANCE;
    }

    static {
        SupplierBuilder supplierBuilder;
        Companion = new Companion(null);
        boolean $i$f$config = false;
        SupplierBuilder $this$forwardedSilencePacketsLimit_delegate_u24lambda_u243 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Integer.TYPE));
        boolean bl = false;
        $this$forwardedSilencePacketsLimit_delegate_u24lambda_u243.from("jmt.audio.level.forwarded-silence-packets-limit", JitsiConfig.Companion.getNewConfig());
        SupplierBuilder supplierBuilder$iv = supplierBuilder;
        forwardedSilencePacketsLimit$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
        $i$f$config = false;
        SupplierBuilder $this$discardSilence_delegate_u24lambda_u244 = supplierBuilder = new SupplierBuilder(Reflection.typeOf(Boolean.TYPE));
        boolean bl2 = false;
        $this$discardSilence_delegate_u24lambda_u244.from("jmt.audio.level.discard-silence", JitsiConfig.Companion.getNewConfig());
        supplierBuilder$iv = supplierBuilder;
        discardSilence$delegate = supplierBuilder$iv.getSuppliers().size() == 1 ? new ConfigDelegate(CollectionsKt.first(supplierBuilder$iv.getSuppliers())) : new ConfigDelegate(new FallbackSupplier(supplierBuilder$iv.getSuppliers()));
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0006H\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0016\u0010\u0013\u001a\u00020\r2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\r0\u0015H\u0016R\u001d\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader$AudioLevelReaderNode;", "Lorg/jitsi/nlj/transform/node/ObserverNode;", "name", "", "shouldProcess", "Lkotlin/Function1;", "Lorg/jitsi/nlj/PacketInfo;", "", "<init>", "(Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader;Ljava/lang/String;Lkotlin/jvm/functions/Function1;)V", "getShouldProcess", "()Lkotlin/jvm/functions/Function1;", "observe", "", "packetInfo", "getNodeStats", "Lorg/jitsi/nlj/stats/NodeStatsBlock;", "statsJson", "Lorg/jitsi/utils/OrderedJsonObject;", "trace", "f", "Lkotlin/Function0;", "jitsi-media-transform"})
    public final class AudioLevelReaderNode
    extends ObserverNode {
        @NotNull
        private final Function1<PacketInfo, Boolean> shouldProcess;

        public AudioLevelReaderNode(@NotNull String name, Function1<? super PacketInfo, Boolean> shouldProcess) {
            Intrinsics.checkNotNullParameter(name, "name");
            Intrinsics.checkNotNullParameter(shouldProcess, "shouldProcess");
            super(name);
            this.shouldProcess = shouldProcess;
        }

        @NotNull
        public final Function1<PacketInfo, Boolean> getShouldProcess() {
            return this.shouldProcess;
        }

        @Override
        protected void observe(@NotNull PacketInfo packetInfo) {
            block4: {
                boolean silence;
                int level;
                AudioLevelReader audioLevelReader2;
                AudioRtpPacket audioRtpPacket;
                block6: {
                    block5: {
                        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                        if (!this.shouldProcess.invoke(packetInfo).booleanValue()) {
                            return;
                        }
                        Object object = packetInfo.getPacket();
                        AudioRtpPacket audioRtpPacket2 = object instanceof AudioRtpPacket ? (AudioRtpPacket)object : null;
                        if (audioRtpPacket2 == null) {
                            return;
                        }
                        audioRtpPacket = audioRtpPacket2;
                        Integer n = AudioLevelReader.this.audioLevelExtId;
                        if (n == null) break block4;
                        object = n;
                        audioLevelReader2 = AudioLevelReader.this;
                        int audioLevelId = ((Number)object).intValue();
                        boolean bl = false;
                        RtpPacket.HeaderExtension headerExtension = audioRtpPacket.getHeaderExtension(audioLevelId);
                        if (headerExtension == null) break block4;
                        RtpPacket.HeaderExtension ext = headerExtension;
                        boolean bl2 = false;
                        audioLevelReader2.stats.audioLevel();
                        level = AudioLevelHeaderExtension.Companion.getAudioLevel(ext);
                        boolean bl3 = silence = level == 127;
                        if (!silence) {
                            audioLevelReader2.stats.nonSilence(AudioLevelHeaderExtension.Companion.getVad(ext));
                        }
                        if (!silence || !Companion.getDiscardSilence() || audioLevelReader2.getForwardedSilencePackets() <= Companion.getForwardedSilencePacketsLimit()) break block5;
                        packetInfo.setShouldDiscard(true);
                        audioLevelReader2.stats.discardedSilence();
                        break block4;
                    }
                    if (!audioLevelReader2.getForceMute()) break block6;
                    packetInfo.setShouldDiscard(true);
                    audioLevelReader2.stats.discardedForceMute();
                    break block4;
                }
                audioLevelReader2.setForwardedSilencePackets(silence ? audioLevelReader2.getForwardedSilencePackets() + 1 : 0);
                AudioLevelListener audioLevelListener = audioLevelReader2.getAudioLevelListener();
                if (audioLevelListener == null) break block4;
                AudioLevelListener listener = audioLevelListener;
                boolean bl = false;
                if (listener.onLevelReceived(audioRtpPacket.getSsrc(), UnsignedKt.toPositiveLong(127 - level))) {
                    packetInfo.setShouldDiscard(true);
                    audioLevelReader2.stats.discardedRanking();
                }
            }
        }

        @Override
        @NotNull
        public NodeStatsBlock getNodeStats() {
            NodeStatsBlock nodeStatsBlock = super.getNodeStats();
            AudioLevelReader audioLevelReader2 = AudioLevelReader.this;
            NodeStatsBlock $this$getNodeStats_u24lambda_u243 = nodeStatsBlock;
            boolean bl = false;
            $this$getNodeStats_u24lambda_u243.addString("audio_level_ext_id", String.valueOf(audioLevelReader2.audioLevelExtId));
            $this$getNodeStats_u24lambda_u243.addNumber("num_audio_levels", audioLevelReader2.stats.getNumAudioLevels());
            $this$getNodeStats_u24lambda_u243.addNumber("num_silence_packets_discarded", audioLevelReader2.stats.getNumDiscardedSilence());
            $this$getNodeStats_u24lambda_u243.addNumber("num_force_mute_discarded", audioLevelReader2.stats.getNumDiscardedForceMute());
            $this$getNodeStats_u24lambda_u243.addNumber("num_ranking_discarded", audioLevelReader2.stats.getNumDiscardedRanking());
            $this$getNodeStats_u24lambda_u243.addNumber("num_non_silence", audioLevelReader2.stats.getNumNonSilence());
            $this$getNodeStats_u24lambda_u243.addNumber("num_non_silence_with_vad", audioLevelReader2.stats.getNumNonSilenceWithVad());
            $this$getNodeStats_u24lambda_u243.addBoolean("force_mute", audioLevelReader2.getForceMute());
            return nodeStatsBlock;
        }

        @Override
        @NotNull
        public OrderedJsonObject statsJson() {
            OrderedJsonObject orderedJsonObject = super.statsJson();
            AudioLevelReader audioLevelReader2 = AudioLevelReader.this;
            OrderedJsonObject $this$statsJson_u24lambda_u244 = orderedJsonObject;
            boolean bl = false;
            ((Map)$this$statsJson_u24lambda_u244).put("num_audio_levels", audioLevelReader2.stats.getNumAudioLevels());
            ((Map)$this$statsJson_u24lambda_u244).put("num_silence_packets_discarded", audioLevelReader2.stats.getNumDiscardedSilence());
            ((Map)$this$statsJson_u24lambda_u244).put("num_force_mute_discarded", audioLevelReader2.stats.getNumDiscardedForceMute());
            ((Map)$this$statsJson_u24lambda_u244).put("num_ranking_discarded", audioLevelReader2.stats.getNumDiscardedRanking());
            return orderedJsonObject;
        }

        @Override
        public void trace(@NotNull Function0<Unit> f) {
            Intrinsics.checkNotNullParameter(f, "f");
            f.invoke();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0006\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\n\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jitsi/nlj/transform/node/incoming/AudioLevelReader$Companion;", "", "<init>", "()V", "MUTED_LEVEL", "", "forwardedSilencePacketsLimit", "getForwardedSilencePacketsLimit", "()I", "forwardedSilencePacketsLimit$delegate", "Lorg/jitsi/metaconfig/ConfigDelegate;", "discardSilence", "", "getDiscardSilence", "()Z", "discardSilence$delegate", "jitsi-media-transform"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final int getForwardedSilencePacketsLimit() {
            return ((Number)forwardedSilencePacketsLimit$delegate.getValue(this, $$delegatedProperties[0])).intValue();
        }

        private final boolean getDiscardSilence() {
            return (Boolean)discardSilence$delegate.getValue(this, $$delegatedProperties[1]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1(new PropertyReference1Impl(Companion.class, "forwardedSilencePacketsLimit", "getForwardedSilencePacketsLimit()I", 0)), Reflection.property1(new PropertyReference1Impl(Companion.class, "discardSilence", "getDiscardSilence()Z", 0))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

