/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.cc.vp9;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.codec.vpx.VpxUtils;
import org.jitsi.nlj.rtp.codec.vp9.Vp9Packet;
import org.jitsi.rtp.rtcp.RtcpSrPacket;
import org.jitsi.rtp.util.RtpUtils;
import org.jitsi.rtp.util.RtpUtilsKt;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.videobridge.cc.AdaptiveSourceProjectionContext;
import org.jitsi.videobridge.cc.RewriteException;
import org.jitsi.videobridge.cc.RtpState;
import org.jitsi.videobridge.cc.vp9.PacketInsertionResult;
import org.jitsi.videobridge.cc.vp9.Vp9Frame;
import org.jitsi.videobridge.cc.vp9.Vp9FrameProjection;
import org.jitsi.videobridge.cc.vp9.Vp9Picture;
import org.jitsi.videobridge.cc.vp9.Vp9PictureMap;
import org.jitsi.videobridge.cc.vp9.Vp9QualityFilter;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 @2\u00020\u0001:\u0001@B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001bH\u0002J\u0010\u0010#\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0010\u0010%\u001a\u00020\u00152\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010&\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010'\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002J\u0012\u0010*\u001a\u0004\u0018\u00010\u001b2\u0006\u0010$\u001a\u00020\u001bH\u0002J:\u0010+\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00152\u0006\u0010.\u001a\u00020\u00152\u0006\u0010/\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u000101H\u0002J*\u00102\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u000101H\u0002J*\u00103\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u000101H\u0002J*\u00104\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u000101H\u0002J*\u00105\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u000101H\u0002J2\u00105\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020\u00152\b\u00100\u001a\u0004\u0018\u000101H\u0002J\b\u00107\u001a\u00020\u0015H\u0016J\u0010\u00108\u001a\u0002092\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010:\u001a\u00020\u00152\u0006\u0010;\u001a\u00020<H\u0016J\b\u0010=\u001a\u00020\u0005H\u0016J\b\u0010>\u001a\u00020?H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006A"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9AdaptiveSourceProjectionContext;", "Lorg/jitsi/videobridge/cc/AdaptiveSourceProjectionContext;", "diagnosticContext", "Lorg/jitsi/utils/logging/DiagnosticContext;", "rtpState", "Lorg/jitsi/videobridge/cc/RtpState;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/utils/logging/DiagnosticContext;Lorg/jitsi/videobridge/cc/RtpState;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "vp9PictureMaps", "Ljava/util/HashMap;", "", "Lorg/jitsi/videobridge/cc/vp9/Vp9PictureMap;", "vp9QualityFilter", "Lorg/jitsi/videobridge/cc/vp9/Vp9QualityFilter;", "lastVp9FrameProjection", "Lorg/jitsi/videobridge/cc/vp9/Vp9FrameProjection;", "lastPicIdIndexResumption", "accept", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "targetIndex", "", "lookupVp9Frame", "Lorg/jitsi/videobridge/cc/vp9/Vp9Frame;", "vp9Packet", "Lorg/jitsi/nlj/rtp/codec/vp9/Vp9Packet;", "insertPacketInMap", "Lorg/jitsi/videobridge/cc/vp9/PacketInsertionResult;", "seqGap", "frame1", "frame2", "frameIsNewSsrc", "frame", "frameIsProjectable", "prevFrame", "nextFrame", "findPrevAcceptedFrame", "findNextAcceptedFrame", "findNextBaseTl0", "createProjection", "initialPacket", "mark", "isResumption", "isReset", "receivedTime", "Ljava/time/Instant;", "createEncodingSwitchProjection", "createResumptionProjection", "createResetProjection", "createInEncodingProjection", "refFrame", "needsKeyframe", "rewriteRtp", "", "rewriteRtcp", "rtcpSrPacket", "Lorg/jitsi/rtp/rtcp/RtcpSrPacket;", "getRtpState", "getDebugState", "Lorg/json/simple/JSONObject;", "Companion", "jitsi-videobridge"})
@SourceDebugExtension(value={"SMAP\nVp9AdaptiveSourceProjectionContext.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp9AdaptiveSourceProjectionContext.kt\norg/jitsi/videobridge/cc/vp9/Vp9AdaptiveSourceProjectionContext\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,636:1\n372#2,7:637\n*S KotlinDebug\n*F\n+ 1 Vp9AdaptiveSourceProjectionContext.kt\norg/jitsi/videobridge/cc/vp9/Vp9AdaptiveSourceProjectionContext\n*L\n187#1:637,7\n*E\n"})
public final class Vp9AdaptiveSourceProjectionContext
implements AdaptiveSourceProjectionContext {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticContext diagnosticContext;
    @NotNull
    private final Logger logger;
    @NotNull
    private final HashMap<Long, Vp9PictureMap> vp9PictureMaps;
    @NotNull
    private final Vp9QualityFilter vp9QualityFilter;
    @NotNull
    private Vp9FrameProjection lastVp9FrameProjection;
    private long lastPicIdIndexResumption;
    private static final TimeSeriesLogger timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(Vp9AdaptiveSourceProjectionContext.class);

    public Vp9AdaptiveSourceProjectionContext(@NotNull DiagnosticContext diagnosticContext, @NotNull RtpState rtpState, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(diagnosticContext, "diagnosticContext");
        Intrinsics.checkNotNullParameter(rtpState, "rtpState");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        this.diagnosticContext = diagnosticContext;
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.vp9PictureMaps = new HashMap();
        this.vp9QualityFilter = new Vp9QualityFilter(this.logger);
        this.lastVp9FrameProjection = new Vp9FrameProjection(this.diagnosticContext, rtpState.ssrc, rtpState.maxSequenceNumber, rtpState.maxTimestamp);
        this.lastPicIdIndexResumption = -1L;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public synchronized boolean accept(@NotNull PacketInfo packetInfo, int targetIndex) {
        block16: {
            block15: {
                Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
                packet = packetInfo.getPacket();
                if (!(packet instanceof Vp9Packet)) {
                    this.logger.warn("Packet is not Vp9 packet");
                    return false;
                }
                incomingEncoding = ((Vp9Packet)packet).getEncodingId();
                v0 = this.insertPacketInMap((Vp9Packet)packet);
                if (v0 == null) {
                    return false;
                }
                result = v0;
                frame = result.getFrame();
                if (result.isNewFrame()) {
                    if (((Vp9Packet)packet).isKeyframe() && this.frameIsNewSsrc(frame) && (f = this.findNextBaseTl0(frame)) != null && !f.isAccepted()) {
                        frame.setKeyframe(false);
                    }
                    frame.setAccepted((acceptResult = this.vp9QualityFilter.acceptFrame(frame, incomingEncoding, targetIndex, receivedTime = packetInfo.getReceivedTime())).getAccept() != false && this.frameIsProjectable(frame) != false);
                    if (frame.isAccepted()) {
                        projection = null;
                        try {
                            var10_11 = (Vp9Packet)packet;
                            var11_13 = acceptResult.isResumption();
                            var12_14 = result.isReset();
                            var13_15 = acceptResult.getMark();
                            projection = this.createProjection(frame, var10_11, var13_15, var11_13, var12_14, receivedTime);
                        }
                        catch (Exception e) {
                            this.logger.warn("Failed to create frame projection", e);
                            frame.setAccepted(false);
                            return false;
                        }
                        frame.setProjection(projection);
                        if (RtpUtilsKt.isNewerThan(projection.getEarliestProjectedSeqNum(), this.lastVp9FrameProjection.getLatestProjectedSeqNum())) {
                            this.lastVp9FrameProjection = projection;
                        }
                    }
                }
                if (!frame.isAccepted()) ** GOTO lbl-1000
                v1 = frame.getProjection();
                v2 = v1 != null ? v1.accept((Vp9Packet)packet) : false;
                if (!v2) break block15;
                v3 = true;
                break block16;
            }
            if (frame.getProjection() == null) ** GOTO lbl-1000
            v4 = frame.getProjection();
            if (!(v4 != null ? v4.getClosedSeq() == -1 : false)) {
                v5 = frame.getProjection();
                this.logger.debug("Not accepting " + packet + ": frame projection is closed at " + (v5 != null ? Integer.valueOf(v5.getClosedSeq()) : null));
            } else if (frame.getProjection() == null) {
                this.logger.warn("Not accepting " + packet + ": frame has no projection, even though QF accepted it");
            } else {
                this.logger.warn("Not accepting " + packet + ", even though frame projection is not closed");
            }
            v3 = false;
        }
        if (v3) {
            v6 = true;
        } else lbl-1000:
        // 2 sources

        {
            v6 = accept = false;
        }
        if (Vp9AdaptiveSourceProjectionContext.timeSeriesLogger.isTraceEnabled()) {
            pt = this.diagnosticContext.makeTimeSeriesPoint("rtp_vp9").addField("ssrc", ((Vp9Packet)packet).getSsrc()).addField("timestamp", ((Vp9Packet)packet).getTimestamp()).addField("seq", ((Vp9Packet)packet).getSequenceNumber()).addField("pictureId", ((Vp9Packet)packet).getPictureId()).addField("pictureIdIndex", frame.getIndex()).addField("encoding", incomingEncoding).addField("keyframe", ((Vp9Packet)packet).isKeyframe()).addField("spatialLayer", ((Vp9Packet)packet).getSpatialLayerIndex()).addField("temporalLayer", ((Vp9Packet)packet).getTemporalLayerIndex()).addField("isInterPicturePredicted", ((Vp9Packet)packet).isInterPicturePredicted()).addField("usesInterLayerDependency", ((Vp9Packet)packet).getUsesInterLayerDependency()).addField("isUpperLevelReference", ((Vp9Packet)packet).isUpperLevelReference()).addField("startOfFrame", ((Vp9Packet)packet).isStartOfFrame()).addField("endOfFrame", ((Vp9Packet)packet).isEndOfFrame()).addField("mark", ((Vp9Packet)packet).isMarked()).addField("targetIndex", RtpLayerDesc.Companion.indexString(targetIndex)).addField("new_frame", result.isNewFrame()).addField("reset", result.isReset()).addField("accept", accept);
            Intrinsics.checkNotNull(pt);
            this.vp9QualityFilter.addDiagnosticContext$jitsi_videobridge(pt);
            Vp9AdaptiveSourceProjectionContext.timeSeriesLogger.trace(pt);
        }
        return accept;
    }

    private final Vp9Frame lookupVp9Frame(Vp9Packet vp9Packet) {
        Object object = this.vp9PictureMaps.get(vp9Packet.getSsrc());
        return object != null && (object = ((Vp9PictureMap)object).findPicture(vp9Packet)) != null ? ((Vp9Picture)object).frame(vp9Packet) : null;
    }

    /*
     * WARNING - void declaration
     */
    private final PacketInsertionResult insertPacketInMap(Vp9Packet vp9Packet) {
        Object object;
        void $this$getOrPut$iv;
        Map map = this.vp9PictureMaps;
        Long key$iv = vp9Packet.getSsrc();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            Vp9PictureMap answer$iv = new Vp9PictureMap(this.logger);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return ((Vp9PictureMap)object).insertPacket(vp9Packet);
    }

    private final int seqGap(Vp9Frame frame1, Vp9Frame frame2) {
        int seqGap = RtpUtils.Companion.getSequenceNumberDelta(frame2.getEarliestKnownSequenceNumber(), frame1.getLatestKnownSequenceNumber());
        if (!frame1.isAccepted() && !frame2.isAccepted() && frame2.isImmediatelyAfter(frame1)) {
            seqGap = 0;
        } else {
            if (!frame1.isAccepted() && !frame1.getSeenEndOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame2.isAccepted() && !frame2.getSeenStartOfFrame() && seqGap > 1) {
                --seqGap;
            }
            if (!frame1.isAccepted() && seqGap > 0) {
                --seqGap;
            }
        }
        return seqGap;
    }

    private final boolean frameIsNewSsrc(Vp9Frame frame) {
        Vp9Frame vp9Frame = this.lastVp9FrameProjection.getVp9Frame();
        return !(vp9Frame != null ? vp9Frame.matchesSSRC(frame) : false);
    }

    private final boolean frameIsProjectable(Vp9Frame frame) {
        return this.frameIsNewSsrc(frame) || frame.getIndex() >= this.lastPicIdIndexResumption;
    }

    private final synchronized Vp9Frame prevFrame(Vp9Frame frame) {
        Vp9PictureMap vp9PictureMap = this.vp9PictureMaps.get(frame.getSsrc());
        return vp9PictureMap != null ? vp9PictureMap.prevFrame(frame) : null;
    }

    private final synchronized Vp9Frame nextFrame(Vp9Frame frame) {
        Vp9PictureMap vp9PictureMap = this.vp9PictureMaps.get(frame.getSsrc());
        return vp9PictureMap != null ? vp9PictureMap.nextFrame(frame) : null;
    }

    private final Vp9Frame findPrevAcceptedFrame(Vp9Frame frame) {
        Vp9PictureMap vp9PictureMap = this.vp9PictureMaps.get(frame.getSsrc());
        return vp9PictureMap != null ? vp9PictureMap.findPrevAcceptedFrame(frame) : null;
    }

    private final Vp9Frame findNextAcceptedFrame(Vp9Frame frame) {
        Vp9PictureMap vp9PictureMap = this.vp9PictureMaps.get(frame.getSsrc());
        return vp9PictureMap != null ? vp9PictureMap.findNextAcceptedFrame(frame) : null;
    }

    private final Vp9Frame findNextBaseTl0(Vp9Frame frame) {
        Vp9PictureMap vp9PictureMap = this.vp9PictureMaps.get(frame.getSsrc());
        return vp9PictureMap != null ? vp9PictureMap.findNextBaseTl0(frame) : null;
    }

    private final Vp9FrameProjection createProjection(Vp9Frame frame, Vp9Packet initialPacket, boolean mark, boolean isResumption, boolean isReset, Instant receivedTime) {
        if (this.frameIsNewSsrc(frame)) {
            return this.createEncodingSwitchProjection(frame, initialPacket, mark, receivedTime);
        }
        if (isResumption) {
            return this.createResumptionProjection(frame, initialPacket, mark, receivedTime);
        }
        if (isReset) {
            return this.createResetProjection(frame, initialPacket, mark, receivedTime);
        }
        return this.createInEncodingProjection(frame, initialPacket, mark, receivedTime);
    }

    /*
     * Unable to fully structure code
     */
    private final Vp9FrameProjection createEncodingSwitchProjection(Vp9Frame frame, Vp9Packet initialPacket, boolean mark, Instant receivedTime) {
        var5_5 = frame.isKeyframe();
        if (_Assertions.ENABLED && !var5_5) {
            var6_6 = "Assertion failed";
            throw new AssertionError((Object)var6_6);
        }
        this.lastPicIdIndexResumption = frame.getIndex();
        projectedSeqGap = !initialPacket.isStartOfFrame() ? ((f = this.prevFrame(frame)) != null ? this.seqGap(f, frame) : 16) : 1;
        v0 = this.lastVp9FrameProjection.getVp9Frame();
        v1 = v0 != null ? !v0.getSeenEndOfFrame() : false;
        if (v1) {
            ++projectedSeqGap;
            this.lastVp9FrameProjection.close();
        }
        projectedSeq = RtpUtils.Companion.applySequenceNumberDelta(this.lastVp9FrameProjection.getLatestProjectedSeqNum(), projectedSeqGap);
        v2 = this.lastVp9FrameProjection.getCreated();
        if (v2 == null) ** GOTO lbl-1000
        created = v2;
        $i$a$-let-Vp9AdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1 = false;
        v3 = receivedTime;
        if (v3 != null) {
            it = v3;
            $i$a$-let-Vp9AdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$1$1 = false;
            v4 = (long)3000 * Math.max(1L, Duration.between(created, receivedTime).dividedBy(33L).getSeconds());
        } else {
            v4 = null;
        }
        v2 = v4;
        if (v4 != null) {
            v5 = v2.longValue();
        } else lbl-1000:
        // 2 sources

        {
            $this$createEncodingSwitchProjection_u24lambda_u243 = this;
            $i$a$-run-Vp9AdaptiveSourceProjectionContext$createEncodingSwitchProjection$tsDelta$2 = false;
            v5 = 3000L;
        }
        tsDelta = v5;
        projectedTs = RtpUtils.Companion.applyTimestampDelta(this.lastVp9FrameProjection.getTimestamp(), tsDelta);
        picId = 0;
        tl0PicIdx = 0;
        if (this.lastVp9FrameProjection.getVp9Frame() != null) {
            picId = VpxUtils.Companion.applyExtendedPictureIdDelta(this.lastVp9FrameProjection.getPictureId(), 1);
            tl0PicIdx = VpxUtils.Companion.applyTl0PicIdxDelta(this.lastVp9FrameProjection.getTl0PICIDX(), 1);
        } else {
            picId = frame.getPictureId();
            tl0PicIdx = frame.getTl0PICIDX();
        }
        return new Vp9FrameProjection(this.diagnosticContext, frame, this.lastVp9FrameProjection.getSsrc(), projectedTs, RtpUtils.Companion.getSequenceNumberDelta(projectedSeq, initialPacket.getSequenceNumber()), picId, tl0PicIdx, mark, receivedTime);
    }

    private final Vp9FrameProjection createResumptionProjection(Vp9Frame frame, Vp9Packet initialPacket, boolean mark, Instant receivedTime) {
        this.lastPicIdIndexResumption = frame.getIndex();
        Vp9Frame vp9Frame = this.prevFrame(frame);
        Intrinsics.checkNotNull(vp9Frame);
        Vp9Frame lastFrame = vp9Frame;
        Vp9Frame vp9Frame2 = this.lastVp9FrameProjection.getVp9Frame();
        Intrinsics.checkNotNull(vp9Frame2);
        Vp9Frame lastProjectedFrame = vp9Frame2;
        long tsDelta = RtpUtils.Companion.getTimestampDiff(this.lastVp9FrameProjection.getTimestamp(), lastProjectedFrame.getTimestamp());
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(frame.getTimestamp(), tsDelta);
        int projectedPicId = VpxUtils.Companion.applyExtendedPictureIdDelta(this.lastVp9FrameProjection.getPictureId(), 1);
        int projectedTl0PicIdx = VpxUtils.Companion.applyTl0PicIdxDelta(this.lastVp9FrameProjection.getTl0PICIDX(), 1);
        int seqGap = RtpUtils.Companion.getSequenceNumberDelta(initialPacket.getSequenceNumber(), lastFrame.getLatestKnownSequenceNumber());
        int newSeq = RtpUtils.Companion.applySequenceNumberDelta(this.lastVp9FrameProjection.getLatestProjectedSeqNum(), seqGap);
        int seqDelta = RtpUtils.Companion.getSequenceNumberDelta(newSeq, initialPacket.getSequenceNumber());
        return new Vp9FrameProjection(this.diagnosticContext, frame, this.lastVp9FrameProjection.getSsrc(), projectedTs, seqDelta, projectedPicId, projectedTl0PicIdx, mark, receivedTime);
    }

    private final Vp9FrameProjection createResetProjection(Vp9Frame frame, Vp9Packet initialPacket, boolean mark, Instant receivedTime) {
        Vp9Frame vp9Frame = this.lastVp9FrameProjection.getVp9Frame();
        Intrinsics.checkNotNull(vp9Frame);
        Vp9Frame lastFrame = vp9Frame;
        int seqDelta = RtpUtils.Companion.getSequenceNumberDelta(this.lastVp9FrameProjection.getLatestProjectedSeqNum(), lastFrame.getLatestKnownSequenceNumber());
        long tsDelta = RtpUtils.Companion.getTimestampDiff(this.lastVp9FrameProjection.getTimestamp(), lastFrame.getTimestamp());
        int picIdDelta = VpxUtils.Companion.getExtendedPictureIdDelta(this.lastVp9FrameProjection.getPictureId(), lastFrame.getPictureId());
        int tl0PicIdxDelta = VpxUtils.Companion.getTl0PicIdxDelta(this.lastVp9FrameProjection.getTl0PICIDX(), lastFrame.getTl0PICIDX());
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(frame.getTimestamp(), tsDelta);
        int projectedPicId = VpxUtils.Companion.applyExtendedPictureIdDelta(frame.getPictureId(), picIdDelta);
        int projectedTl0PicIdx = VpxUtils.Companion.applyTl0PicIdxDelta(frame.getTl0PICIDX(), tl0PicIdxDelta);
        return new Vp9FrameProjection(this.diagnosticContext, frame, this.lastVp9FrameProjection.getSsrc(), projectedTs, seqDelta, projectedPicId, projectedTl0PicIdx, mark, receivedTime);
    }

    private final Vp9FrameProjection createInEncodingProjection(Vp9Frame frame, Vp9Packet initialPacket, boolean mark, Instant receivedTime) {
        Vp9Frame prevFrame = this.findPrevAcceptedFrame(frame);
        if (prevFrame != null) {
            return this.createInEncodingProjection(frame, prevFrame, initialPacket, mark, receivedTime);
        }
        Vp9Frame nextFrame = this.findNextAcceptedFrame(frame);
        if (nextFrame != null) {
            return this.createInEncodingProjection(frame, nextFrame, initialPacket, mark, receivedTime);
        }
        Vp9Frame vp9Frame = this.lastVp9FrameProjection.getVp9Frame();
        Intrinsics.checkNotNull(vp9Frame);
        return this.createInEncodingProjection(frame, vp9Frame, initialPacket, mark, receivedTime);
    }

    private final Vp9FrameProjection createInEncodingProjection(Vp9Frame frame, Vp9Frame refFrame, Vp9Packet initialPacket, boolean mark, Instant receivedTime) {
        long tsGap = RtpUtils.Companion.getTimestampDiff(frame.getTimestamp(), refFrame.getTimestamp());
        int tl0Gap = VpxUtils.Companion.getTl0PicIdxDelta(frame.getTl0PICIDX(), refFrame.getTl0PICIDX());
        int picGap = VpxUtils.Companion.getExtendedPictureIdDelta(frame.getPictureId(), refFrame.getPictureId());
        int layerGap = frame.getSpatialLayer() - refFrame.getSpatialLayer();
        int seqGap = 0;
        Vp9Frame f1 = null;
        f1 = refFrame;
        Vp9Frame f2 = null;
        int refSeq = 0;
        if (picGap > 0 || picGap == 0 && layerGap > 0) {
            do {
                if ((f2 = this.nextFrame(f1)) == null) {
                    boolean $i$a$-checkNotNull-Vp9AdaptiveSourceProjectionContext$createInEncodingProjection$32 = false;
                    String $i$a$-checkNotNull-Vp9AdaptiveSourceProjectionContext$createInEncodingProjection$32 = "No next frame found after frame with picId " + f1.getPictureId() + " layer " + f1.getSpatialLayer() + ", even though refFrame " + refFrame.getPictureId() + "/" + refFrame.getSpatialLayer() + " is before frame " + frame.getPictureId() + "/" + frame.getSpatialLayer() + "!";
                    throw new IllegalStateException($i$a$-checkNotNull-Vp9AdaptiveSourceProjectionContext$createInEncodingProjection$32.toString());
                }
                seqGap += this.seqGap(f1, f2);
                f1 = f2;
            } while (f2 != frame);
            Vp9FrameProjection vp9FrameProjection = refFrame.getProjection();
            Intrinsics.checkNotNull(vp9FrameProjection);
            refSeq = vp9FrameProjection.getLatestProjectedSeqNum();
        } else {
            do {
                if ((f2 = this.prevFrame(f1)) == null) {
                    boolean $i$a$-checkNotNull-Vp9AdaptiveSourceProjectionContext$createInEncodingProjection$42 = false;
                    String $i$a$-checkNotNull-Vp9AdaptiveSourceProjectionContext$createInEncodingProjection$42 = "No previous frame found before frame with picId " + f1.getPictureId() + " layer " + f1.getSpatialLayer() + ", even though refFrame " + refFrame.getPictureId() + "/" + refFrame.getSpatialLayer() + " is after frame " + frame.getPictureId() + "/" + frame.getSpatialLayer() + "!";
                    throw new IllegalStateException($i$a$-checkNotNull-Vp9AdaptiveSourceProjectionContext$createInEncodingProjection$42.toString());
                }
                seqGap += -this.seqGap(f2, f1);
                f1 = f2;
            } while (f2 != frame);
            Vp9FrameProjection vp9FrameProjection = refFrame.getProjection();
            Intrinsics.checkNotNull(vp9FrameProjection);
            refSeq = vp9FrameProjection.getEarliestProjectedSeqNum();
        }
        int projectedSeq = RtpUtils.Companion.applySequenceNumberDelta(refSeq, seqGap);
        Vp9FrameProjection vp9FrameProjection = refFrame.getProjection();
        Intrinsics.checkNotNull(vp9FrameProjection);
        long projectedTs = RtpUtils.Companion.applyTimestampDelta(vp9FrameProjection.getTimestamp(), tsGap);
        Vp9FrameProjection vp9FrameProjection2 = refFrame.getProjection();
        Intrinsics.checkNotNull(vp9FrameProjection2);
        int projectedPicId = VpxUtils.Companion.applyExtendedPictureIdDelta(vp9FrameProjection2.getPictureId(), picGap);
        Vp9FrameProjection vp9FrameProjection3 = refFrame.getProjection();
        Intrinsics.checkNotNull(vp9FrameProjection3);
        int projectedTl0PicIdx = VpxUtils.Companion.applyTl0PicIdxDelta(vp9FrameProjection3.getTl0PICIDX(), tl0Gap);
        return new Vp9FrameProjection(this.diagnosticContext, frame, this.lastVp9FrameProjection.getSsrc(), projectedTs, RtpUtils.Companion.getSequenceNumberDelta(projectedSeq, initialPacket.getSequenceNumber()), projectedPicId, projectedTl0PicIdx, mark, receivedTime);
    }

    @Override
    public boolean needsKeyframe() {
        if (this.vp9QualityFilter.getNeedsKeyframe()) {
            return true;
        }
        return this.lastVp9FrameProjection.getVp9Frame() == null;
    }

    @Override
    public void rewriteRtp(@NotNull PacketInfo packetInfo) throws RewriteException {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        if (!(packetInfo.getPacket() instanceof Vp9Packet)) {
            this.logger.info("Got a non-VP9 packet.");
            throw new RewriteException("Non-VP9 packet in VP9 source projection");
        }
        Vp9Packet vp9Packet = (Vp9Packet)packetInfo.packetAs();
        if (vp9Packet.getPictureId() == -1) {
            this.logger.info("VP9 packet does not have picture ID, cannot track in frame map.");
            throw new RewriteException("VP9 packet without picture ID in VP9 source projection");
        }
        Vp9Frame vp9Frame = this.lookupVp9Frame(vp9Packet);
        if (vp9Frame == null) {
            throw new RewriteException("Frame not in tracker (aged off?)");
        }
        Vp9Frame vp9Frame2 = vp9Frame;
        Vp9FrameProjection vp9FrameProjection = vp9Frame2.getProjection();
        if (vp9FrameProjection == null) {
            throw new RewriteException("Frame does not have projection?");
        }
        Vp9FrameProjection vp9Projection = vp9FrameProjection;
        vp9Projection.rewriteRtp(vp9Packet);
    }

    @Override
    public boolean rewriteRtcp(@NotNull RtcpSrPacket rtcpSrPacket) {
        Intrinsics.checkNotNullParameter(rtcpSrPacket, "rtcpSrPacket");
        Vp9FrameProjection lastVp9FrameProjectionCopy = this.lastVp9FrameProjection;
        Vp9Frame vp9Frame = lastVp9FrameProjectionCopy.getVp9Frame();
        if (!(vp9Frame != null ? rtcpSrPacket.getSenderSsrc() == vp9Frame.getSsrc() : false)) {
            return false;
        }
        rtcpSrPacket.setSenderSsrc(lastVp9FrameProjectionCopy.getSsrc());
        long srcTs = rtcpSrPacket.getSenderInfo().getRtpTimestamp();
        long delta = RtpUtils.Companion.getTimestampDiff(lastVp9FrameProjectionCopy.getTimestamp(), lastVp9FrameProjectionCopy.getVp9Frame().getTimestamp());
        long dstTs = RtpUtils.Companion.applyTimestampDelta(srcTs, delta);
        if (srcTs != dstTs) {
            rtcpSrPacket.getSenderInfo().setRtpTimestamp(dstTs);
        }
        return true;
    }

    @Override
    @NotNull
    public RtpState getRtpState() {
        return new RtpState(this.lastVp9FrameProjection.getSsrc(), this.lastVp9FrameProjection.getLatestProjectedSeqNum(), this.lastVp9FrameProjection.getTimestamp());
    }

    @Override
    @NotNull
    public synchronized JSONObject getDebugState() {
        JSONObject debugState = new JSONObject();
        ((Map)debugState).put("class", Vp9AdaptiveSourceProjectionContext.class.getSimpleName());
        JSONArray mapSizes = new JSONArray();
        Iterator<Map.Entry<Long, Vp9PictureMap>> iterator2 = this.vp9PictureMaps.entrySet().iterator();
        while (iterator2.hasNext()) {
            Vp9PictureMap value2;
            Long key;
            Map.Entry<Long, Vp9PictureMap> entry;
            Intrinsics.checkNotNullExpressionValue(iterator2.next(), "next(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getKey(), "component1(...)");
            Intrinsics.checkNotNullExpressionValue(entry.getValue(), "component2(...)");
            JSONObject sizeInfo = new JSONObject();
            ((Map)sizeInfo).put("ssrc", key);
            ((Map)sizeInfo).put("size", value2.size());
            mapSizes.add(sizeInfo);
        }
        ((Map)debugState).put("vp9FrameMaps", mapSizes);
        ((Map)debugState).put("vp9QualityFilter", this.vp9QualityFilter.getDebugState());
        return debugState;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0018\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jitsi/videobridge/cc/vp9/Vp9AdaptiveSourceProjectionContext$Companion;", "", "<init>", "()V", "timeSeriesLogger", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "kotlin.jvm.PlatformType", "Lorg/jitsi/utils/logging/TimeSeriesLogger;", "jitsi-videobridge"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

