/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import java.io.IOException;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.coin.CallInfoPacketExtension;
import org.jitsi.xmpp.extensions.coin.CoinIQ;
import org.jitsi.xmpp.extensions.coin.ConferenceMediaPacketExtension;
import org.jitsi.xmpp.extensions.coin.ConferenceMediumProvider;
import org.jitsi.xmpp.extensions.coin.DescriptionProvider;
import org.jitsi.xmpp.extensions.coin.SIPDialogIDPacketExtension;
import org.jitsi.xmpp.extensions.coin.SidebarsByValPacketExtension;
import org.jitsi.xmpp.extensions.coin.StateProvider;
import org.jitsi.xmpp.extensions.coin.StateType;
import org.jitsi.xmpp.extensions.coin.URIPacketExtension;
import org.jitsi.xmpp.extensions.coin.URIsPacketExtension;
import org.jitsi.xmpp.extensions.coin.UserRolesPacketExtension;
import org.jitsi.xmpp.extensions.coin.UsersProvider;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class CoinIQProvider
extends SafeParseIqProvider<CoinIQ> {
    private final DescriptionProvider descriptionProvider = new DescriptionProvider();
    private final UsersProvider usersProvider = new UsersProvider();
    private final StateProvider stateProvider = new StateProvider();
    private final DefaultPacketExtensionProvider<URIsPacketExtension> urisProvider = new DefaultPacketExtensionProvider<URIsPacketExtension>(URIsPacketExtension.class);
    private final DefaultPacketExtensionProvider<SidebarsByValPacketExtension> sidebarsByValProvider = new DefaultPacketExtensionProvider<SidebarsByValPacketExtension>(SidebarsByValPacketExtension.class);

    public CoinIQProvider() {
        ProviderManager.addExtensionProvider("roles", "urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<UserRolesPacketExtension>(UserRolesPacketExtension.class));
        ProviderManager.addExtensionProvider("uri", "urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<URIPacketExtension>(URIPacketExtension.class));
        ProviderManager.addExtensionProvider("sip", "urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<SIPDialogIDPacketExtension>(SIPDialogIDPacketExtension.class));
        ProviderManager.addExtensionProvider("medium", "urn:ietf:params:xml:ns:conference-info", new ConferenceMediumProvider());
        ProviderManager.addExtensionProvider("available-media", "urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<ConferenceMediaPacketExtension>(ConferenceMediaPacketExtension.class));
        ProviderManager.addExtensionProvider("call-info", "urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<CallInfoPacketExtension>(CallInfoPacketExtension.class));
    }

    @Override
    protected CoinIQ doParse(XmlPullParser parser2) throws XmlPullParserException, IOException, SmackParsingException {
        CoinIQ coinIQ = new CoinIQ();
        String entity = parser2.getAttributeValue("", "entity");
        String version = parser2.getAttributeValue("", "version");
        StateType state = StateType.full;
        String stateStr = parser2.getAttributeValue("", "state");
        String sid = parser2.getAttributeValue("", "sid");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        coinIQ.setEntity(entity);
        coinIQ.setVersion(Integer.parseInt(version));
        coinIQ.setState(state);
        coinIQ.setSID(sid);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser2.next();
            String elementName = parser2.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                switch (elementName) {
                    case "conference-description": {
                        coinIQ.addExtension((ExtensionElement)this.descriptionProvider.parse(parser2));
                        break;
                    }
                    case "users": {
                        coinIQ.addExtension((ExtensionElement)this.usersProvider.parse(parser2));
                        break;
                    }
                    case "conference-state": {
                        coinIQ.addExtension((ExtensionElement)this.stateProvider.parse(parser2));
                        break;
                    }
                    case "uris": {
                        coinIQ.addExtension((ExtensionElement)this.urisProvider.parse(parser2));
                        break;
                    }
                    case "sidebars-by-val": {
                        coinIQ.addExtension((ExtensionElement)this.sidebarsByValProvider.parse(parser2));
                    }
                }
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser2.getName().equals("conference-info")) continue;
            done = true;
        }
        return coinIQ;
    }
}

