/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.colibri;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.xmpp.extensions.AbstractPacketExtension;
import org.jitsi.xmpp.extensions.jingle.ParameterPacketExtension;
import org.jivesoftware.smack.packet.ExtensionElement;

public class SourcePacketExtension
extends AbstractPacketExtension {
    private static final Logger logger = new LoggerImpl(SourcePacketExtension.class.getName());
    public static final String ELEMENT = "source";
    public static final String NAMESPACE = "urn:xmpp:jingle:apps:rtp:ssma:0";
    public static final String SSRC_ATTR_NAME = "ssrc";
    public static final String RID_ATTR_NAME = "rid";
    public static final String NAME_ATTR_NAME = "name";
    public static final String VIDEO_TYPE_ATTR_NAME = "videoType";

    public SourcePacketExtension() {
        super(NAMESPACE, ELEMENT);
    }

    public void addParameter(ParameterPacketExtension parameter) {
        this.addChildExtension(parameter);
    }

    public List<ParameterPacketExtension> getParameters() {
        return this.getChildExtensionsOfType(ParameterPacketExtension.class);
    }

    public String getParameter(String name) {
        for (ParameterPacketExtension param : this.getParameters()) {
            if (!name.equals(param.getName())) continue;
            return param.getValue();
        }
        return null;
    }

    public String getName() {
        return this.getAttributeAsString(NAME_ATTR_NAME);
    }

    @Nullable
    public String getVideoType() {
        return this.getAttributeAsString(VIDEO_TYPE_ATTR_NAME);
    }

    public boolean hasName() {
        return this.getName() != null;
    }

    public void setName(String name) {
        if (name == null) {
            this.removeAttribute(NAME_ATTR_NAME);
        } else {
            this.setAttribute(NAME_ATTR_NAME, name);
        }
    }

    public void setVideoType(String videoType) {
        if (videoType == null) {
            this.removeAttribute(VIDEO_TYPE_ATTR_NAME);
        } else {
            this.setAttribute(VIDEO_TYPE_ATTR_NAME, videoType);
        }
    }

    public long getSSRC() {
        String s2 = this.getAttributeAsString(SSRC_ATTR_NAME);
        return s2 == null ? -1L : Long.parseLong(s2);
    }

    public void setSSRC(long ssrc) {
        if (ssrc == -1L) {
            this.removeAttribute(SSRC_ATTR_NAME);
        } else {
            this.setAttribute(SSRC_ATTR_NAME, Long.toString(0xFFFFFFFFL & ssrc));
        }
    }

    public boolean hasSSRC() {
        return this.getAttributeAsString(SSRC_ATTR_NAME) != null;
    }

    public String getRid() {
        return this.getAttributeAsString(RID_ATTR_NAME);
    }

    public void setRid(String rid) {
        if (rid == null) {
            this.removeAttribute(RID_ATTR_NAME);
        } else {
            this.setAttribute(RID_ATTR_NAME, rid);
        }
    }

    public boolean hasRid() {
        return this.getAttribute(RID_ATTR_NAME) != null;
    }

    public boolean sourceEquals(SourcePacketExtension other) {
        if (this.hasSSRC() && other.hasSSRC()) {
            return this.getSSRC() == other.getSSRC();
        }
        if (this.hasRid() && other.hasRid()) {
            return this.getRid().equals(other.getRid());
        }
        return false;
    }

    public SourcePacketExtension copy() {
        SourcePacketExtension copy = AbstractPacketExtension.clone(this);
        for (ExtensionElement extensionElement : this.getChildExtensions()) {
            if (extensionElement instanceof AbstractPacketExtension) {
                copy.addChildExtension(AbstractPacketExtension.clone((AbstractPacketExtension)extensionElement));
                continue;
            }
            logger.error("Failed to clone " + String.valueOf(extensionElement));
        }
        return copy;
    }

    public String toString() {
        if (this.hasRid()) {
            return "rid=" + this.getRid();
        }
        if (this.hasSSRC()) {
            return "ssrc=" + this.getAttributeAsString(SSRC_ATTR_NAME);
        }
        if (this.hasName()) {
            return "name=" + this.getName();
        }
        return "[no identifier]";
    }
}

