/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jitsi.utils.logging.DiagnosticContext;
import org.jitsi.utils.logging.TimeSeriesLogger;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.BandwidthUsage;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.OverUseDetectorOptions;
import org.jitsi_modified.impl.neomedia.rtp.remotebitrateestimator.config.OveruseDetectorConfig;

@SuppressFBWarnings(value={"FE_FLOATING_POINT_EQUALITY", "DB_DUPLICATE_BRANCHES"}, justification="We only compare timeOverUsing with the special value -1")
class OveruseDetector {
    private final TimeSeriesLogger timeSeriesLogger;
    private static final double kMaxAdaptOffsetMs = 15.0;
    private BandwidthUsage hypothesis = BandwidthUsage.kBwNormal;
    private static final double kDown = 0.0;
    private static final double kUp = 0.0;
    private long lastUpdateMs = -1L;
    private int overuseCounter;
    private static final double overusingTimeThreshold = OveruseDetectorConfig.Companion.getOverusingTimeThreshold();
    private double prevOffset;
    private double threshold;
    private double timeOverUsing = -1.0;
    private final DiagnosticContext diagnosticContext;

    public OveruseDetector(OverUseDetectorOptions options2, @NotNull DiagnosticContext diagnosticContext) {
        Objects.requireNonNull(options2, "options");
        this.threshold = options2.initialThreshold;
        this.timeSeriesLogger = TimeSeriesLogger.getTimeSeriesLogger(this.getClass());
        this.diagnosticContext = diagnosticContext;
    }

    public BandwidthUsage detect(double offset, double tsDelta, int numOfDeltas, long nowMs) {
        if (numOfDeltas < 2) {
            return BandwidthUsage.kBwNormal;
        }
        double prev_offset = this.prevOffset;
        this.prevOffset = offset;
        double T = (double)Math.min(numOfDeltas, 60) * offset;
        boolean newHypothesis = false;
        if (T > this.threshold) {
            this.timeOverUsing = this.timeOverUsing == -1.0 ? tsDelta / 2.0 : (this.timeOverUsing += tsDelta);
            ++this.overuseCounter;
            if (this.timeOverUsing > overusingTimeThreshold && this.overuseCounter > 1 && offset >= prev_offset) {
                this.timeOverUsing = 0.0;
                this.overuseCounter = 0;
                this.hypothesis = BandwidthUsage.kBwOverusing;
                newHypothesis = true;
            }
        } else if (T < -this.threshold) {
            this.timeOverUsing = -1.0;
            this.overuseCounter = 0;
            this.hypothesis = BandwidthUsage.kBwUnderusing;
            newHypothesis = true;
        } else {
            this.timeOverUsing = -1.0;
            this.overuseCounter = 0;
            this.hypothesis = BandwidthUsage.kBwNormal;
            newHypothesis = true;
        }
        if (newHypothesis && this.timeSeriesLogger.isTraceEnabled()) {
            this.timeSeriesLogger.trace(this.diagnosticContext.makeTimeSeriesPoint("utilization_hypothesis", nowMs).addField("detector", this.hashCode()).addField("offset", offset).addField("prev_offset", prev_offset).addField("T", T).addField("threshold", this.threshold).addField("hypothesis", this.hypothesis.getValue()));
        }
        this.updateThreshold(T, nowMs);
        return this.hypothesis;
    }

    public BandwidthUsage getState() {
        return this.hypothesis;
    }

    private void updateThreshold(double modifiedOffset, long nowMs) {
        if (this.lastUpdateMs == -1L) {
            this.lastUpdateMs = nowMs;
        }
        if (Math.abs(modifiedOffset) > this.threshold + 15.0) {
            this.lastUpdateMs = nowMs;
            return;
        }
        double k = Math.abs(modifiedOffset) < this.threshold ? 0.0 : 0.0;
        this.threshold += k * (Math.abs(modifiedOffset) - this.threshold) * (double)(nowMs - this.lastUpdateMs);
        double kMinThreshold = 6.0;
        double kMaxThreshold = 600.0;
        this.threshold = Math.min(Math.max(this.threshold, 6.0), 600.0);
        this.lastUpdateMs = nowMs;
    }

    public double getThreshold() {
        return this.threshold;
    }
}

