/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.io.File;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.file.StandardOpenOption;
import kafka.message.ByteBufferMessageSet;
import kafka.message.Message;
import kafka.message.MessageSet;
import kafka.message.MessageSet$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.record.FileRecords;
import org.junit.Assert;
import org.junit.Test;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005EcaB\u0001\u0003!\u0003\r\ta\u0002\u0002\u0018\u0005\u0006\u001cX-T3tg\u0006<WmU3u)\u0016\u001cHoQ1tKNT!a\u0001\u0003\u0002\u000f5,7o]1hK*\tQ!A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001A\u0001CA\u0005\u0011\u001b\u0005Q!BA\u0006\r\u0003\u0015QWO\\5u\u0015\tia\"A\u0005tG\u0006d\u0017\r^3ti*\tq\"A\u0002pe\u001eL!!\u0005\u0006\u0003\u0015)+f.\u001b;Tk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004%S:LG\u000f\n\u000b\u0002+A\u0011a#G\u0007\u0002/)\t\u0001$A\u0003tG\u0006d\u0017-\u0003\u0002\u001b/\t!QK\\5u\r\u0011a\u0002\u0001B\u000f\u0003\u001fM#XO\u0019\"zi\u0016\u001c\u0005.\u00198oK2\u001c2a\u0007\u0010'!\tyB%D\u0001!\u0015\t\t#%\u0001\u0003mC:<'\"A\u0012\u0002\t)\fg/Y\u0005\u0003K\u0001\u0012aa\u00142kK\u000e$\bCA\u0014-\u001b\u0005A#BA\u0015+\u0003!\u0019\u0007.\u00198oK2\u001c(BA\u0016#\u0003\rq\u0017n\\\u0005\u0003[!\u0012AcR1uQ\u0016\u0014\u0018N\\4CsR,7\t[1o]\u0016d\u0007\u0002C\u0018\u001c\u0005\u0003\u0005\u000b\u0011\u0002\u0019\u0002/\tLH/Z:U_\u000e{gn];nKB+'OQ;gM\u0016\u0014\bC\u0001\f2\u0013\t\u0011tCA\u0002J]RDQ\u0001N\u000e\u0005\u0002U\na\u0001P5oSRtDC\u0001\u001c9!\t94$D\u0001\u0001\u0011\u0015y3\u00071\u00011\u0011\u001dQ4D1A\u0005\u0002m\nA\u0001Z1uCV\tA\bE\u0002>\u0005\u0012k\u0011A\u0010\u0006\u0003\u007f\u0001\u000bq!\\;uC\ndWM\u0003\u0002B/\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\u0005\rs$aC!se\u0006L()\u001e4gKJ\u0004\"AF#\n\u0005\u0019;\"\u0001\u0002\"zi\u0016Da\u0001S\u000e!\u0002\u0013a\u0014!\u00023bi\u0006\u0004\u0003\"\u0002&\u001c\t\u0003Y\u0015!B<sSR,G\u0003\u0002'P1j\u0003\"AF'\n\u00059;\"\u0001\u0002'p]\u001eDQ\u0001U%A\u0002E\u000bAa\u001d:dgB\u0019aC\u0015+\n\u0005M;\"!B!se\u0006L\bCA+W\u001b\u0005Q\u0013BA,+\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\u00063&\u0003\r\u0001M\u0001\u0007_\u001a47/\u001a;\t\u000bmK\u0005\u0019\u0001\u0019\u0002\r1,gn\u001a;i\u0011\u0015Q5\u0004\"\u0001^)\tae\fC\u0003Q9\u0002\u0007\u0011\u000bC\u0003K7\u0011\u0005\u0001\r\u0006\u00021C\")!m\u0018a\u0001)\u0006\u00191O]2\t\u000b\u0011\\B\u0011A3\u0002\r%\u001cx\n]3o)\u00051\u0007C\u0001\fh\u0013\tAwCA\u0004C_>dW-\u00198\t\u000b)\\B\u0011\u0001\u000b\u0002\u000b\rdwn]3\t\u000f1\u0004!\u0019!C\u0001[\u0006AQ.Z:tC\u001e,7/F\u0001o!\r1\"k\u001c\t\u0003aFl\u0011AA\u0005\u0003e\n\u0011q!T3tg\u0006<W\rC\u0003u\u0001\u0019\u0005Q/\u0001\tde\u0016\fG/Z'fgN\fw-Z*fiR\u0011a/\u001f\t\u0003a^L!\u0001\u001f\u0002\u0003\u00155+7o]1hKN+G\u000fC\u0003mg\u0002\u0007!\u0010\u0005\u0003|\u0003\u000fygb\u0001?\u0002\u00049\u0019Q0!\u0001\u000e\u0003yT!a \u0004\u0002\rq\u0012xn\u001c;?\u0013\u0005A\u0012bAA\u0003/\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0005\u0003\u0017\u00111aU3r\u0015\r\t)a\u0006\u0005\u0007\u0003\u001f\u0001A\u0011\u0001\u000b\u0002+Q,7\u000f^,sSR$XM\\#rk\u0006d7OU3bI\"\"\u0011QBA\n!\u0011\t)\"!\u0007\u000e\u0005\u0005]!BA\u0006\u000f\u0013\u0011\tY\"a\u0006\u0003\tQ+7\u000f\u001e\u0005\u0007\u0003?\u0001A\u0011\u0001\u000b\u00021Q,7\u000f^%uKJ\fGo\u001c:Jg\u000e{gn]5ti\u0016tG\u000f\u000b\u0003\u0002\u001e\u0005M\u0001BBA\u0013\u0001\u0011\u0005A#A\buKN$8+\u001b>f\u0013:\u0014\u0015\u0010^3tQ\u0011\t\u0019#a\u0005\t\r\u0005-\u0002\u0001\"\u0001\u0015\u0003-!Xm\u001d;Xe&$X\rV8)\t\u0005%\u00121\u0003\u0005\u0007\u0003c\u0001A\u0011\u0001\u000b\u0002OQ,7\u000f^,sSR,Gk\\\"iC:tW\r\u001c+iCR\u001cuN\\:v[\u0016\u001c\b+\u0019:uS\u0006dG.\u001f\u0015\u0005\u0003_\t\u0019\u0002C\u0004\u00028\u0001!\t!!\u000f\u00025\rDWmY6Xe&$X\rV8XSRDW*Z:tC\u001e,7+\u001a;\u0015\u0007U\tY\u0004C\u0004\u0002>\u0005U\u0002\u0019\u0001<\u0002\u00155,7o]1hKN+G\u000fC\u0004\u0002B\u0001!\t!a\u0011\u00021\rDWmY6Xe&$XmV5uQ6+7o]1hKN+G\u000fF\u0003\u0016\u0003\u000b\nI\u0005C\u0004\u0002H\u0005}\u0002\u0019\u0001<\u0002\u0007M,G\u000fC\u0004K\u0003\u007f\u0001\r!a\u0013\u0011\u000bY\tiE\n'\n\u0007\u0005=sCA\u0005Gk:\u001cG/[8oc\u0001")
public interface BaseMessageSetTestCases {
    public void kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq(Message[] var1);

    public Message[] messages();

    public MessageSet createMessageSet(Seq<Message> var1);

    public static /* synthetic */ void testWrittenEqualsRead$(BaseMessageSetTestCases $this) {
        $this.testWrittenEqualsRead();
    }

    @Test
    default public void testWrittenEqualsRead() {
        MessageSet messageSet = this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages()));
        Assert.assertEquals((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.messages())).toVector(), (Object)messageSet.toVector().map((Function1 & Serializable & scala.Serializable)m -> m.message(), Vector$.MODULE$.canBuildFrom()));
    }

    public static /* synthetic */ void testIteratorIsConsistent$(BaseMessageSetTestCases $this) {
        $this.testIteratorIsConsistent();
    }

    @Test
    default public void testIteratorIsConsistent() {
        MessageSet m = this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages()));
        TestUtils$.MODULE$.checkEquals(m.iterator(), m.iterator());
    }

    public static /* synthetic */ void testSizeInBytes$(BaseMessageSetTestCases $this) {
        $this.testSizeInBytes();
    }

    @Test
    default public void testSizeInBytes() {
        Assert.assertEquals((String)"Empty message set should have 0 bytes.", (long)0L, (long)this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))).sizeInBytes());
        Assert.assertEquals((String)"Predicted size should equal actual size.", (long)MessageSet$.MODULE$.messageSetSize((Iterable)Predef$.MODULE$.wrapRefArray((Object[])this.messages())), (long)this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages())).sizeInBytes());
    }

    public static /* synthetic */ void testWriteTo$(BaseMessageSetTestCases $this) {
        $this.testWriteTo();
    }

    @Test
    default public void testWriteTo() {
        this.checkWriteToWithMessageSet(this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(Message.class)))));
        this.checkWriteToWithMessageSet(this.createMessageSet((Seq<Message>)Predef$.MODULE$.wrapRefArray((Object[])this.messages())));
    }

    public static /* synthetic */ void testWriteToChannelThatConsumesPartially$(BaseMessageSetTestCases $this) {
        $this.testWriteToChannelThatConsumesPartially();
    }

    @Test
    default public void testWriteToChannelThatConsumesPartially() {
        int bytesToConsumePerBuffer = 50;
        IndexedSeq messages = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).map((Function1 & Serializable & scala.Serializable)x$2 -> BaseMessageSetTestCases.$anonfun$testWriteToChannelThatConsumesPartially$1(BoxesRunTime.unboxToInt((Object)x$2)), IndexedSeq$.MODULE$.canBuildFrom());
        MessageSet messageSet = this.createMessageSet((Seq<Message>)messages);
        int messageSetSize = messageSet.sizeInBytes();
        StubByteChannel channel = new StubByteChannel(this, bytesToConsumePerBuffer);
        int remaining = messageSetSize;
        int iterations = 0;
        while (remaining > 0) {
            remaining -= (int)messageSet.asRecords().writeTo((GatheringByteChannel)channel, (long)(messageSetSize - remaining), remaining);
            ++iterations;
        }
        Assert.assertEquals((long)(messageSetSize / bytesToConsumePerBuffer + 1), (long)iterations);
        TestUtils$.MODULE$.checkEquals(new ByteBufferMessageSet(ByteBuffer.wrap((byte[])channel.data().toArray(ClassTag$.MODULE$.Byte()))).iterator(), messageSet.iterator());
    }

    public static /* synthetic */ void checkWriteToWithMessageSet$(BaseMessageSetTestCases $this, MessageSet messageSet) {
        $this.checkWriteToWithMessageSet(messageSet);
    }

    default public void checkWriteToWithMessageSet(MessageSet messageSet) {
        this.checkWriteWithMessageSet(messageSet, (Function1<GatheringByteChannel, Object>)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)BaseMessageSetTestCases.$anonfun$checkWriteToWithMessageSet$1(messageSet, x$3)));
    }

    public static /* synthetic */ void checkWriteWithMessageSet$(BaseMessageSetTestCases $this, MessageSet set, Function1 write) {
        $this.checkWriteWithMessageSet(set, (Function1<GatheringByteChannel, Object>)write);
    }

    default public void checkWriteWithMessageSet(MessageSet set, Function1<GatheringByteChannel, Object> write) {
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), 1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)_ -> {
            File file = TestUtils$.MODULE$.tempFile();
            try (FileChannel channel = FileChannel.open(file.toPath(), StandardOpenOption.READ, StandardOpenOption.WRITE);){
                long written = BoxesRunTime.unboxToLong((Object)write.apply((Object)channel));
                Assert.assertEquals((String)"Expect to write the number of bytes in the set.", (long)set.sizeInBytes(), (long)written);
                FileRecords fileRecords = new FileRecords(file, channel, 0, Integer.MAX_VALUE, false);
                Assert.assertEquals((Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(set.asRecords().records()).asScala()).toVector(), (Object)((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(fileRecords.records()).asScala()).toVector());
                TestUtils$.MODULE$.checkEquals(set.asRecords().records().iterator(), fileRecords.records().iterator());
            }
        });
    }

    public static /* synthetic */ Message $anonfun$testWriteToChannelThatConsumesPartially$1(int x$2) {
        return new Message(TestUtils$.MODULE$.randomString(100).getBytes());
    }

    public static /* synthetic */ long $anonfun$checkWriteToWithMessageSet$1(MessageSet messageSet$1, GatheringByteChannel x$3) {
        return messageSet$1.asRecords().writeTo(x$3, 0L, messageSet$1.sizeInBytes());
    }

    public static void $init$(BaseMessageSetTestCases $this) {
        $this.kafka$message$BaseMessageSetTestCases$_setter_$messages_$eq((Message[])((Object[])new Message[]{new Message("abcd".getBytes()), new Message("efgh".getBytes()), new Message("ijkl".getBytes())}));
    }

    public class StubByteChannel
    implements GatheringByteChannel {
        private final int bytesToConsumePerBuffer;
        private final ArrayBuffer<Object> data;
        public final /* synthetic */ BaseMessageSetTestCases $outer;

        public ArrayBuffer<Object> data() {
            return this.data;
        }

        @Override
        public long write(ByteBuffer[] srcs, int offset, int length) {
            return BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])srcs)).map((Function1 & Serializable & scala.Serializable)src -> BoxesRunTime.boxToInteger((int)StubByteChannel.$anonfun$write$1(this, src)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
        }

        @Override
        public long write(ByteBuffer[] srcs) {
            return this.write(srcs, 0, BoxesRunTime.unboxToInt((Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps((int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])srcs)).map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.remaining()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int())))).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)));
        }

        @Override
        public int write(ByteBuffer src) {
            return (int)this.write((ByteBuffer[])((Object[])new ByteBuffer[]{src}));
        }

        @Override
        public boolean isOpen() {
            return true;
        }

        @Override
        public void close() {
        }

        public /* synthetic */ BaseMessageSetTestCases kafka$message$BaseMessageSetTestCases$StubByteChannel$$$outer() {
            return this.$outer;
        }

        public static final /* synthetic */ int $anonfun$write$1(StubByteChannel $this, ByteBuffer src) {
            byte[] array = new byte[package$.MODULE$.min($this.bytesToConsumePerBuffer, src.remaining())];
            src.get(array);
            $this.data().$plus$plus$eq((TraversableOnce)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)));
            return array.length;
        }

        public StubByteChannel(BaseMessageSetTestCases $outer, int bytesToConsumePerBuffer) {
            this.bytesToConsumePerBuffer = bytesToConsumePerBuffer;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.data = new ArrayBuffer();
        }
    }
}

