/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.trogdor.coordinator;

import java.net.ConnectException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.trogdor.agent.AgentClient;
import org.apache.kafka.trogdor.common.Node;
import org.apache.kafka.trogdor.common.ThreadUtils;
import org.apache.kafka.trogdor.coordinator.TaskManager;
import org.apache.kafka.trogdor.rest.AgentStatusResponse;
import org.apache.kafka.trogdor.rest.CreateWorkerRequest;
import org.apache.kafka.trogdor.rest.StopWorkerRequest;
import org.apache.kafka.trogdor.rest.WorkerDone;
import org.apache.kafka.trogdor.rest.WorkerReceiving;
import org.apache.kafka.trogdor.rest.WorkerRunning;
import org.apache.kafka.trogdor.rest.WorkerStarting;
import org.apache.kafka.trogdor.rest.WorkerState;
import org.apache.kafka.trogdor.task.TaskSpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NodeManager {
    private static final Logger log = LoggerFactory.getLogger(NodeManager.class);
    private static final long HEARTBEAT_DELAY_MS = 1000L;
    private final Node node;
    private final TaskManager taskManager;
    private final AgentClient client;
    private final Map<String, ManagedWorker> workers;
    private final ScheduledExecutorService executor;
    private final NodeHeartbeat heartbeat;
    private ScheduledFuture<?> heartbeatFuture;

    NodeManager(Node node, TaskManager taskManager) {
        this.node = node;
        this.taskManager = taskManager;
        this.client = new AgentClient(1, node.hostname(), Node.Util.getTrogdorAgentPort(node));
        this.workers = new HashMap<String, ManagedWorker>();
        this.executor = Executors.newSingleThreadScheduledExecutor(ThreadUtils.createThreadFactory("NodeManager(" + node.name() + ")", false));
        this.heartbeat = new NodeHeartbeat();
        this.rescheduleNextHeartbeat(1000L);
    }

    void rescheduleNextHeartbeat(long initialDelayMs) {
        if (this.heartbeatFuture != null) {
            this.heartbeatFuture.cancel(false);
        }
        this.heartbeatFuture = this.executor.scheduleAtFixedRate(this.heartbeat, initialDelayMs, 1000L, TimeUnit.MILLISECONDS);
    }

    public void createWorker(String id, TaskSpec spec) {
        this.executor.submit(new CreateWorker(id, spec));
    }

    public void stopWorker(String id) {
        this.executor.submit(new StopWorker(id));
    }

    public void beginShutdown(boolean stopNode) {
        this.executor.shutdownNow();
        if (stopNode) {
            try {
                this.client.invokeShutdown();
            }
            catch (Exception e) {
                log.error("{}: Failed to send shutdown request", (Object)this.node.name(), (Object)e);
            }
        }
    }

    public void waitForShutdown() throws InterruptedException {
        this.executor.awaitTermination(1L, TimeUnit.DAYS);
    }

    class StopWorker
    implements Callable<Void> {
        private final String id;

        StopWorker(String id) {
            this.id = id;
        }

        @Override
        public Void call() throws Exception {
            ManagedWorker worker = (ManagedWorker)NodeManager.this.workers.get(this.id);
            if (worker == null) {
                log.error("{}: can't stop non-existent worker {}.", (Object)NodeManager.this.node.name(), (Object)this.id);
                return null;
            }
            if (!worker.shouldRun) {
                log.error("{}: The worker for task {} is already scheduled to stop.", (Object)NodeManager.this.node.name(), (Object)this.id);
                return null;
            }
            log.info("{}: scheduling worker {} on {} to stop.", (Object)NodeManager.this.node.name(), (Object)this.id);
            worker.shouldRun = false;
            NodeManager.this.rescheduleNextHeartbeat(0L);
            return null;
        }
    }

    class CreateWorker
    implements Callable<Void> {
        private final String id;
        private final TaskSpec spec;

        CreateWorker(String id, TaskSpec spec) {
            this.id = id;
            this.spec = spec;
        }

        @Override
        public Void call() throws Exception {
            ManagedWorker worker = (ManagedWorker)NodeManager.this.workers.get(this.id);
            if (worker != null) {
                log.error("{}: there is already a worker for task {}.", (Object)NodeManager.this.node.name(), (Object)this.id);
                return null;
            }
            log.info("{}: scheduling worker {} to start.", (Object)NodeManager.this.node.name(), (Object)this.id);
            NodeManager.this.workers.put(this.id, new ManagedWorker(this.id, this.spec, true, new WorkerReceiving(this.spec)));
            NodeManager.this.rescheduleNextHeartbeat(0L);
            return null;
        }
    }

    class NodeHeartbeat
    implements Runnable {
        NodeHeartbeat() {
        }

        @Override
        public void run() {
            NodeManager.this.rescheduleNextHeartbeat(1000L);
            try {
                WorkerState state;
                String id;
                AgentStatusResponse agentStatus = null;
                try {
                    agentStatus = NodeManager.this.client.status();
                }
                catch (ConnectException e) {
                    log.error("{}: failed to get agent status: ConnectException {}", (Object)NodeManager.this.node.name(), (Object)e.getMessage());
                    return;
                }
                catch (Exception e) {
                    log.error("{}: failed to get agent status", (Object)NodeManager.this.node.name(), (Object)e);
                    return;
                }
                for (Map.Entry entry : NodeManager.this.workers.entrySet()) {
                    ManagedWorker worker;
                    id = (String)entry.getKey();
                    if (agentStatus.workers().containsKey(id) || !(worker = (ManagedWorker)entry.getValue()).shouldRun) continue;
                    worker.tryCreate();
                }
                for (Map.Entry<Object, Object> entry : agentStatus.workers().entrySet()) {
                    id = (String)entry.getKey();
                    state = (WorkerState)entry.getValue();
                    if (NodeManager.this.workers.containsKey(id)) continue;
                    log.warn("{}: scheduling unknown worker {} for stopping.", (Object)NodeManager.this.node.name(), (Object)id);
                    NodeManager.this.workers.put(id, new ManagedWorker(id, state.spec(), false, state));
                }
                for (Map.Entry<Object, Object> entry : agentStatus.workers().entrySet()) {
                    id = (String)entry.getKey();
                    state = (WorkerState)entry.getValue();
                    ManagedWorker worker = (ManagedWorker)NodeManager.this.workers.get(id);
                    if (state instanceof WorkerStarting || state instanceof WorkerRunning) {
                        if (!worker.shouldRun) {
                            worker.tryStop();
                        }
                    } else if (state instanceof WorkerDone && !(worker.state instanceof WorkerDone)) {
                        WorkerDone workerDoneState = (WorkerDone)state;
                        String error = workerDoneState.error();
                        if (error.isEmpty()) {
                            log.info("{}: Worker {} finished with status '{}'", new Object[]{NodeManager.this.node.name(), id, workerDoneState.status()});
                        } else {
                            log.warn("{}: Worker {} finished with error '{}' and status '{}'", new Object[]{NodeManager.this.node.name(), id, error, workerDoneState.status()});
                        }
                        NodeManager.this.taskManager.handleWorkerCompletion(NodeManager.this.node.name(), worker.id, error);
                    }
                    worker.state = state;
                }
            }
            catch (Throwable e) {
                log.error("{}: Unhandled exception in NodeHeartbeatRunnable", (Object)NodeManager.this.node.name(), (Object)e);
            }
        }
    }

    class ManagedWorker {
        private final String id;
        private final TaskSpec spec;
        private boolean shouldRun;
        private WorkerState state;

        ManagedWorker(String id, TaskSpec spec, boolean shouldRun, WorkerState state) {
            this.id = id;
            this.spec = spec;
            this.shouldRun = shouldRun;
            this.state = state;
        }

        void tryCreate() {
            try {
                NodeManager.this.client.createWorker(new CreateWorkerRequest(this.id, this.spec));
            }
            catch (Throwable e) {
                log.error("{}: error creating worker {}.", new Object[]{NodeManager.this.node.name(), this.id, e});
            }
        }

        void tryStop() {
            try {
                NodeManager.this.client.stopWorker(new StopWorkerRequest(this.id));
            }
            catch (Throwable e) {
                log.error("{}: error stopping worker {}.", new Object[]{NodeManager.this.node.name(), this.id, e});
            }
        }
    }
}

