/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.kstream.internals;

import java.util.Objects;
import java.util.Set;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serdes;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.kstream.Aggregator;
import org.apache.kafka.streams.kstream.Initializer;
import org.apache.kafka.streams.kstream.KTable;
import org.apache.kafka.streams.kstream.Materialized;
import org.apache.kafka.streams.kstream.Merger;
import org.apache.kafka.streams.kstream.Reducer;
import org.apache.kafka.streams.kstream.SessionWindowedKStream;
import org.apache.kafka.streams.kstream.SessionWindows;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.kstream.internals.AbstractStream;
import org.apache.kafka.streams.kstream.internals.GroupedStreamAggregateBuilder;
import org.apache.kafka.streams.kstream.internals.InternalStreamsBuilder;
import org.apache.kafka.streams.kstream.internals.KStreamSessionWindowAggregate;
import org.apache.kafka.streams.kstream.internals.MaterializedInternal;
import org.apache.kafka.streams.state.SessionBytesStoreSupplier;
import org.apache.kafka.streams.state.SessionStore;
import org.apache.kafka.streams.state.StoreBuilder;
import org.apache.kafka.streams.state.Stores;

public class SessionWindowedKStreamImpl<K, V>
extends AbstractStream<K>
implements SessionWindowedKStream<K, V> {
    private final SessionWindows windows;
    private final Serde<K> keySerde;
    private final Serde<V> valSerde;
    private final GroupedStreamAggregateBuilder<K, V> aggregateBuilder;
    private final Merger<K, Long> countMerger = new Merger<K, Long>(){

        @Override
        public Long apply(K aggKey, Long aggOne, Long aggTwo) {
            return aggOne + aggTwo;
        }
    };
    private final Initializer<V> reduceInitializer = new Initializer<V>(){

        @Override
        public V apply() {
            return null;
        }
    };

    SessionWindowedKStreamImpl(SessionWindows windows, InternalStreamsBuilder builder, Set<String> sourceNodes, String name, Serde<K> keySerde, Serde<V> valSerde, GroupedStreamAggregateBuilder<K, V> aggregateBuilder) {
        super(builder, name, sourceNodes);
        this.windows = windows;
        this.keySerde = keySerde;
        this.valSerde = valSerde;
        this.aggregateBuilder = aggregateBuilder;
    }

    @Override
    public KTable<Windowed<K>, Long> count() {
        return this.doAggregate(this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator, this.countMerger, Serdes.Long());
    }

    @Override
    public KTable<Windowed<K>, Long> count(Materialized<K, Long, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, Long, SessionStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.valueSerde() == null) {
            materialized.withValueSerde((Serde<Long>)Serdes.Long());
        }
        return this.aggregate(this.aggregateBuilder.countInitializer, this.aggregateBuilder.countAggregator, this.countMerger, materialized);
    }

    @Override
    public <T> KTable<Windowed<K>, T> aggregate(Initializer<T> initializer, Aggregator<? super K, ? super V, T> aggregator, Merger<? super K, T> sessionMerger) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(sessionMerger, "sessionMerger can't be null");
        return this.doAggregate(initializer, aggregator, sessionMerger, this.valSerde);
    }

    @Override
    public <VR> KTable<Windowed<K>, VR> aggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Merger<? super K, VR> sessionMerger, Materialized<K, VR, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(initializer, "initializer can't be null");
        Objects.requireNonNull(aggregator, "aggregator can't be null");
        Objects.requireNonNull(sessionMerger, "sessionMerger can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        MaterializedInternal<K, VR, SessionStore<Bytes, byte[]>> materializedInternal = new MaterializedInternal<K, VR, SessionStore<Bytes, byte[]>>(materialized, this.builder, "KSTREAM-AGGREGATE-");
        if (materializedInternal.keySerde() == null) {
            materializedInternal.withKeySerde(this.keySerde);
        }
        return this.aggregateBuilder.build(new KStreamSessionWindowAggregate<K, V, VR>(this.windows, materializedInternal.storeName(), initializer, aggregator, sessionMerger), "KSTREAM-AGGREGATE-", this.materialize(materializedInternal), true);
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        return this.doAggregate(this.reduceInitializer, this.aggregatorForReducer(reducer), this.mergerForAggregator(this.aggregatorForReducer(reducer)), this.valSerde);
    }

    @Override
    public KTable<Windowed<K>, V> reduce(Reducer<V> reducer, Materialized<K, V, SessionStore<Bytes, byte[]>> materialized) {
        Objects.requireNonNull(reducer, "reducer can't be null");
        Objects.requireNonNull(materialized, "materialized can't be null");
        Aggregator<K, V, V> reduceAggregator = this.aggregatorForReducer(reducer);
        return this.aggregate(this.reduceInitializer, reduceAggregator, this.mergerForAggregator(reduceAggregator), materialized);
    }

    private <VR> StoreBuilder<SessionStore<K, VR>> materialize(MaterializedInternal<K, VR, SessionStore<Bytes, byte[]>> materialized) {
        SessionBytesStoreSupplier supplier = (SessionBytesStoreSupplier)materialized.storeSupplier();
        if (supplier == null) {
            supplier = Stores.persistentSessionStore(materialized.storeName(), this.windows.maintainMs());
        }
        StoreBuilder<SessionStore<K, VR>> builder = Stores.sessionStoreBuilder(supplier, materialized.keySerde(), materialized.valueSerde());
        if (materialized.loggingEnabled()) {
            builder.withLoggingEnabled(materialized.logConfig());
        } else {
            builder.withLoggingDisabled();
        }
        if (materialized.cachingEnabled()) {
            builder.withCachingEnabled();
        }
        return builder;
    }

    private Merger<K, V> mergerForAggregator(final Aggregator<K, V, V> aggregator) {
        return new Merger<K, V>(){

            @Override
            public V apply(K aggKey, V aggOne, V aggTwo) {
                return aggregator.apply(aggKey, aggTwo, aggOne);
            }
        };
    }

    private Aggregator<K, V, V> aggregatorForReducer(final Reducer<V> reducer) {
        return new Aggregator<K, V, V>(){

            @Override
            public V apply(K aggKey, V value, V aggregate) {
                if (aggregate == null) {
                    return value;
                }
                return reducer.apply(aggregate, value);
            }
        };
    }

    private <VR> StoreBuilder<SessionStore<K, VR>> storeBuilder(String storeName, Serde<VR> aggValueSerde) {
        return Stores.sessionStoreBuilder(Stores.persistentSessionStore(storeName, this.windows.maintainMs()), this.keySerde, aggValueSerde).withCachingEnabled();
    }

    private <VR> KTable<Windowed<K>, VR> doAggregate(Initializer<VR> initializer, Aggregator<? super K, ? super V, VR> aggregator, Merger<? super K, VR> merger, Serde<VR> serde) {
        String storeName = this.builder.newStoreName("KSTREAM-AGGREGATE-");
        return this.aggregateBuilder.build(new KStreamSessionWindowAggregate<K, V, VR>(this.windows, storeName, initializer, aggregator, merger), "KSTREAM-AGGREGATE-", this.storeBuilder(storeName, serde), false);
    }
}

