/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import java.util.NoSuchElementException;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;
import org.apache.kafka.streams.state.WindowStoreIterator;
import org.apache.kafka.streams.state.internals.WindowStoreUtils;

class WindowStoreIteratorWrapper<K, V> {
    protected final KeyValueIterator<Bytes, byte[]> bytesIterator;
    protected final StateSerdes<K, V> serdes;
    protected final long windowSize;

    static WindowStoreIteratorWrapper<Bytes, byte[]> bytesIterator(KeyValueIterator<Bytes, byte[]> underlying, StateSerdes<Bytes, byte[]> serdes, long windowSize) {
        return new WrappedWindowStoreBytesIterator(underlying, serdes, windowSize);
    }

    WindowStoreIteratorWrapper(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<K, V> serdes, long windowSize) {
        this.bytesIterator = bytesIterator;
        this.serdes = serdes;
        this.windowSize = windowSize;
    }

    public WindowStoreIterator<V> valuesIterator() {
        return new WrappedWindowStoreIterator<V>(this.bytesIterator, this.serdes);
    }

    public KeyValueIterator<Windowed<K>, V> keyValueIterator() {
        return new WrappedKeyValueIterator<K, V>(this.bytesIterator, this.serdes, this.windowSize);
    }

    private static class WrappedKeyValueIterator<K, V>
    implements KeyValueIterator<Windowed<K>, V> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;
        final StateSerdes<K, V> serdes;
        final long windowSize;

        WrappedKeyValueIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<K, V> serdes, long windowSize) {
            this.bytesIterator = bytesIterator;
            this.serdes = serdes;
            this.windowSize = windowSize;
        }

        @Override
        public Windowed<K> peekNextKey() {
            byte[] nextKey = this.bytesIterator.peekNextKey().get();
            long timestamp = WindowStoreUtils.timestampFromBinaryKey(nextKey);
            K key = WindowStoreUtils.keyFromBinaryKey(nextKey, this.serdes);
            return new Windowed<K>(key, WindowStoreUtils.timeWindowForSize(timestamp, this.windowSize));
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Windowed<K>, V> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            long timestamp = WindowStoreUtils.timestampFromBinaryKey(((Bytes)next.key).get());
            K key = WindowStoreUtils.keyFromBinaryKey(((Bytes)next.key).get(), this.serdes);
            V value = this.serdes.valueFrom((byte[])next.value);
            return KeyValue.pair(new Windowed<K>(key, WindowStoreUtils.timeWindowForSize(timestamp, this.windowSize)), value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }

    private static class WrappedWindowStoreIterator<V>
    implements WindowStoreIterator<V> {
        final KeyValueIterator<Bytes, byte[]> bytesIterator;
        final StateSerdes<?, V> serdes;

        WrappedWindowStoreIterator(KeyValueIterator<Bytes, byte[]> bytesIterator, StateSerdes<?, V> serdes) {
            this.bytesIterator = bytesIterator;
            this.serdes = serdes;
        }

        @Override
        public Long peekNextKey() {
            return WindowStoreUtils.timestampFromBinaryKey(this.bytesIterator.peekNextKey().get());
        }

        @Override
        public boolean hasNext() {
            return this.bytesIterator.hasNext();
        }

        @Override
        public KeyValue<Long, V> next() {
            KeyValue next = (KeyValue)this.bytesIterator.next();
            long timestamp = WindowStoreUtils.timestampFromBinaryKey(((Bytes)next.key).get());
            V value = this.serdes.valueFrom((byte[])next.value);
            return KeyValue.pair(timestamp, value);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove() is not supported in " + this.getClass().getName());
        }

        @Override
        public void close() {
            this.bytesIterator.close();
        }
    }

    private static class WrappedWindowStoreBytesIterator
    extends WindowStoreIteratorWrapper<Bytes, byte[]> {
        WrappedWindowStoreBytesIterator(KeyValueIterator<Bytes, byte[]> underlying, StateSerdes<Bytes, byte[]> serdes, long windowSize) {
            super(underlying, serdes, windowSize);
        }

        @Override
        public WindowStoreIterator<byte[]> valuesIterator() {
            return new WrappedWindowStoreIterator<byte[]>(this.bytesIterator, this.serdes){

                @Override
                public KeyValue<Long, byte[]> next() {
                    KeyValue next = (KeyValue)this.bytesIterator.next();
                    long timestamp = WindowStoreUtils.timestampFromBinaryKey(((Bytes)next.key).get());
                    return KeyValue.pair(timestamp, next.value);
                }
            };
        }

        @Override
        public KeyValueIterator<Windowed<Bytes>, byte[]> keyValueIterator() {
            return new WrappedKeyValueIterator<Bytes, byte[]>(this.bytesIterator, this.serdes, this.windowSize){

                @Override
                public Windowed<Bytes> peekNextKey() {
                    Bytes next = (Bytes)this.bytesIterator.peekNextKey();
                    long timestamp = WindowStoreUtils.timestampFromBinaryKey(next.get());
                    Bytes key = WindowStoreUtils.bytesKeyFromBinaryKey(next.get());
                    return new Windowed<Bytes>(key, WindowStoreUtils.timeWindowForSize(timestamp, this.windowSize));
                }

                @Override
                public KeyValue<Windowed<Bytes>, byte[]> next() {
                    if (!this.bytesIterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    KeyValue next = (KeyValue)this.bytesIterator.next();
                    long timestamp = WindowStoreUtils.timestampFromBinaryKey(((Bytes)next.key).get());
                    Bytes key = WindowStoreUtils.bytesKeyFromBinaryKey(((Bytes)next.key).get());
                    return KeyValue.pair(new Windowed<Bytes>(key, WindowStoreUtils.timeWindowForSize(timestamp, this.windowSize)), next.value);
                }
            };
        }
    }
}

