/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Properties;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.admin.AdminOperationException;
import kafka.admin.AdminUtils$;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareMode;
import kafka.admin.RackAwareMode$Disabled$;
import kafka.admin.RackAwareMode$Enforced$;
import kafka.admin.TopicCommand;
import kafka.common.AdminCommandFailedException;
import kafka.consumer.Whitelist;
import kafka.controller.LeaderIsrAndControllerEpoch;
import kafka.log.LogConfig$;
import kafka.server.ConfigType$;
import kafka.utils.CommandLineUtils$;
import kafka.utils.CoreUtils$;
import kafka.utils.Exit$;
import kafka.utils.Implicits$;
import kafka.utils.Logging;
import kafka.zk.AdminZkClient;
import kafka.zk.KafkaZkClient;
import kafka.zk.KafkaZkClient$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidTopicException;
import org.apache.kafka.common.errors.TopicExistsException;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.zookeeper.KeeperException;
import scala.Array$;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.Iterable$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class TopicCommand$
implements Logging {
    public static TopicCommand$ MODULE$;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    static {
        new TopicCommand$();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        TopicCommand$ topicCommand$ = this;
        synchronized (topicCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        return !this.bitmap$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void main(String[] args) {
        TopicCommand.TopicCommandOptions opts = new TopicCommand.TopicCommandOptions(args);
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Create, delete, describe, or change a topic.");
        }
        int actions = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.createOpt(), opts.listOpt(), opts.alterOpt(), opts.describeOpt(), opts.deleteOpt()}))).count((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$main$1(opts, x$1)));
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --list, --describe, --create, --alter or --delete");
        }
        opts.checkArgs();
        Time time = Time.SYSTEM;
        KafkaZkClient zkClient = KafkaZkClient$.MODULE$.apply((String)opts.options().valueOf(opts.zkConnectOpt()), JaasUtils.isZkSecurityEnabled(), 30000, 30000, Integer.MAX_VALUE, time, KafkaZkClient$.MODULE$.apply$default$7(), KafkaZkClient$.MODULE$.apply$default$8());
        int exitCode = 0;
        try {
            try {
                if (opts.options().has((OptionSpec)opts.createOpt())) {
                    this.createTopic(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.alterOpt())) {
                    this.alterTopic(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.listOpt())) {
                    this.listTopics(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.describeOpt())) {
                    this.describeTopic(zkClient, opts);
                }
                if (opts.options().has((OptionSpec)opts.deleteOpt())) {
                    this.deleteTopic(zkClient, opts);
                }
            }
            catch (Throwable e) {
                Predef$.MODULE$.println((Object)("Error while executing topic command : " + e.getMessage()));
                this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> Utils.stackTrace((Throwable)e));
                exitCode = 1;
            }
        }
        finally {
            zkClient.close();
            throw Exit$.MODULE$.exit(exitCode, Exit$.MODULE$.exit$default$2());
        }
    }

    /*
     * WARNING - void declaration
     */
    private Seq<String> getTopics(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        Seq allTopics = (Seq)zkClient.getAllTopicsInCluster().sorted((Ordering)Ordering.String$.MODULE$);
        if (opts.options().has(opts.topicOpt())) {
            String topicsSpec = (String)opts.options().valueOf(opts.topicOpt());
            Whitelist topicsFilter = new Whitelist(topicsSpec);
            seq = (Seq)allTopics.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)topicsFilter.isTopicAllowed(x$1, false)));
        } else {
            void var3_3;
            seq = var3_3;
        }
        return seq;
    }

    public void createTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        block5: {
            String topic = (String)opts.options().valueOf(opts.topicOpt());
            Properties configs = this.parseTopicConfigsToBeAdded(opts);
            boolean ifNotExists = opts.options().has((OptionSpec)opts.ifNotExistsOpt());
            if (Topic.hasCollisionChars((String)topic)) {
                Predef$.MODULE$.println((Object)"WARNING: Due to limitations in metric names, topics with a period ('.') or underscore ('_') could collide. To avoid issues it is best to use either, but not both.");
            }
            AdminZkClient adminZkClient = new AdminZkClient(zkClient);
            try {
                if (opts.options().has(opts.replicaAssignmentOpt())) {
                    Map<Object, List<Object>> assignment = this.parseReplicaAssignment((String)opts.options().valueOf(opts.replicaAssignmentOpt()));
                    adminZkClient.createOrUpdateTopicPartitionAssignmentPathInZK(topic, assignment, configs, false);
                } else {
                    CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), (Seq<OptionSpec<?>>)Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.partitionsOpt(), opts.replicationFactorOpt()}));
                    int partitions = (Integer)opts.options().valueOf(opts.partitionsOpt());
                    int replicas = (Integer)opts.options().valueOf(opts.replicationFactorOpt());
                    Product rackAwareMode = opts.options().has((OptionSpec)opts.disableRackAware()) ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
                    adminZkClient.createTopic(topic, partitions, replicas, configs, (RackAwareMode)rackAwareMode);
                }
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Created topic \"%s\".")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            catch (TopicExistsException e) {
                if (ifNotExists) break block5;
                throw e;
            }
        }
    }

    public void alterTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean ifExists = opts.options().has((OptionSpec)opts.ifExistsOpt());
        if (topics.isEmpty() && !ifExists) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Topic %s does not exist on ZK path %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.options().valueOf(opts.topicOpt()), opts.options().valueOf(opts.zkConnectOpt())})));
        }
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicCommand$.$anonfun$alterTopic$1(zkClient, opts, adminZkClient, topic);
            return BoxedUnit.UNIT;
        });
    }

    public void listTopics(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicCommand$.$anonfun$listTopics$1(zkClient, topic);
            return BoxedUnit.UNIT;
        });
    }

    public void deleteTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean ifExists = opts.options().has((OptionSpec)opts.ifExistsOpt());
        if (topics.isEmpty() && !ifExists) {
            throw new IllegalArgumentException(new StringOps(Predef$.MODULE$.augmentString("Topic %s does not exist on ZK path %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{opts.options().valueOf(opts.topicOpt()), opts.options().valueOf(opts.zkConnectOpt())})));
        }
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicCommand$.$anonfun$deleteTopic$1(zkClient, topic);
            return BoxedUnit.UNIT;
        });
    }

    public void describeTopic(KafkaZkClient zkClient, TopicCommand.TopicCommandOptions opts) {
        Seq<String> topics = this.getTopics(zkClient, opts);
        boolean reportUnderReplicatedPartitions = opts.options().has((OptionSpec)opts.reportUnderReplicatedPartitionsOpt());
        boolean reportUnavailablePartitions = opts.options().has((OptionSpec)opts.reportUnavailablePartitionsOpt());
        boolean reportOverriddenConfigs = opts.options().has((OptionSpec)opts.topicsWithOverridesOpt());
        Set liveBrokers = ((TraversableOnce)zkClient.getAllBrokersInCluster().map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.id()), Seq$.MODULE$.canBuildFrom())).toSet();
        AdminZkClient adminZkClient = new AdminZkClient(zkClient);
        topics.foreach((Function1 & Serializable & scala.Serializable)topic -> {
            TopicCommand$.$anonfun$describeTopic$2(zkClient, reportUnderReplicatedPartitions, reportUnavailablePartitions, reportOverriddenConfigs, liveBrokers, adminZkClient, topic);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public Properties parseTopicConfigsToBeAdded(TopicCommand.TopicCommandOptions opts) {
        void var3_3;
        block0: {
            Buffer configsToBeAdded = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.configOpt())).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.split("\\s*=\\s*"), Buffer$.MODULE$.canBuildFrom());
            Predef$.MODULE$.require(configsToBeAdded.forall((Function1 & Serializable & scala.Serializable)config -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$parseTopicConfigsToBeAdded$3(config))), (Function0 & Serializable & scala.Serializable)() -> "Invalid topic config: all configs to be added must be in the format \"key=val\".");
            Properties props = new Properties();
            configsToBeAdded.foreach((Function1 & Serializable & scala.Serializable)pair -> props.setProperty(pair[0].trim(), pair[1].trim()));
            LogConfig$.MODULE$.validate(props);
            if (!props.containsKey(LogConfig$.MODULE$.MessageFormatVersionProp())) break block0;
            Predef$.MODULE$.println((Object)(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"WARNING: The configuration ", "=", " is specified. "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{LogConfig$.MODULE$.MessageFormatVersionProp(), props.getProperty(LogConfig$.MODULE$.MessageFormatVersionProp())})) + new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"This configuration will be ignored if the version is newer than the inter.broker.protocol.version specified in the broker."})).s((Seq)Nil$.MODULE$)));
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> parseTopicConfigsToBeDeleted(TopicCommand.TopicCommandOptions opts) {
        Seq seq;
        if (opts.options().has(opts.deleteConfigOpt())) {
            void var2_2;
            Buffer configsToBeDeleted = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.deleteConfigOpt())).asScala()).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.trim(), Buffer$.MODULE$.canBuildFrom());
            Properties propsToBeDeleted = new Properties();
            configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)x$8 -> propsToBeDeleted.setProperty((String)x$8, ""));
            LogConfig$.MODULE$.validateNames(propsToBeDeleted);
            seq = var2_2;
        } else {
            seq = (Seq)Seq$.MODULE$.empty();
        }
        return seq;
    }

    public Map<Object, List<Object>> parseReplicaAssignment(String replicaAssignmentList) {
        String[] partitionList = replicaAssignmentList.split(",");
        HashMap ret = new HashMap();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList)).size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            int[] brokerList = (int[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList[i].split(":"))).map((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToInteger((int)TopicCommand$.$anonfun$parseReplicaAssignment$2(s)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Iterable duplicateBrokers = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerList));
            if (duplicateBrokers.nonEmpty()) {
                throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{duplicateBrokers.mkString(",")})));
            }
            ret.put((Object)BoxesRunTime.boxToInteger((int)i), (Object)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(brokerList)).toList());
            if (((SeqLike)ret.apply((Object)BoxesRunTime.boxToInteger((int)i))).size() != ((SeqLike)ret.apply((Object)BoxesRunTime.boxToInteger((int)0))).size()) {
                throw new AdminOperationException("Partition " + i + " has different replication factor: " + brokerList);
            }
        });
        return ret.toMap(Predef$.MODULE$.$conforms());
    }

    public void askToProceed() {
        Predef$.MODULE$.println((Object)"Are you sure you want to continue? [y/n]");
        if (!Console$.MODULE$.readLine().equalsIgnoreCase("y")) {
            Predef$.MODULE$.println((Object)"Ending your session");
            throw Exit$.MODULE$.exit(0, Exit$.MODULE$.exit$default$2());
        }
    }

    public static final /* synthetic */ boolean $anonfun$main$1(TopicCommand.TopicCommandOptions opts$1, OptionSpec x$1) {
        return opts$1.options().has(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$alterTopic$4(String x$2) {
        return new StringOps(Predef$.MODULE$.augmentString(x$2)).nonEmpty();
    }

    public static final /* synthetic */ void $anonfun$alterTopic$1(KafkaZkClient zkClient$1, TopicCommand.TopicCommandOptions opts$2, AdminZkClient adminZkClient$1, String topic) {
        block3: {
            Properties configs = adminZkClient$1.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic);
            if (opts$2.options().has(opts$2.configOpt()) || opts$2.options().has(opts$2.deleteConfigOpt())) {
                Predef$.MODULE$.println((Object)"WARNING: Altering topic configuration from this script has been deprecated and may be removed in future releases.");
                Predef$.MODULE$.println((Object)"         Going forward, please use kafka-configs.sh for this functionality");
                Properties configsToBeAdded = MODULE$.parseTopicConfigsToBeAdded(opts$2);
                Seq<String> configsToBeDeleted = MODULE$.parseTopicConfigsToBeDeleted(opts$2);
                Implicits$.MODULE$.PropertiesOps(configs).$plus$plus$eq(configsToBeAdded);
                configsToBeDeleted.foreach((Function1 & Serializable & scala.Serializable)config -> configs.remove(config));
                adminZkClient$1.changeTopicConfig(topic, configs);
                Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Updated config for topic \"%s\".")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            if (!opts$2.options().has(opts$2.partitionsOpt())) break block3;
            String string = topic;
            String string2 = "__consumer_offsets";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                throw new IllegalArgumentException("The number of partitions for the offsets topic cannot be changed.");
            }
            Predef$.MODULE$.println((Object)"WARNING: If partitions are increased for a topic that has a key, the partition logic or ordering of the messages will be affected");
            int nPartitions = (Integer)opts$2.options().valueOf(opts$2.partitionsOpt());
            scala.collection.immutable.Map existingAssignment = (scala.collection.immutable.Map)zkClient$1.getReplicaAssignmentForTopics((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                TopicPartition topicPartition = (TopicPartition)tuple2._1();
                Seq replicas = (Seq)tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition())), (Object)replicas);
                return tuple22;
            }, Map$.MODULE$.canBuildFrom());
            if (existingAssignment.isEmpty()) {
                throw new InvalidTopicException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The topic ", " does not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            String replicaAssignmentStr = (String)opts$2.options().valueOf(opts$2.replicaAssignmentOpt());
            Option newAssignment = Option$.MODULE$.apply((Object)replicaAssignmentStr).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$alterTopic$4(x$2))).map((Function1 & Serializable & scala.Serializable)replicaAssignmentString -> {
                int startPartitionId = existingAssignment.size();
                String[] partitionList = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])replicaAssignmentString.split(","))).drop(startPartitionId);
                return AdminUtils$.MODULE$.parseReplicaAssignment(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])partitionList)).mkString(","), startPartitionId);
            });
            Seq<BrokerMetadata> allBrokers = adminZkClient$1.getBrokerMetadatas(adminZkClient$1.getBrokerMetadatas$default$1(), adminZkClient$1.getBrokerMetadatas$default$2());
            adminZkClient$1.addPartitions(topic, (Map<Object, Seq<Object>>)existingAssignment, allBrokers, nPartitions, (Option<Map<Object, Seq<Object>>>)newAssignment, adminZkClient$1.addPartitions$default$6());
            Predef$.MODULE$.println((Object)"Adding partitions succeeded!");
        }
    }

    public static final /* synthetic */ void $anonfun$listTopics$1(KafkaZkClient zkClient$2, String topic) {
        if (zkClient$2.isTopicMarkedForDeletion(topic)) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("%s - marked for deletion")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        } else {
            Predef$.MODULE$.println((Object)topic);
        }
    }

    public static final /* synthetic */ void $anonfun$deleteTopic$1(KafkaZkClient zkClient$4, String topic) {
        try {
            if (Topic.isInternal((String)topic)) {
                throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Topic %s is a kafka internal topic and is not allowed to be marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            }
            zkClient$4.createDeleteTopicPath(topic);
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic %s is marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
            Predef$.MODULE$.println((Object)"Note: This will have no impact if delete.topic.enable is not set to true.");
        }
        catch (KeeperException.NodeExistsException nodeExistsException) {
            Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic %s is already marked for deletion.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
        catch (AdminOperationException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new AdminOperationException(new StringOps(Predef$.MODULE$.augmentString("Error while deleting topic %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})));
        }
    }

    public static final /* synthetic */ boolean $anonfun$describeTopic$5(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$describeTopic$6(KafkaZkClient zkClient$3, boolean reportUnderReplicatedPartitions$1, boolean reportUnavailablePartitions$1, Set liveBrokers$1, boolean describeConfigs$1, boolean markedForDeletion$1, String topic$1, Tuple2 x$5) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$5;
        if (tuple2 != null) {
            None$ leader;
            int partitionId = tuple2._1$mcI$sp();
            Seq assignedReplicas = (Seq)tuple2._2();
            Option<LeaderIsrAndControllerEpoch> leaderIsrEpoch = zkClient$3.getTopicPartitionState(new TopicPartition(topic$1, partitionId));
            List<Object> inSyncReplicas = leaderIsrEpoch.isEmpty() ? (List<Object>)Seq$.MODULE$.empty() : ((LeaderIsrAndControllerEpoch)leaderIsrEpoch.get()).leaderAndIsr().isr();
            Object object = leader = leaderIsrEpoch.isEmpty() ? None$.MODULE$ : Option$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)((LeaderIsrAndControllerEpoch)leaderIsrEpoch.get()).leaderAndIsr().leader()));
            if (!reportUnderReplicatedPartitions$1 && !reportUnavailablePartitions$1 || reportUnderReplicatedPartitions$1 && inSyncReplicas.size() < assignedReplicas.size() || reportUnavailablePartitions$1 && (leader.isEmpty() || !liveBrokers$1.contains(leader.get()))) {
                String markedForDeletionString = markedForDeletion$1 && !describeConfigs$1 ? "\tMarkedForDeletion: true" : "";
                Predef$.MODULE$.print((Object)("\tTopic: " + topic$1));
                Predef$.MODULE$.print((Object)("\tPartition: " + partitionId));
                Predef$.MODULE$.print((Object)("\tLeader: " + (leader.isDefined() ? leader.get() : "none")));
                Predef$.MODULE$.print((Object)("\tReplicas: " + assignedReplicas.mkString(",")));
                Predef$.MODULE$.print((Object)("\tIsr: " + inSyncReplicas.mkString(",")));
                Predef$.MODULE$.print((Object)markedForDeletionString);
                Predef$.MODULE$.println();
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$describeTopic$2(KafkaZkClient zkClient$3, boolean reportUnderReplicatedPartitions$1, boolean reportUnavailablePartitions$1, boolean reportOverriddenConfigs$1, Set liveBrokers$1, AdminZkClient adminZkClient$2, String topic) {
        Option option = zkClient$3.getPartitionAssignmentForTopics((Set<String>)((Set)Set$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})))).get((Object)topic);
        if (option instanceof Some) {
            BoxedUnit boxedUnit;
            Some some = (Some)option;
            scala.collection.immutable.Map topicPartitionAssignment = (scala.collection.immutable.Map)some.value();
            boolean describeConfigs = !reportUnavailablePartitions$1 && !reportUnderReplicatedPartitions$1;
            boolean describePartitions = !reportOverriddenConfigs$1;
            Seq sortedPartitions = (Seq)topicPartitionAssignment.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToInteger((int)x$4._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
            boolean markedForDeletion = zkClient$3.isTopicMarkedForDeletion(topic);
            if (describeConfigs) {
                scala.collection.mutable.Map configs = (scala.collection.mutable.Map)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(adminZkClient$2.fetchEntityConfig(ConfigType$.MODULE$.Topic(), topic)).asScala();
                if (!reportOverriddenConfigs$1 || configs.nonEmpty()) {
                    int numPartitions = topicPartitionAssignment.size();
                    int replicationFactor = ((SeqLike)((Tuple2)topicPartitionAssignment.head())._2()).size();
                    String configsAsString = ((TraversableOnce)configs.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String k = (String)tuple2._1();
                        String v = (String)tuple2._2();
                        String string = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{k, v}));
                        return string;
                    }, Iterable$.MODULE$.canBuildFrom())).mkString(",");
                    String markedForDeletionString = markedForDeletion ? "\tMarkedForDeletion:true" : "";
                    Predef$.MODULE$.println((Object)new StringOps(Predef$.MODULE$.augmentString("Topic:%s\tPartitionCount:%d\tReplicationFactor:%d\tConfigs:%s%s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)numPartitions), BoxesRunTime.boxToInteger((int)replicationFactor), configsAsString, markedForDeletionString})));
                }
            }
            if (describePartitions) {
                sortedPartitions.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)TopicCommand$.$anonfun$describeTopic$5(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
                    TopicCommand$.$anonfun$describeTopic$6(zkClient$3, reportUnderReplicatedPartitions$1, reportUnavailablePartitions$1, liveBrokers$1, describeConfigs, markedForDeletion, topic, x$5);
                    return BoxedUnit.UNIT;
                });
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            BoxedUnit boxedUnit2 = boxedUnit;
        } else if (None$.MODULE$.equals(option)) {
            Predef$.MODULE$.println((Object)("Topic " + topic + " doesn't exist!"));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)option);
        }
    }

    public static final /* synthetic */ boolean $anonfun$parseTopicConfigsToBeAdded$3(String[] config) {
        return config.length == 2;
    }

    public static final /* synthetic */ int $anonfun$parseReplicaAssignment$2(String s) {
        return new StringOps(Predef$.MODULE$.augmentString(s.trim())).toInt();
    }

    private TopicCommand$() {
        MODULE$ = this;
        Logging.$init$(this);
    }
}

