// -*- c++ -*-
//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.
//===========================================================================

#include <iostream>
#include "mtl/mtl.h"
#include "mtl/matrix.h"

using namespace mtl;


int
main()
{
  const int M = 4, N = 3;

  //begin
  typedef matrix< double, 
                  rectangle<>, 
                  array< dense<> >, 
                  row_major>::type MatA;

  typedef matrix< double, 
                  rectangle<>, 
                  array< compressed<> >, 
                  row_major>::type MatB;

  typedef matrix< double, 
                  rectangle<>, 
                  array< sparse_pair >, 
                  row_major>::type MatC;
  std::cout << "start" << std::endl;
  MatA A(M,N);
  MatB B(M,N);
  MatC C(M, N);
  // Fill A ...
  //end
  for (int i = 0; i < M; ++i)
    for (int j = 0; j < N; ++j)
      A(i,j) = i * N + j;
  //begin
  mtl::copy(A, B); // JGS, this is broken!
#if 0
  MatB::Row tmp = B[2];
  B[2] = B[3];
  B[3] = tmp;

  mtl::copy(B, C);
  //end
#endif
  mtl::print_all_matrix(A);
  mtl::print_all_matrix(B);
  mtl::print_all_matrix(C);

  return 0;
}
