/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm;

import org.netbeans.modules.cnd.antlr.collections.AST;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstRenderer;
import org.netbeans.modules.cnd.modelimpl.csm.core.AstUtil;
import org.netbeans.modules.cnd.modelimpl.parser.FakeAST;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.openide.util.CharSequences;

public class CastUtils {
    public static boolean isCast(AST ast) {
        switch (ast.getType()) {
            case 546: 
            case 555: 
            case 556: 
            case 557: 
            case 558: {
                return true;
            }
        }
        return false;
    }

    public static AST transform(AST ast) {
        assert (CastUtils.isCast(ast));
        AST nameStart = CastUtils.findCastOperatorNameStart(ast);
        AST nameEnd = CastUtils.findCastOperatorNameEnd(ast);
        FakeAST transformed = new FakeAST();
        transformed.setType(ast.getType());
        transformed.setFirstChild(AstUtil.cloneAST(ast.getFirstChild(), nameStart, false));
        FakeAST qualifiedName = new FakeAST();
        qualifiedName.setType(574);
        qualifiedName.setFirstChild(AstUtil.cloneAST(nameStart, nameEnd));
        AstUtil.getLastChild((AST)transformed).setNextSibling((AST)qualifiedName);
        qualifiedName.setNextSibling(AstUtil.cloneAST(nameEnd.getNextSibling(), AstUtil.getLastChild(ast)));
        return transformed;
    }

    public static String getFunctionName(AST ast) {
        assert (CastUtils.isCast(ast));
        AST operator = AstUtil.findChildOfType(ast, 110);
        if (operator == null) {
            return "operator ???";
        }
        StringBuilder sb = new StringBuilder(AstUtil.getText(operator));
        sb.append(' ');
        block6: for (AST next = operator.getNextSibling(); next != null; next = next.getNextSibling()) {
            switch (next.getType()) {
                case 536: 
                case 537: 
                case 539: {
                    sb.append(' ');
                    CastUtils.addTypeText(next, sb);
                    continue block6;
                }
                case 606: {
                    CastUtils.addTypeText(next, sb);
                    continue block6;
                }
                case 12: {
                    break block6;
                }
                case 32: 
                case 43: 
                case 136: 
                case 137: 
                case 138: {
                    sb.append(AstUtil.getText(next));
                    continue block6;
                }
                default: {
                    sb.append(' ');
                    sb.append(AstUtil.getText(next));
                }
            }
        }
        return sb.toString();
    }

    public static CharSequence getFunctionRawName(AST token) {
        return CastUtils.getFunctionRawName(token, ".");
    }

    public static CharSequence getFunctionRawName(AST token, String separator) {
        assert (CastUtils.isCast(token));
        AST ast = token;
        StringBuilder l = new StringBuilder();
        block5: for (token = token.getFirstChild(); token != null; token = token.getNextSibling()) {
            switch (token.getType()) {
                case 91: {
                    if (l.length() > 0) {
                        l.append(separator);
                    }
                    l.append(AstUtil.getText(token));
                    continue block5;
                }
                case 52: {
                    continue block5;
                }
                case 110: {
                    if (l.length() > 0) {
                        l.append(separator);
                    }
                    l.append(CastUtils.getFunctionName(ast));
                    return NameCache.getManager().getString(CharSequences.create((CharSequence)l));
                }
            }
        }
        return NameCache.getManager().getString(CharSequences.create((CharSequence)l));
    }

    private static void addTypeText(AST ast, StringBuilder sb) {
        if (ast == null) {
            return;
        }
        for (AST child = ast.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (520 <= child.getType() && child.getType() <= 613) {
                CastUtils.addTypeText(child, sb);
                continue;
            }
            CharSequence text = AstUtil.getText(child);
            assert (text != null);
            assert (text.length() > 0);
            if (sb.length() > 0 && Character.isLetterOrDigit(sb.charAt(sb.length() - 1)) && Character.isLetterOrDigit(text.charAt(0))) {
                sb.append(' ');
            }
            sb.append(text);
        }
    }

    public static boolean isMemberDefinition(AST ast) {
        assert (CastUtils.isCast(ast));
        AST child = ast.getFirstChild();
        while (child != null && child.getType() == 117) {
            child = AstRenderer.skipTemplateSibling(child);
        }
        child = AstRenderer.getFirstSiblingSkipInline(child);
        if ((child = AstRenderer.getFirstSiblingSkipQualifiers(child)) != null && child.getType() == 91) {
            if ((child = child.getNextSibling()) != null && child.getType() == 21) {
                child = AstRenderer.skipTemplateParameters(child);
            }
            if (child != null && child.getType() == 52) {
                return true;
            }
        }
        return false;
    }

    public static boolean isCastOperatorOnlySpecialization(AST ast) {
        assert (CastUtils.isCast(ast));
        AST operator = AstUtil.findChildOfType(ast, 110);
        if (operator != null) {
            for (AST nameStart = CastUtils.findCastOperatorNameStart(ast); nameStart != null && nameStart != operator; nameStart = nameStart.getNextSibling()) {
                if (nameStart.getType() != 21) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static AST findCastOperatorNameStart(AST ast) {
        assert (CastUtils.isCast(ast));
        AST lastTemplateInHeader = ast.getFirstChild();
        if (lastTemplateInHeader != null && lastTemplateInHeader.getType() != 117) {
            return lastTemplateInHeader;
        }
        AST current = lastTemplateInHeader;
        while (current != null && current.getNextSibling() != null && current.getNextSibling().getType() == 21) {
            lastTemplateInHeader = current;
            current = AstUtil.findSiblingOfType(current.getNextSibling(), 117);
        }
        return AstUtil.findSiblingOfType(lastTemplateInHeader, 23).getNextSibling();
    }

    public static AST findCastOperatorNameEnd(AST ast) {
        AST nameStart;
        assert (CastUtils.isCast(ast));
        AST nameEnd = nameStart = CastUtils.findCastOperatorNameStart(ast);
        while (nameStart != null && nameStart.getType() != 12) {
            nameEnd = nameStart;
            nameStart = nameStart.getNextSibling();
        }
        return nameEnd;
    }
}

