/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmSortUtilities;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.Resolver;
import org.netbeans.modules.cnd.modelimpl.csm.resolver.ResolverFactory;
import org.netbeans.modules.cnd.modelutil.ClassifiersAntiLoop;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;

public final class MemberResolverImpl {
    public CsmMember getDeclaration(CsmClassifier cls, CharSequence name) {
        Iterator<CsmMember> declarations = this.getDeclarations(cls, name, true);
        if (declarations.hasNext()) {
            return declarations.next();
        }
        return null;
    }

    public Iterator<CsmMember> getDeclarations(CsmClassifier cls, CharSequence name) {
        return this.getDeclarations(cls, name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<CsmMember> getDeclarations(CsmClassifier cls, CharSequence name, boolean first) {
        if (CsmKindUtilities.isOffsetable((Object)cls)) {
            if (CharSequenceUtils.indexOf((CharSequence)name, (char)':') >= 0) {
                CndUtils.assertTrueInConsole((boolean)false, (String)("Attempt to find member \"" + name + "\" in the class " + cls.getQualifiedName()));
                return Collections.emptyList().iterator();
            }
            Resolver aResolver = ResolverFactory.createResolver((CsmOffsetable)cls);
            try {
                cls = aResolver.getOriginalClassifier(cls);
            }
            finally {
                ResolverFactory.releaseResolver(aResolver);
            }
            if (CsmKindUtilities.isClass((CsmObject)cls)) {
                ArrayList<CsmMember> res = new ArrayList<CsmMember>();
                this.getClassMembers((CsmClass)cls, name, res, first);
                this.getSuperClasses((CsmClass)cls, name, res, first, new ClassifiersAntiLoop());
                return res.iterator();
            }
        }
        return Collections.emptyList().iterator();
    }

    private void getClassMembers(CsmClass cls, CharSequence name, List<CsmMember> res, boolean first) {
        Iterator it = CsmSelect.getClassMembers((CsmClass)cls, (CsmSelect.CsmFilter)CsmSelect.getFilterBuilder().createNameFilter(name, true, true, false));
        while (it.hasNext()) {
            CsmMember m = (CsmMember)it.next();
            if (!CsmSortUtilities.matchName((CharSequence)m.getName(), (CharSequence)name, (boolean)true, (boolean)true)) continue;
            res.add(m);
            if (!first) continue;
            return;
        }
    }

    private void getSuperClasses(CsmClass cls, CharSequence name, List<CsmMember> res, boolean first, ClassifiersAntiLoop antiLoop) {
        if (first && !res.isEmpty()) {
            return;
        }
        if (antiLoop.contains((CsmClassifier)cls)) {
            return;
        }
        antiLoop.add((CsmClassifier)cls);
        for (CsmInheritance inh : cls.getBaseClasses()) {
            CsmVisibility v = inh.getVisibility();
            switch (v) {
                case PRIVATE: {
                    break;
                }
                default: {
                    CsmClass base = CsmInheritanceUtilities.getCsmClass((CsmInheritance)inh);
                    if (base == null) break;
                    this.getClassMembers(base, name, res, first);
                    this.getSuperClasses(base, name, res, first, antiLoop);
                }
            }
            if (!first || res.isEmpty()) continue;
            return;
        }
    }

    public Iterator<CsmClassifier> getNestedClassifiers(CsmClassifier cls, CharSequence name) {
        Iterator<CsmMember> it = this.getDeclarations(cls, name);
        ArrayList<CsmClassifier> res = new ArrayList<CsmClassifier>();
        while (it.hasNext()) {
            CsmMember m = it.next();
            if (!CsmKindUtilities.isClassifier((CsmObject)m)) continue;
            res.add((CsmClassifier)m);
        }
        if (CsmKindUtilities.isClass((CsmObject)cls) && CsmSortUtilities.matchName((CharSequence)cls.getName(), (CharSequence)name, (boolean)true, (boolean)true)) {
            res.add(cls);
        }
        return res.iterator();
    }
}

