/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.parser.apt;

import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.modelimpl.csm.core.FilePreprocessorConditionState;
import org.netbeans.modules.cnd.modelimpl.parser.apt.APTParseFileWalker;

public final class APTBasedPCStateBuilder
implements APTParseFileWalker.EvalCallback {
    private final SortedSet<int[]> blocks = new TreeSet<int[]>(COMPARATOR);
    private final CharSequence name;
    private static final Comparator<int[]> COMPARATOR = new Comparator<int[]>(){

        @Override
        public int compare(int[] segment1, int[] segment2) {
            return segment1[0] - segment2[0];
        }
    };

    public APTBasedPCStateBuilder(CharSequence name) {
        this.name = name;
    }

    final APTBasedPCStateBuilder addBlockImpl(int startDeadBlock, int endDeadBlock) {
        assert (endDeadBlock >= startDeadBlock) : "incorrect offsets " + startDeadBlock + " and " + endDeadBlock;
        if (endDeadBlock > startDeadBlock) {
            this.blocks.add(new int[]{startDeadBlock, endDeadBlock});
        }
        return this;
    }

    private void addDeadBlock(APT startNode, APT endNode) {
        if (startNode != null && endNode != null) {
            int startDeadBlock = startNode.getEndOffset();
            int endDeadBlock = endNode.getOffset() - 1;
            this.addBlockImpl(startDeadBlock, endDeadBlock);
        }
    }

    @Override
    public void onErrorDirective(APT apt) {
        this.addBlockImpl(Integer.MAX_VALUE - apt.getToken().getOffset(), Integer.MAX_VALUE);
    }

    @Override
    public void onPragmaOnceDirective(APT apt) {
        this.addBlockImpl(apt.getToken().getOffset(), 0x7FFFFFFE);
    }

    @Override
    public void onEval(APT apt, boolean result) {
        if (result) {
            APT end;
            APT start = apt.getNextSibling();
            block7: while (start != null && (end = start.getNextSibling()) != null) {
                switch (end.getType()) {
                    case 10: 
                    case 11: {
                        this.addDeadBlock(start, end);
                        start = end;
                        continue block7;
                    }
                    case 12: {
                        this.addDeadBlock(start, end);
                        start = null;
                        continue block7;
                    }
                }
                start = null;
            }
        } else {
            APT end = apt.getNextSibling();
            if (end != null) {
                switch (end.getType()) {
                    case 10: 
                    case 11: 
                    case 12: {
                        this.addDeadBlock(apt, end);
                    }
                }
            }
        }
    }

    public FilePreprocessorConditionState build() {
        int size = 0;
        for (int[] deadInterval : this.blocks) {
            ++size;
            if (deadInterval[1] != Integer.MAX_VALUE) continue;
            break;
        }
        int[] offsets = new int[size * 2];
        int index = 0;
        for (int[] deadInterval : this.blocks) {
            offsets[index++] = deadInterval[0];
            offsets[index++] = deadInterval[1];
            if (deadInterval[1] != Integer.MAX_VALUE) continue;
            break;
        }
        return FilePreprocessorConditionState.build(this.name, offsets);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.name != null) {
            sb.append(this.name);
        }
        sb.append("[");
        int i = 0;
        for (int[] deadInterval : this.blocks) {
            if (i++ > 0) {
                sb.append("][");
            }
            if (deadInterval[1] == Integer.MAX_VALUE) {
                sb.append(Integer.MAX_VALUE - deadInterval[0]);
                sb.append("#error");
                continue;
            }
            if (deadInterval[1] == 0x7FFFFFFE) {
                sb.append(deadInterval[0]);
                sb.append("#pragma once");
                continue;
            }
            sb.append(deadInterval[0]);
            sb.append("-");
            sb.append(deadInterval[1]);
        }
        sb.append("]");
        return sb.toString();
    }
}

