/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.netbeans.modules.cnd.modelimpl.trace.TraceUtils;

public final class MapHierarchy<K, V> {
    private final LinkedList<Map<K, V>> maps = new LinkedList();

    public MapHierarchy() {
    }

    public MapHierarchy(Map<K, V> map) {
        this.push(map);
    }

    public MapHierarchy(MapHierarchy<K, V> mapHierarchy) {
        for (Map map : mapHierarchy.maps) {
            this.push(map);
        }
    }

    public void push(Map<K, V> map) {
        this.maps.addLast(map);
    }

    public Map<K, V> pop() {
        return this.maps.removeLast();
    }

    public Map<K, V> peek() {
        return this.maps.peekLast();
    }

    public List<Map<K, V>> getMaps() {
        return this.getMaps(new AcceptingFilter());
    }

    public List<Map<K, V>> getMaps(Filter<Map<K, V>> filter) {
        ArrayList<Map<K, V>> result = new ArrayList<Map<K, V>>();
        for (Map map : this.maps) {
            if (!filter.accept(map)) continue;
            result.add(map);
        }
        return result;
    }

    public Map<K, V> getPlainMap() {
        HashMap result = new HashMap();
        for (Map map : this.maps) {
            result.putAll(map);
        }
        return result;
    }

    public boolean containsKey(K key) {
        ListIterator<Map<K, V>> stackIter = this.maps.listIterator(this.maps.size());
        while (stackIter.hasPrevious()) {
            Map<K, V> map = stackIter.previous();
            if (!map.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    public V get(K key) {
        ListIterator<Map<K, V>> stackIter = this.maps.listIterator(this.maps.size());
        while (stackIter.hasPrevious()) {
            Map<K, V> map = stackIter.previous();
            if (!map.containsKey(key)) continue;
            return map.get(key);
        }
        return null;
    }

    public int size() {
        int result = 0;
        for (Map map : this.maps) {
            result += map.size();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterable<Map.Entry<K, V>> entries() {
        return new Iterable<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new EntrySetIterator(MapHierarchy.this.maps);
            }
        };
    }

    public Iterable<K> keys() {
        return new Iterable<K>(){

            @Override
            public Iterator<K> iterator() {
                return new KeySetIterator(MapHierarchy.this.maps);
            }
        };
    }

    public Iterable<V> values() {
        return new Iterable<V>(){

            @Override
            public Iterator<V> iterator() {
                return new ValuesIterator(MapHierarchy.this.maps);
            }
        };
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        this.traceMaps(out, 0);
        return out.toString();
    }

    private void traceMaps(StringBuilder out, int from) {
        if (from == this.maps.size()) {
            return;
        }
        TraceUtils.repeat(out, from * 2, ' ');
        out.append("MAPPING:\n");
        this.traceMaps(out, from + 1);
        out.append(TraceUtils.traceMap(this.maps.get(from), from * 2));
        TraceUtils.repeat(out, from * 2, ' ');
        out.append("END OF MAPPING\n");
    }

    public static class NonEmptyFilter<K, V>
    implements Filter<Map<K, V>> {
        @Override
        public boolean accept(Map t) {
            return t != null && !t.isEmpty();
        }
    }

    public static class AcceptingFilter<K, V>
    implements Filter<Map<K, V>> {
        @Override
        public boolean accept(Map<K, V> t) {
            return true;
        }
    }

    public static interface Filter<T> {
        public boolean accept(T var1);
    }

    private static class ValuesIterator<K, V>
    extends BaseMapIterator<K, V, V> {
        public ValuesIterator(LinkedList<Map<K, V>> maps) {
            super(maps);
        }

        @Override
        protected Iterator<V> getMapIterator(Map<K, V> map) {
            return map.values().iterator();
        }
    }

    private static class KeySetIterator<K, V>
    extends BaseMapIterator<K, V, K> {
        public KeySetIterator(LinkedList<Map<K, V>> maps) {
            super(maps);
        }

        @Override
        protected Iterator<K> getMapIterator(Map<K, V> map) {
            return map.keySet().iterator();
        }
    }

    private static class EntrySetIterator<K, V>
    extends BaseMapIterator<K, V, Map.Entry<K, V>> {
        public EntrySetIterator(LinkedList<Map<K, V>> maps) {
            super(maps);
        }

        @Override
        protected Iterator<Map.Entry<K, V>> getMapIterator(Map<K, V> map) {
            return map.entrySet().iterator();
        }
    }

    private static abstract class BaseMapIterator<K, V, I>
    implements Iterator<I> {
        private final LinkedList<Map<K, V>> maps;
        private final ListIterator<Map<K, V>> stackIter;
        private Iterator<I> mapIter;
        private I nextElem;

        public BaseMapIterator(LinkedList<Map<K, V>> maps) {
            this.maps = maps;
            this.stackIter = maps.listIterator(maps.size());
            this.mapIter = this.stackIter.hasPrevious() ? this.getMapIterator(this.stackIter.previous()) : null;
            this.nextElem = this.computeNext();
        }

        protected abstract Iterator<I> getMapIterator(Map<K, V> var1);

        @Override
        public boolean hasNext() {
            return this.nextElem != null;
        }

        @Override
        public I next() {
            I result = this.nextElem;
            this.nextElem = this.computeNext();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Not supported.");
        }

        private I computeNext() {
            while (this.mapIter != null) {
                if (this.mapIter.hasNext()) {
                    return this.mapIter.next();
                }
                if (this.stackIter.hasPrevious()) {
                    this.mapIter = this.getMapIterator(this.stackIter.previous());
                    continue;
                }
                this.mapIter = null;
            }
            return null;
        }
    }
}

