/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.FeatureDescriptor;
import java.io.CharConversionException;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.text.StyledDocument;
import org.netbeans.api.actions.Openable;
import org.netbeans.api.search.SearchPattern;
import org.netbeans.modules.cnd.search.IconsCache;
import org.netbeans.modules.cnd.search.MatchingFileData;
import org.netbeans.modules.cnd.search.SearchParams;
import org.netbeans.modules.cnd.search.SearchResult;
import org.netbeans.modules.cnd.search.ui.SearchResultPropertySet;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.ChildFactory;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public final class SearchResultNode
extends AbstractNode {
    private static final String DOB_REF_PROP = "dataObjRef";
    private final SearchResult result;
    private Node.PropertySet[] propertySets;

    public SearchResultNode(SearchResult result) {
        super(result.data.hasEntries() ? Children.create((ChildFactory)new SearchChildFactory(result), (boolean)true) : Children.LEAF);
        this.result = result;
    }

    public String getName() {
        return this.result.data.getFileName();
    }

    public Image getIcon(int type) {
        WeakReference dobRef;
        DataObject dob;
        Object dobRefProp = this.getValue(DOB_REF_PROP);
        if (dobRefProp instanceof WeakReference && (dob = (DataObject)(dobRef = (WeakReference)dobRefProp).get()) != null) {
            return dob.getNodeDelegate().getIcon(type);
        }
        return IconsCache.getIcon(this.result.data.getFileName(), type);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Node.PropertySet[] getPropertySets() {
        if (this.propertySets == null) {
            this.propertySets = new Node.PropertySet[]{new SearchResultPropertySet(this.result)};
        }
        return this.propertySets;
    }

    public Action getPreferredAction() {
        return new OpenResultAction(this.result, 0, (FeatureDescriptor)((Object)this));
    }

    public void setValue(String attributeName, Object value) {
        if (DOB_REF_PROP.equals(attributeName)) {
            Object current = this.getValue(attributeName);
            if (!value.equals(current)) {
                super.setValue(attributeName, value);
                this.fireIconChange();
            }
        } else {
            super.setValue(attributeName, value);
        }
    }

    private static class EntryNode
    extends AbstractNode {
        private final SearchResult result;
        private final MatchingFileData.Entry entry;
        private String htmlName;

        public EntryNode(SearchResult result, MatchingFileData.Entry entry) {
            super(Children.LEAF, Lookups.fixed((Object[])new Object[]{result, entry}));
            this.entry = entry;
            this.result = result;
        }

        public String getName() {
            return this.entry.getContext() + "      " + NbBundle.getMessage(SearchResultNode.class, (String)"EntryNode.line.text", (Object)this.entry.getLineNumber());
        }

        public String getHtmlDisplayName() {
            if (this.htmlName == null) {
                this.htmlName = this.composeHtmlName();
            }
            return this.htmlName;
        }

        public Action getPreferredAction() {
            return new OpenResultAction(this.result, this.entry.getLineNumber(), (FeatureDescriptor)((Object)this));
        }

        public void setValue(String attributeName, Object value) {
            if (SearchResultNode.DOB_REF_PROP.equals(attributeName)) {
                this.getParentNode().setValue(attributeName, value);
            } else {
                super.setValue(attributeName, value);
            }
        }

        private String composeHtmlName() {
            Pattern p;
            SearchParams params = this.result.data.getSearchParams();
            String context = this.entry.getContext();
            SearchPattern sp = params.getSearchPattern();
            try {
                p = sp.isMatchCase() ? Pattern.compile(sp.getSearchExpression()) : Pattern.compile(sp.getSearchExpression(), 2);
            }
            catch (Exception ex) {
                return null;
            }
            int pos = 0;
            Matcher m = p.matcher(context);
            try {
                StringBuilder text = new StringBuilder();
                while (m.find(pos)) {
                    text.append(XMLUtil.toElementContent((String)context.substring(pos, m.start())));
                    text.append("<b>");
                    text.append(XMLUtil.toElementContent((String)context.substring(m.start(), m.end())));
                    text.append("</b>");
                    if (pos == m.end()) break;
                    pos = m.end();
                }
                text.append(XMLUtil.toElementContent((String)context.substring(pos)));
                text.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                text.append("<font color='#808080'>");
                text.append(NbBundle.getMessage(SearchResultNode.class, (String)"EntryNode.line.text", (Object)this.entry.getLineNumber()));
                return text.toString();
            }
            catch (CharConversionException e) {
                return null;
            }
        }
    }

    private static class OpenResultAction
    extends AbstractAction {
        private final SearchResult result;
        private final int line;
        private final FeatureDescriptor descriptor;

        public OpenResultAction(SearchResult result, int line, FeatureDescriptor descriptor) {
            this.result = result;
            this.line = line;
            this.descriptor = descriptor;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            FileObject f = this.result.getFileObject();
            if (f == null) {
                return;
            }
            try {
                DataObject dataObj = DataObject.find((FileObject)f);
                if (this.line > 0) {
                    StyledDocument doc;
                    EditorCookie ec = (EditorCookie)dataObj.getLookup().lookup(EditorCookie.class);
                    LineCookie lc = (LineCookie)dataObj.getLookup().lookup(LineCookie.class);
                    if (ec != null && lc != null && (doc = ec.openDocument()) != null) {
                        Line l = null;
                        try {
                            l = lc.getLineSet().getCurrent(this.line - 1);
                        }
                        catch (IndexOutOfBoundsException ex) {
                            ec.open();
                        }
                        if (l != null) {
                            l.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                    }
                } else {
                    Openable open = (Openable)DataObject.find((FileObject)f).getLookup().lookup(Openable.class);
                    if (open != null) {
                        open.open();
                    }
                }
                if (this.descriptor != null) {
                    this.descriptor.setValue(SearchResultNode.DOB_REF_PROP, new WeakReference<DataObject>(dataObj));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private static class SearchChildFactory
    extends ChildFactory<SearchResult> {
        private final SearchResult result;

        public SearchChildFactory(SearchResult result) {
            this.result = result;
        }

        protected boolean createKeys(List<SearchResult> toPopulate) {
            return toPopulate.add(this.result);
        }

        protected Node[] createNodesForKey(SearchResult res) {
            List<MatchingFileData.Entry> entries = res.data.getEntries();
            Node[] nodes = new Node[entries.size()];
            int i = 0;
            for (MatchingFileData.Entry entry : entries) {
                nodes[i++] = new EntryNode(this.result, entry);
            }
            return nodes;
        }
    }
}

