/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.client.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.netbeans.modules.mobility.end2end.classdata.AbstractService;
import org.netbeans.modules.mobility.end2end.classdata.ClassData;
import org.netbeans.modules.mobility.end2end.classdata.ClassService;
import org.netbeans.modules.mobility.end2end.classdata.OperationData;
import org.netbeans.modules.mobility.end2end.classdata.PortData;
import org.netbeans.modules.mobility.end2end.classdata.TypeData;
import org.netbeans.modules.mobility.end2end.classdata.WSDLService;
import org.netbeans.modules.mobility.end2end.client.config.ClassDescriptor;
import org.netbeans.modules.mobility.end2end.client.config.ClientConfiguration;
import org.netbeans.modules.mobility.end2end.client.config.Configuration;
import org.netbeans.modules.mobility.end2end.client.config.InvalidConfigFileException;
import org.netbeans.modules.mobility.end2end.client.config.ServerConfiguration;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.openide.loaders.DataObject;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ConfigurationReader {
    private static final String TYPE = "type";
    private static final String NAME = "name";

    private ConfigurationReader() {
    }

    public static synchronized Configuration read(DataObject doj) throws Exception {
        NodeList services;
        Configuration configuration = new Configuration();
        Document doc = XMLUtil.parse((InputSource)DataObjectAdapters.inputSource((DataObject)doj), (boolean)false, (boolean)false, null, null);
        Element root = doc.getDocumentElement();
        String serviceType = root.getAttribute("serviceType");
        if ("class".equals(serviceType)) {
            configuration.setServiceType("class");
        } else if ("wsdlClass".equals(serviceType)) {
            configuration.setServiceType("wsdlClass");
        } else if ("jsr-172".equals(serviceType)) {
            configuration.setServiceType("jsr-172");
        } else {
            throw new InvalidConfigFileException("Invalid service type:" + serviceType);
        }
        String configFileVersion = root.getAttribute("version");
        if (!"1.0".equals(configFileVersion)) {
            throw new InvalidConfigFileException("Invalid config file version: " + configFileVersion);
        }
        NodeList clientConfig = root.getElementsByTagName("client");
        if (clientConfig.getLength() > 1) {
            throw new InvalidConfigFileException("Config file has more than one client section");
        }
        if (clientConfig.getLength() == 0) {
            throw new InvalidConfigFileException("Config file has no client section");
        }
        configuration.setClientConfiguration(ConfigurationReader.parseClient((Element)clientConfig.item(0)));
        if (!"jsr-172".equals(configuration.getServiceType())) {
            NodeList serverConfig = root.getElementsByTagName("server");
            if (serverConfig.getLength() > 1) {
                throw new InvalidConfigFileException("Config file has more than one server section");
            }
            if (serverConfig.getLength() == 0) {
                throw new InvalidConfigFileException("Config file has no server section");
            }
            configuration.setServerConfiguration(ConfigurationReader.parseServer((Element)serverConfig.item(0)));
        }
        if ((services = root.getElementsByTagName("services")).getLength() > 1) {
            throw new InvalidConfigFileException("Config file has more than one services section");
        }
        if (services.getLength() == 0) {
            throw new InvalidConfigFileException("Config file has no services section");
        }
        NodeList service = ((Element)services.item(0)).getElementsByTagName("service");
        if (service.getLength() > 1) {
            throw new InvalidConfigFileException("Config file has more than one services");
        }
        if (services.getLength() == 0) {
            throw new InvalidConfigFileException("Config file has no registered services");
        }
        configuration.setServices(ConfigurationReader.parseServices((Element)service.item(0), serviceType));
        return configuration;
    }

    private static ClientConfiguration parseClient(Element element) throws Exception {
        ClientConfiguration cc = new ClientConfiguration();
        String projectName = ConfigurationReader.getElementValue(element, "project");
        if ("".equals(projectName)) {
            throw new InvalidConfigFileException("Client project name is empty string");
        }
        cc.setProjectName(projectName);
        NodeList classes = element.getElementsByTagName("class");
        if (classes.getLength() > 1) {
            throw new InvalidConfigFileException("Client has more than one class tag");
        }
        if (classes.getLength() == 0) {
            throw new InvalidConfigFileException("Client has no class tag");
        }
        Element clazz = (Element)classes.item(0);
        String type = clazz.getAttribute(TYPE);
        if ("".equals(type)) {
            throw new InvalidConfigFileException("Client class type is empty string");
        }
        String location = clazz.getAttribute("location");
        ClassDescriptor cd = new ClassDescriptor(type, location);
        cc.setClassDescriptor(cd);
        Properties props = new Properties();
        NodeList properties = element.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element property = (Element)properties.item(i);
            String key = property.getAttribute(NAME);
            if ("".equals(key)) {
                throw new IllegalAccessException("Key name is empty string");
            }
            String value = property.getAttribute("value");
            props.put(key, value);
        }
        cc.setProperties(props);
        return cc;
    }

    private static ServerConfiguration parseServer(Element element) throws Exception {
        ServerConfiguration sc = new ServerConfiguration();
        Element project = (Element)element.getElementsByTagName("project").item(0);
        String projectName = ConfigurationReader.getElementValue(element, "project");
        if ("".equals(projectName)) {
            throw new InvalidConfigFileException("Server project name is empty string");
        }
        sc.setProjectName(projectName);
        sc.setProjectPath(project.getAttribute("path"));
        NodeList classes = element.getElementsByTagName("class");
        if (classes.getLength() > 1) {
            throw new InvalidConfigFileException("Server has more than one class tag");
        }
        if (classes.getLength() == 0) {
            throw new InvalidConfigFileException("Server has no class tag");
        }
        Element clazz = (Element)classes.item(0);
        String type = clazz.getAttribute(TYPE);
        if ("".equals(type)) {
            throw new InvalidConfigFileException("Server class type is empty string");
        }
        String location = clazz.getAttribute("location");
        String mapping = clazz.getAttribute("mapping");
        ClassDescriptor cd = new ClassDescriptor(type, location);
        cd.setMapping(mapping);
        sc.setClassDescriptor(cd);
        Properties props = new Properties();
        NodeList properties = element.getElementsByTagName("property");
        for (int i = 0; i < properties.getLength(); ++i) {
            Element property = (Element)properties.item(i);
            String key = property.getAttribute(NAME);
            if ("".equals(key)) {
                throw new IllegalAccessException("Key name is empty string");
            }
            String value = property.getAttribute("value");
            props.put(key, value);
        }
        sc.setProperties(props);
        return sc;
    }

    private static List<AbstractService> parseServices(Element element, String serviceType) {
        ArrayList<AbstractService> services = new ArrayList<AbstractService>();
        if ("class".equals(serviceType)) {
            ClassService classService = new ClassService();
            ArrayList<ClassData> classDataList = new ArrayList<ClassData>();
            NodeList classes = element.getElementsByTagName("class");
            for (int i = 0; i < classes.getLength(); ++i) {
                ClassData classData = ConfigurationReader.parseClassService((Element)classes.item(i));
                if (classData == null) continue;
                classDataList.add(classData);
            }
            classService.setData(classDataList);
            services.add(classService);
        } else if ("wsdlClass".equals(serviceType)) {
            WSDLService wsdlService = new WSDLService();
            String wsdlURL = element.getAttribute("url");
            String wsdlFile = element.getAttribute("file");
            String name = element.getAttribute(NAME);
            String type = element.getAttribute(TYPE);
            wsdlService.setName(name);
            wsdlService.setFile(wsdlFile);
            wsdlService.setUrl(wsdlURL);
            wsdlService.setType(type);
            ArrayList<ClassData> portDataList = new ArrayList<ClassData>();
            NodeList classes = element.getElementsByTagName("port");
            for (int i = 0; i < classes.getLength(); ++i) {
                PortData pd = ConfigurationReader.parseWsdlService((Element)classes.item(i));
                if (pd == null) continue;
                portDataList.add(pd);
            }
            wsdlService.setData(portDataList);
            services.add(wsdlService);
        } else if ("jsr-172".equals(serviceType)) {
            WSDLService wsdlService = new WSDLService();
            String wsdlURL = element.getAttribute("url");
            String wsdlFile = element.getAttribute("file");
            wsdlService.setFile(wsdlFile);
            wsdlService.setUrl(wsdlURL);
            services.add(wsdlService);
        }
        return services;
    }

    private static ClassData parseClassService(Element element) {
        String className = element.getAttribute(TYPE);
        ClassData cd = new ClassData(className);
        NodeList methods = element.getElementsByTagName("method");
        ArrayList<OperationData> aMethods = new ArrayList<OperationData>();
        for (int i = 0; i < methods.getLength(); ++i) {
            Element method = (Element)methods.item(i);
            String methodName = method.getAttribute(NAME);
            String returnTypeName = ((Element)method.getElementsByTagName("return").item(0)).getAttribute(TYPE);
            NodeList params = method.getElementsByTagName("param");
            ArrayList<TypeData> aParams = new ArrayList<TypeData>();
            for (int j = 0; j < params.getLength(); ++j) {
                Element param = (Element)params.item(j);
                String paramTypeName = param.getAttribute(TYPE);
                String paramName = param.getAttribute(NAME);
                TypeData td = new TypeData(paramName, paramTypeName);
                aParams.add(td);
            }
            OperationData md = new OperationData(methodName);
            md.setReturnType(returnTypeName);
            md.setParameterTypes(aParams);
            aMethods.add(md);
        }
        cd.setOperations(aMethods);
        return cd;
    }

    private static PortData parseWsdlService(Element element) {
        String portType = element.getAttribute(TYPE);
        String portName = element.getAttribute(NAME);
        PortData portData = new PortData(portType);
        portData.setName(portName);
        NodeList operations = element.getElementsByTagName("operation");
        ArrayList<OperationData> operationsList = new ArrayList<OperationData>();
        for (int i = 0; i < operations.getLength(); ++i) {
            Element operation = (Element)operations.item(i);
            String name = operation.getAttribute(NAME);
            String methodName = operation.getAttribute("method");
            String returnTypeName = ((Element)operation.getElementsByTagName("return").item(0)).getAttribute(TYPE);
            NodeList params = operation.getElementsByTagName("param");
            ArrayList<TypeData> paramList = new ArrayList<TypeData>();
            for (int j = 0; j < params.getLength(); ++j) {
                Element param = (Element)params.item(j);
                String paramTypeName = param.getAttribute(TYPE);
                String paramName = param.getAttribute(NAME);
                TypeData td = new TypeData(paramName, paramTypeName);
                paramList.add(td);
            }
            OperationData operationData = new OperationData(name);
            operationData.setMethodName(methodName);
            operationData.setReturnType(returnTypeName);
            operationData.setParameterTypes(paramList);
            operationsList.add(operationData);
        }
        portData.setOperations(operationsList);
        return portData;
    }

    private static String getElementValue(Element element, String elementName) {
        Element e = (Element)element.getElementsByTagName(elementName).item(0);
        return e.getChildNodes().item(0).getNodeValue();
    }
}

