/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.api.java;

import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.lib.profiler.classfile.ClassFileParser;
import org.netbeans.lib.profiler.classfile.ClassInfo;
import org.netbeans.modules.profiler.api.java.SourceClassInfo;
import org.netbeans.modules.profiler.api.java.SourceMethodInfo;
import org.netbeans.modules.profiler.api.java.SourcePackageInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class ExternalPackages {
    private static final Comparator<FileObject> pathComparator = new Comparator<FileObject>(){

        @Override
        public int compare(FileObject o1, FileObject o2) {
            return o1.getPath().compareTo(o2.getPath());
        }
    };

    public static List<SourcePackageInfo> forPath(FileObject fo, boolean rec) {
        FileObject root = null;
        if (fo.getExt().equalsIgnoreCase("jar")) {
            if (FileUtil.isArchiveFile((FileObject)fo)) {
                root = FileUtil.getArchiveRoot((FileObject)fo);
            }
        } else if (fo.isFolder()) {
            root = fo;
        }
        if (root != null) {
            ArrayDeque<FileObject> stack = new ArrayDeque<FileObject>();
            TreeSet<FileObject> packages = new TreeSet<FileObject>(pathComparator);
            HashSet<String> pkgsContent = new HashSet<String>();
            stack.offer(root);
            while (!stack.isEmpty()) {
                FileObject f = (FileObject)stack.poll();
                if (f == null) continue;
                if (f.isData() && f.getExt().equalsIgnoreCase("class")) {
                    String path = f.getParent().getPath();
                    int i = path.lastIndexOf(47);
                    while (i > -1) {
                        pkgsContent.add(path);
                        path = path.substring(0, i);
                        i = path.lastIndexOf(47);
                    }
                    pkgsContent.add(path);
                    continue;
                }
                stack.addAll(Arrays.asList(f.getChildren()));
            }
            Enumeration ePkgs = root.getFolders(false);
            while (ePkgs.hasMoreElements()) {
                FileObject pkg = (FileObject)ePkgs.nextElement();
                if (!pkgsContent.contains(pkg.getPath())) continue;
                packages.add(pkg);
            }
            ArrayList<SourcePackageInfo> pkgis = new ArrayList<SourcePackageInfo>(packages.size());
            for (FileObject fileObject : packages) {
                pkgis.add(new FilePackageInfo(root, fileObject, pkgsContent));
            }
            if (rec) {
                ArrayDeque<SourcePackageInfo> _packages = new ArrayDeque<SourcePackageInfo>(pkgis);
                pkgis.clear();
                while (!_packages.isEmpty()) {
                    FilePackageInfo filePackageInfo = (FilePackageInfo)_packages.poll();
                    if (filePackageInfo.hasClasses()) {
                        pkgis.add(filePackageInfo);
                    }
                    _packages.addAll(filePackageInfo.getSubpackages());
                }
            }
            return pkgis;
        }
        return Collections.EMPTY_LIST;
    }

    private static class FileMethodInfo
    extends SourceMethodInfo {
        private static int getModifiers(ClassInfo ci, int mIndex) {
            int modifiers = 0;
            if (ci.isMethodAbstract(mIndex)) {
                modifiers += 1024;
            }
            if (ci.isMethodPrivate(mIndex)) {
                modifiers += 2;
            }
            if (ci.isMethodProtected(mIndex)) {
                modifiers += 4;
            }
            if (ci.isMethodPublic(mIndex)) {
                ++modifiers;
            }
            if (ci.isMethodFinal(mIndex)) {
                modifiers += 16;
            }
            if (ci.isMethodStatic(mIndex)) {
                modifiers += 8;
            }
            if (ci.isMethodNative(mIndex)) {
                modifiers += 256;
            }
            return modifiers;
        }

        public FileMethodInfo(ClassInfo ci, int mIndex) {
            super(ci.getName().replace('/', '.'), ci.getMethodName(mIndex), ci.getMethodSignature(mIndex), ci.getMethodName(mIndex), false, FileMethodInfo.getModifiers(ci, mIndex));
        }
    }

    private static class PlainClassInfo
    extends SourceClassInfo {
        PlainClassInfo(String className) {
            super(className, className, className);
        }

        @Override
        public FileObject getFile() {
            return null;
        }

        @Override
        public Set<SourceMethodInfo> getMethods(boolean all) {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<SourceClassInfo> getSubclasses() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<SourceClassInfo> getInnerClases() {
            return Collections.EMPTY_SET;
        }

        @Override
        public Set<SourceMethodInfo> getConstructors() {
            return Collections.EMPTY_SET;
        }

        @Override
        public SourceClassInfo getSuperType() {
            return new PlainClassInfo("");
        }

        @Override
        public Set<SourceClassInfo> getInterfaces() {
            return Collections.EMPTY_SET;
        }
    }

    private static class FileClassInfo
    extends SourceClassInfo {
        private FileObject root;
        private FileObject clazz;
        private ClassInfo ci;

        public FileClassInfo(ClassInfo ci, FileObject root, FileObject clazz) {
            super(clazz.getName(), FileUtil.getRelativePath((FileObject)root, (FileObject)clazz).replace('/', '.').replace(".class", ""), FileUtil.getRelativePath((FileObject)root, (FileObject)clazz).replace(".class", ""));
            this.ci = ci;
            this.clazz = clazz;
            this.root = root;
        }

        @Override
        public Set<SourceMethodInfo> getConstructors() {
            String[] names = this.ci.getMethodNames();
            HashSet<SourceMethodInfo> cts = new HashSet<SourceMethodInfo>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (!names[i].equals("<init>")) continue;
                    cts.add(new FileMethodInfo(this.ci, i));
                }
            }
            return cts;
        }

        @Override
        public FileObject getFile() {
            return this.clazz;
        }

        @Override
        public Set<SourceClassInfo> getInnerClases() {
            HashSet<SourceClassInfo> rslt = new HashSet<SourceClassInfo>();
            ClassFileParser cfp = new ClassFileParser();
            Enumeration siblings = this.clazz.getParent().getData(false);
            while (siblings.hasMoreElements()) {
                final FileObject sibling = (FileObject)siblings.nextElement();
                if (!sibling.getName().contains("$") || !sibling.getName().startsWith(this.clazz.getName()) || sibling.getName().equals(this.clazz.getName())) continue;
                ClassInfo ci = new ClassInfo(sibling.getName(), 0){

                    protected byte[] getClassFileBytes() throws IOException, ClassNotFoundException {
                        return sibling.asBytes();
                    }
                };
                try {
                    cfp.parseClassFile(sibling.asBytes(), ci);
                    rslt.add(new FileClassInfo(ci, this.root, sibling));
                }
                catch (IOException iOException) {
                }
                catch (ClassFileParser.ClassFileReadException classFileReadException) {}
            }
            return rslt;
        }

        @Override
        public Set<SourceClassInfo> getInterfaces() {
            HashSet<SourceClassInfo> ifcs = new HashSet<SourceClassInfo>();
            String[] iNames = this.ci.getInterfaceNames();
            if (iNames != null) {
                for (String name : iNames) {
                    ifcs.add(new PlainClassInfo(name));
                }
            }
            return ifcs;
        }

        @Override
        public Set<SourceMethodInfo> getMethods(boolean all) {
            String[] names = this.ci.getMethodNames();
            HashSet<SourceMethodInfo> cts = new HashSet<SourceMethodInfo>();
            if (names != null) {
                for (int i = 0; i < names.length; ++i) {
                    if (names[i].equals("<init>")) continue;
                    cts.add(new FileMethodInfo(this.ci, i));
                }
            }
            return cts;
        }

        @Override
        public Set<SourceClassInfo> getSubclasses() {
            return Collections.EMPTY_SET;
        }

        @Override
        public SourceClassInfo getSuperType() {
            String superC = this.ci.getSuperclassName();
            if (superC == null) {
                superC = Object.class.getName();
            }
            return new PlainClassInfo(superC);
        }
    }

    private static class FilePackageInfo
    extends SourcePackageInfo {
        private FileObject root;
        private FileObject pkg;
        private Set<String> pkgsContent;

        public FilePackageInfo(FileObject root, FileObject pkg, Set<String> pkgsContent) {
            super(FileUtil.getRelativePath((FileObject)root, (FileObject)pkg), FileUtil.getRelativePath((FileObject)root, (FileObject)pkg).replace('/', '.'), SourcePackageInfo.Scope.SOURCE);
            this.pkg = pkg;
            this.root = root;
            this.pkgsContent = pkgsContent;
        }

        @Override
        public Collection<SourceClassInfo> getClasses() {
            TreeSet<FileObject> clzs = new TreeSet<FileObject>(pathComparator);
            Enumeration e = this.pkg.getData(false);
            while (e.hasMoreElements()) {
                FileObject clz = (FileObject)e.nextElement();
                if (!clz.getExt().equalsIgnoreCase("class")) continue;
                clzs.add(clz);
            }
            ClassFileParser cfp = new ClassFileParser();
            ArrayList<SourceClassInfo> rslt = new ArrayList<SourceClassInfo>();
            for (final FileObject p : clzs) {
                if (p.getName().contains("$")) continue;
                ClassInfo ci = new ClassInfo(p.getName(), 0){

                    protected byte[] getClassFileBytes() throws IOException, ClassNotFoundException {
                        return p.asBytes();
                    }
                };
                try {
                    cfp.parseClassFile(p.asBytes(), ci);
                    rslt.add(new FileClassInfo(ci, this.root, p));
                }
                catch (IOException iOException) {
                }
                catch (ClassFileParser.ClassFileReadException classFileReadException) {}
            }
            return rslt;
        }

        boolean hasClasses() {
            Enumeration e = this.pkg.getData(false);
            while (e.hasMoreElements()) {
                if (!((FileObject)e.nextElement()).getExt().equalsIgnoreCase("class")) continue;
                return true;
            }
            return false;
        }

        @Override
        public Collection<SourcePackageInfo> getSubpackages() {
            TreeSet pkgs = new TreeSet(pathComparator);
            Enumeration e = this.pkg.getFolders(false);
            while (e.hasMoreElements()) {
                pkgs.add(e.nextElement());
            }
            ArrayList<SourcePackageInfo> rslt = new ArrayList<SourcePackageInfo>();
            for (FileObject p : pkgs) {
                if (!this.pkgsContent.contains(p.getPath())) continue;
                rslt.add(new FilePackageInfo(this.root, p, this.pkgsContent));
            }
            return rslt;
        }
    }
}

