/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.Vector;
import org.netbeans.modules.cnd.debugger.common2.debugger.ModelChangeDelegator;
import org.netbeans.modules.cnd.debugger.common2.debugger.NativeDebugger;
import org.netbeans.modules.cnd.debugger.common2.debugger.Variable;
import org.netbeans.modules.cnd.debugger.gdb2.GdbVariable;

class VariableBag {
    private final Vector<Variable> variables = new Vector();
    private final Vector<Variable> watchvariables = new Vector();
    private final Vector<Variable> localvariables = new Vector();
    public static final int FROM_LOCALS = 1;
    public static final int FROM_WATCHES = 2;
    public static final int FROM_BOTH = 3;
    private ModelChangeDelegator updater;
    private NativeDebugger debugger;
    public int remove_count = 0;

    private boolean isBound() {
        return this.debugger != null;
    }

    public void bindDebugger(NativeDebugger debugger) {
        this.debugger = debugger;
    }

    public void setUpdater(ModelChangeDelegator updater) {
        this.updater = updater;
    }

    public ModelChangeDelegator variablesUpdater() {
        return this.updater;
    }

    public Variable[] getVars() {
        Variable[] vars = new Variable[this.variables.size()];
        return this.variables.toArray(vars);
    }

    public Variable[] getWatchVars() {
        Variable[] vars = new Variable[this.watchvariables.size()];
        return this.watchvariables.toArray(vars);
    }

    public Variable[] getLocalVars() {
        Variable[] vars = new Variable[this.localvariables.size()];
        return this.localvariables.toArray(vars);
    }

    public void add(GdbVariable newVar) {
        this.variables.add(newVar);
        if (newVar.isWatch()) {
            this.watchvariables.add(newVar);
        } else {
            this.localvariables.add(newVar);
        }
    }

    public GdbVariable byAddr(String exp, String addr, int from) {
        Variable[] iter = this.getVars();
        if (from == 1) {
            iter = this.getLocalVars();
        } else if (from == 2) {
            iter = this.getWatchVars();
        }
        for (Variable v : iter) {
            GdbVariable gv;
            if (!(v instanceof GdbVariable) || !exp.equals((gv = (GdbVariable)v).getVariableName()) || !addr.equals(gv.getAsText())) continue;
            return (GdbVariable)v;
        }
        return null;
    }

    public GdbVariable get(String exp, boolean with_MIname, int from) {
        Variable[] iter = this.getVars();
        if (from == 1) {
            iter = this.getLocalVars();
        } else if (from == 2) {
            iter = this.getWatchVars();
        }
        for (Variable v : iter) {
            if (!(v instanceof GdbVariable)) continue;
            GdbVariable gv = (GdbVariable)v;
            if (!(with_MIname ? exp.equals(gv.getMIName()) : exp.equals(gv.getVariableName()))) continue;
            return (GdbVariable)v;
        }
        return null;
    }

    public void remove(Variable oldVar) {
        Variable[] children = oldVar.getChildren();
        this.variables.remove(oldVar);
        ++this.remove_count;
        int size = children.length;
        if (size != 0) {
            for (int vx = 0; vx < size; ++vx) {
                if (children[vx] == null) continue;
                this.remove(children[vx]);
            }
        }
        if (((GdbVariable)oldVar).isWatch()) {
            this.watchvariables.remove(oldVar);
        } else {
            this.localvariables.remove(oldVar);
        }
    }

    public void removeWatch(Variable oldVar) {
        this.watchvariables.remove(oldVar);
    }

    public void removeLocal(Variable oldVar) {
        this.localvariables.remove(oldVar);
    }

    public void removeAll() {
        this.variables.clear();
    }

    public void removeAllWatches() {
        this.watchvariables.clear();
    }

    public void removeAllLocals() {
        this.localvariables.clear();
    }
}

