/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.validation.api.Problem;
import org.netbeans.validation.api.Severity;

public final class Problems {
    private final List<Problem> problems = new ArrayList<Problem>();
    private boolean hasFatal;

    public final void add(String problem) {
        this.add(problem, Severity.FATAL);
    }

    public final void add(String problem, Severity severity) {
        this.problems.add(new Problem(problem, severity));
        this.hasFatal |= severity == Severity.FATAL;
    }

    public final void add(Problem problem) {
        if (problem == null) {
            return;
        }
        this.problems.add(problem);
        this.hasFatal |= problem.severity() == Severity.FATAL;
    }

    public final void putAll(Problems problems) {
        if (problems == this) {
            throw new IllegalArgumentException("putAll to self");
        }
        this.problems.addAll(problems.problems);
        this.hasFatal |= problems.hasFatal();
    }

    public final boolean hasFatal() {
        return this.hasFatal;
    }

    public final Problem getLeadProblem() {
        Collections.sort(this.problems);
        return this.problems.isEmpty() ? null : this.problems.get(0);
    }

    public final List<? extends Problem> allProblems() {
        ArrayList<Problem> result = new ArrayList<Problem>(this.problems.size());
        result.addAll(this.problems);
        Collections.sort(result);
        return result;
    }

    public String toString() {
        return this.problems.toString();
    }
}

