/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.validation.api.builtin.stringvalidation;

import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.builtin.stringvalidation.EncodableInCharsetValidator;
import org.netbeans.validation.api.builtin.stringvalidation.IpAddressValidator;
import org.netbeans.validation.api.builtin.stringvalidation.MayNotContainSpacesValidator;
import org.netbeans.validation.api.builtin.stringvalidation.StringValidator;
import org.openide.util.NbBundle;

final class HostNameValidator
extends StringValidator {
    private final boolean allowPort;

    HostNameValidator(boolean allowPort) {
        this.allowPort = allowPort;
    }

    @Override
    public void validate(Problems problems, String compName, String model) {
        if (model.length() == 0) {
            problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"INVALID_HOST_NAME", (Object)compName, (Object)model));
            return;
        }
        if (model.startsWith(".") || model.endsWith(".")) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"HOST_STARTS_OR_ENDS_WITH_PERIOD", (Object)model));
            return;
        }
        String[] parts = model.split("\\.");
        if (parts.length > 4) {
            problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"TOO_MANY_LABELS", (Object)model));
            return;
        }
        if (!this.allowPort && model.contains(":")) {
            problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"MSG_PORT_NOT_ALLOWED", (Object)compName, (Object)model));
            return;
        }
        new MayNotContainSpacesValidator().validate(problems, compName, model);
        if (model.endsWith("-") || model.startsWith("-")) {
            problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"INVALID_HOST_NAME", (Object)compName, (Object)model));
            return;
        }
        for (int i = 0; i < parts.length; ++i) {
            String label = parts[i];
            if (label.length() > 63) {
                problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"LABEL_TOO_LONG", (Object)label));
                return;
            }
            if (i == parts.length - 1 && label.indexOf(":") > 0) {
                String[] labelAndPort = label.split(":");
                if (labelAndPort.length > 2) {
                    problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)label));
                    return;
                }
                if (labelAndPort.length == 1) {
                    problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)"''"));
                    return;
                }
                if (label.endsWith(":")) {
                    problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"TOO_MANY_COLONS", (Object)compName, (Object)label));
                    return;
                }
                try {
                    int port = Integer.parseInt(labelAndPort[1]);
                    if (port < 0) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"NEGATIVE_PORT", (Object)port));
                        return;
                    }
                    if (port >= 65536) {
                        problems.add(NbBundle.getMessage(IpAddressValidator.class, (String)"PORT_TOO_HIGH", (Object)port));
                        return;
                    }
                }
                catch (NumberFormatException e) {
                    problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"INVALID_PORT", (Object)compName, (Object)labelAndPort[1]));
                    return;
                }
                if (this.checkHostPart(labelAndPort[0], problems, compName)) continue;
                return;
            }
            this.checkHostPart(label, problems, compName);
        }
    }

    private boolean checkHostPart(String label, Problems problems, String compName) {
        if (label.length() > 63) {
            problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"LABEL_TOO_LONG", (Object)label));
            return false;
        }
        if (label.length() == 0) {
            problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"LABEL_EMPTY", (Object)compName, (Object)label));
            return false;
        }
        try {
            Integer.parseInt(label);
            problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"NUMBER_PART_IN_HOSTNAME", (Object)label));
            return false;
        }
        catch (NumberFormatException e) {
            Problems tmp = new Problems();
            new EncodableInCharsetValidator().validate(tmp, compName, label);
            problems.putAll(tmp);
            if (!tmp.hasFatal()) {
                for (char c : label.toLowerCase().toCharArray()) {
                    if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '-') continue;
                    problems.add(NbBundle.getMessage(HostNameValidator.class, (String)"BAD_CHAR_IN_HOSTNAME", (Object)new String(new char[]{c})));
                    return false;
                }
            }
            return true;
        }
    }
}

