/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.api.phpmodule;

import java.beans.PropertyChangeEvent;
import java.util.List;
import java.util.prefs.Preferences;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public interface PhpModule
extends Lookup.Provider {
    public static final String PROPERTY_FRAMEWORKS = "PROPERTY_FRAMEWORKS";

    @NonNull
    public String getName();

    @NonNull
    public String getDisplayName();

    public boolean isBroken();

    @NonNull
    public FileObject getProjectDirectory();

    @CheckForNull
    public FileObject getSourceDirectory();

    @CheckForNull
    public FileObject getTestDirectory(@NullAllowed FileObject var1);

    public List<FileObject> getTestDirectories();

    public Lookup getLookup();

    @NonNull
    public Preferences getPreferences(Class<?> var1, boolean var2);

    public void notifyPropertyChanged(@NonNull PropertyChangeEvent var1);

    public static final class Factory {
        @CheckForNull
        public static PhpModule forFileObject(FileObject fo) {
            Parameters.notNull((CharSequence)"fo", (Object)fo);
            Project project = FileOwnerQuery.getOwner((FileObject)fo);
            if (project == null) {
                return null;
            }
            return Factory.lookupPhpModule(project);
        }

        @CheckForNull
        public static PhpModule inferPhpModule() {
            Lookup globalContext;
            PhpModule result;
            Node[] activatedNodes = WindowManager.getDefault().getRegistry().getActivatedNodes();
            if (activatedNodes != null) {
                for (Node n : activatedNodes) {
                    PhpModule result2 = Factory.lookupPhpModule(n.getLookup());
                    if (result2 == null) continue;
                    return result2;
                }
            }
            if ((result = Factory.lookupPhpModule(globalContext = Utilities.actionsGlobalContext())) != null) {
                return result;
            }
            FileObject fo = (FileObject)globalContext.lookup(FileObject.class);
            if (fo != null && (result = Factory.forFileObject(fo)) != null) {
                return result;
            }
            OpenProjects projects = OpenProjects.getDefault();
            Project mainProject = projects.getMainProject();
            if (mainProject != null && (result = Factory.lookupPhpModule(mainProject)) != null) {
                return result;
            }
            for (Project project : projects.getOpenProjects()) {
                result = Factory.lookupPhpModule(project);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        @CheckForNull
        public static PhpModule lookupPhpModule(Project project) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            return (PhpModule)project.getLookup().lookup(PhpModule.class);
        }

        @CheckForNull
        public static PhpModule lookupPhpModule(Lookup lookup) {
            Parameters.notNull((CharSequence)"lookup", (Object)lookup);
            PhpModule result = (PhpModule)lookup.lookup(PhpModule.class);
            if (result != null) {
                return result;
            }
            Project project = (Project)lookup.lookup(Project.class);
            if (project == null) {
                return null;
            }
            return Factory.lookupPhpModule(project);
        }
    }
}

