/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.completion;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.completion.Completion;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.xml.api.model.DescriptionSource;
import org.netbeans.modules.xml.api.model.GrammarResult;
import org.netbeans.modules.xml.text.completion.XMLCompletionResultItemPaintComponent;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.spi.editor.completion.CompletionDocumentation;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.swing.plaf.LFCustoms;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

class XMLResultItem
implements CompletionItem {
    private static final Logger LOG = Logger.getLogger(XMLResultItem.class.getName());
    private static final Color COLOR = new Color(64, 64, 255);
    public final String displayText;
    private final String replacementText;
    public Icon icon;
    public Color foreground = LFCustoms.getTextFgColor();
    public Color background = UIManager.getColor("Tree.background");
    public Color selectionForeground;
    public Color selectionBackground;
    private static JLabel rubberStamp = new JLabel();
    private boolean shift = false;
    private final int position;
    static int substituteOffset;

    public XMLResultItem(int position, String replacementText) {
        this(position, replacementText, null);
    }

    public XMLResultItem(int position, String replacementText, String displayText) {
        if (this.background == null) {
            this.background = Color.white;
        }
        this.selectionForeground = UIManager.getColor("List.selectionForeground");
        if (this.selectionForeground == null) {
            this.selectionForeground = Color.black;
        }
        this.selectionBackground = UIManager.getColor("List.selectionBackground");
        if (this.selectionBackground == null) {
            this.selectionBackground = new Color(204, 204, 255);
        }
        this.replacementText = replacementText;
        this.displayText = displayText != null ? displayText : replacementText;
        this.position = position;
    }

    public String getReplacementText(int modifiers) {
        return this.displayText;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    int getDeleteLength(String currentText, String replaceToText, int len) {
        return len;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean replaceText(JTextComponent component, String replaceToText, int offset, int len) {
        BaseDocument doc = (BaseDocument)component.getDocument();
        doc.atomicLock();
        int replacementLength = replaceToText.length();
        try {
            String currentText = doc.getText(offset, doc.getLength() - offset < replacementLength ? doc.getLength() - offset : replacementLength);
            if (("<" + currentText + ">").equals("</" + replaceToText)) {
                boolean bl = true;
                return bl;
            }
            if (!replaceToText.equals(currentText)) {
                String str = doc.getText(offset - 1, 1);
                if (str != null && str.equals("&")) {
                    currentText = doc.getText(offset, doc.getLength() - --offset < replacementLength ? doc.getLength() - offset : replacementLength);
                }
                if ((len = this.getFirstDiffPosition(currentText, replaceToText)) == replacementLength) {
                    component.setCaretPosition(offset + len);
                } else {
                    String selectedText = component.getSelectedText();
                    String replacingText = replaceToText;
                    if (selectedText != null) {
                        len = selectedText.length();
                    } else if (!this.isTextRemovingAllowable(component, doc, replaceToText, offset)) {
                        if (len > 0) {
                            replacingText = replaceToText.substring(len);
                            offset += len;
                        }
                        len = 0;
                    } else {
                        len = this.getDeleteLength(currentText, replaceToText, len);
                    }
                    if (len > 0) {
                        doc.remove(offset, len);
                    }
                    doc.insertString(offset, replacingText, null);
                }
            } else {
                int newCaretPos = component.getCaret().getDot() + replacementLength - len;
                component.setCaretPosition(newCaretPos < doc.getLength() ? newCaretPos : doc.getLength());
            }
        }
        catch (BadLocationException exc) {
            boolean bl = false;
            return bl;
        }
        finally {
            doc.atomicUnlock();
        }
        return true;
    }

    private boolean isTextRemovingAllowable(JTextComponent component, BaseDocument doc, String replaceToText, int offset) throws BadLocationException {
        String tokenItemImage;
        boolean isTextRemovingAllowable;
        XMLSyntaxSupport support = (XMLSyntaxSupport)Utilities.getSyntaxSupport((JTextComponent)component);
        TokenItem tokenItem = support.getTokenChain(offset, doc.getLength());
        boolean bl = isTextRemovingAllowable = tokenItem == null;
        if (!isTextRemovingAllowable && (tokenItemImage = tokenItem.getImage()) != null && tokenItemImage.length() > 0) {
            int offs = Math.max(0, offset - tokenItem.getOffset());
            String replaceInclPrefix = tokenItemImage.substring(0, offs) + replaceToText;
            int diffPos = this.getFirstDiffPosition(tokenItemImage, replaceInclPrefix);
            int n = diffPos = diffPos == 0 ? 1 : diffPos;
            if (diffPos > -1 && diffPos <= Math.min(tokenItemImage.length(), replaceInclPrefix.length())) {
                int id;
                String strImg = tokenItemImage.length() >= diffPos ? tokenItemImage.substring(0, diffPos) : tokenItemImage;
                String strText = replaceInclPrefix.length() >= diffPos ? replaceInclPrefix.substring(0, diffPos) : replaceInclPrefix;
                TokenID tokenID = tokenItem.getTokenID();
                int n2 = id = tokenID != null ? tokenID.getNumericID() : -1;
                isTextRemovingAllowable = id == 4 ? !strImg.startsWith(strText) : strImg.startsWith(strText);
            }
        }
        return isTextRemovingAllowable;
    }

    private int getFirstDiffPosition(String str1, String str2) {
        int lastCharIndex = Math.min(str1.length(), str2.length());
        for (int index = 0; index < lastCharIndex; ++index) {
            if (str1.charAt(index) == str2.charAt(index)) continue;
            return index;
        }
        return lastCharIndex;
    }

    public boolean substituteCommonText(JTextComponent c, int offset, int len, int subLen) {
        return this.replaceText(c, this.getReplacementText(0).substring(0, subLen), offset, len);
    }

    public final boolean substituteText(JTextComponent c, int offset, int len, boolean shift) {
        int modifier = shift ? 1 : 0;
        return this.substituteText(c, offset, len, modifier);
    }

    public boolean substituteText(JTextComponent c, int offset, int len, int modifiers) {
        return this.replaceText(c, this.getReplacementText(modifiers), offset, len);
    }

    public Component getPaintComponent(JList list, boolean isSelected, boolean cellHasFocus) {
        if (this.getIcon() != null) {
            rubberStamp.setIcon(this.getIcon());
        }
        rubberStamp.setText(this.displayText);
        if (isSelected) {
            rubberStamp.setBackground(this.selectionBackground);
            rubberStamp.setForeground(this.selectionForeground);
        } else {
            rubberStamp.setBackground(this.background);
            rubberStamp.setForeground(this.foreground);
        }
        return rubberStamp;
    }

    public final String getItemText() {
        return this.replacementText;
    }

    public String toString() {
        return this.getItemText();
    }

    Color getPaintColor() {
        return LFCustoms.shiftColor((Color)COLOR);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    protected CompletionTask doCreateDocumentationTask(final GrammarResult res) {
        return new CompletionTask(){

            public void query(CompletionResultSet resultSet) {
                CompletionDocumentation cd = this.create();
                if (cd != null) {
                    resultSet.setDocumentation(cd);
                }
                resultSet.finish();
            }

            public void refresh(CompletionResultSet resultSet) {
                this.query(resultSet);
            }

            public void cancel() {
            }

            private CompletionDocumentation create() {
                String doc = res.getDescription();
                if (!(res instanceof DescriptionSource)) {
                    if (doc == null) {
                        return null;
                    }
                    return new Docum(doc);
                }
                DescriptionSource ds = (DescriptionSource)res;
                if (doc == null && ds.getContentURL() == null) {
                    return null;
                }
                return new ExtDocum(ds, doc);
            }
        };
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public void defaultAction(JTextComponent component) {
        int substOffset = this.getSubstituteOffset();
        if (substOffset == -1) {
            substOffset = component.getCaretPosition();
        }
        if (!this.shift) {
            Completion.get().hideAll();
        }
        this.substituteText(component, substOffset, component.getCaretPosition() - substOffset, this.shift);
    }

    public int getSubstituteOffset() {
        return substituteOffset;
    }

    public CharSequence getInsertPrefix() {
        return this.getItemText();
    }

    public Component getPaintComponent(boolean isSelected) {
        XMLCompletionResultItemPaintComponent.StringPaintComponent paintComponent = new XMLCompletionResultItemPaintComponent.StringPaintComponent(this.getPaintColor());
        paintComponent.setIcon(this.icon);
        paintComponent.setSelected(isSelected);
        paintComponent.setString(this.getItemText());
        return paintComponent;
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        Component renderComponent = this.getPaintComponent(false);
        renderComponent.setFont(defaultFont);
        return renderComponent.getPreferredSize().width;
    }

    public int getSortPriority() {
        return this.position;
    }

    public CharSequence getSortText() {
        return this.getItemText();
    }

    public boolean instantSubstitution(JTextComponent component) {
        this.defaultAction(component);
        return true;
    }

    public void processKeyEvent(KeyEvent e) {
        this.shift = e.getKeyCode() == 10 && e.getID() == 401 && e.isShiftDown();
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        Component renderComponent = this.getPaintComponent(selected);
        renderComponent.setFont(defaultFont);
        renderComponent.setForeground(defaultColor);
        renderComponent.setBackground(backgroundColor);
        renderComponent.setBounds(0, 0, width, height);
        XMLCompletionResultItemPaintComponent xmlComp = (XMLCompletionResultItemPaintComponent)renderComponent;
        xmlComp.setIcon(this.icon);
        xmlComp.paintComponent(g);
    }

    static {
        rubberStamp.setOpaque(true);
        substituteOffset = -1;
    }

    private static class Docum
    implements CompletionDocumentation {
        private String doc;

        private Docum(String doc) {
            this.doc = doc;
        }

        public String getText() {
            return this.doc;
        }

        public URL getURL() {
            return null;
        }

        public CompletionDocumentation resolveLink(String link) {
            return null;
        }

        public Action getGotoSourceAction() {
            return null;
        }
    }

    private static class URLDocum
    implements CompletionDocumentation {
        URL content;
        boolean external;

        URLDocum(URL content, boolean external) {
            this.content = content;
            this.external = external;
        }

        URLDocum(boolean external) {
            this.external = external;
        }

        public Action getGotoSourceAction() {
            return null;
        }

        public String getText() {
            if (this.content == null) {
                return null;
            }
            FileObject f = URLMapper.findFileObject((URL)this.content);
            if (f != null) {
                try {
                    return new String(f.asBytes(), FileEncodingQuery.getEncoding((FileObject)f));
                }
                catch (IOException x) {
                    LOG.log(Level.INFO, "Could not load " + this.content, x);
                }
            }
            return null;
        }

        public URL getURL() {
            return this.external ? this.content : null;
        }

        public CompletionDocumentation resolveLink(String link) {
            if (this.content == null) {
                return null;
            }
            try {
                return new URLDocum(new URL(this.content, link), this.external);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }
    }

    private static class ExtDocum
    extends URLDocum
    implements CompletionDocumentation {
        private DescriptionSource src;
        private String doc;

        ExtDocum(DescriptionSource src, String doc) {
            super(src.getContentURL(), src.isExternal());
            this.src = src;
            this.doc = doc;
        }

        @Override
        public String getText() {
            if (this.doc == null) {
                this.doc = this.src.getDescription();
                if (this.doc == null) {
                    this.doc = super.getText();
                }
            }
            return this.doc;
        }

        @Override
        public CompletionDocumentation resolveLink(String link) {
            try {
                DescriptionSource target = this.src.resolveLink(link);
                if (target != null) {
                    return new ExtDocum(target, null);
                }
                URL base = this.src.getContentURL();
                if (base == null) {
                    return null;
                }
                URL targetURL = new URL(base, link);
                boolean external = true;
                FileObject f = URLMapper.findFileObject((URL)targetURL);
                if (f != null) {
                    external = URLMapper.findURL((FileObject)f, (int)1) != null;
                }
                return new URLDocum(targetURL, external);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
        }

        @Override
        public Action getGotoSourceAction() {
            return null;
        }
    }
}

