/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.util;

import java.awt.Component;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.util.Properties;
import org.netbeans.modules.db.util.PropertyEditorPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class PropertiesEditor
extends PropertyEditorSupport
implements ExPropertyEditor {
    private boolean canWrite = true;

    @Override
    public String getAsText() {
        Properties value = (Properties)this.getValue();
        if (value == null || value.size() == 0) {
            return NbBundle.getMessage(PropertiesEditor.class, (String)"NoPropertiesSet");
        }
        return value.toString();
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        throw new IllegalArgumentException("Can't be set by setAsText");
    }

    @Override
    public String getJavaInitializationString() {
        return null;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        PropertyEditorPanel pep = new PropertyEditorPanel((Properties)this.getValue(), this.canWrite);
        pep.addPropertyChangeListener("value", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                PropertiesEditor.this.setValue(((PropertyEditorPanel)pce.getSource()).getValue());
            }
        });
        return pep;
    }

    public void attachEnv(PropertyEnv env) {
        FeatureDescriptor d = env.getFeatureDescriptor();
        if (d instanceof Node.Property) {
            this.canWrite = ((Node.Property)d).canWrite();
        }
    }

    public boolean isEditable() {
        return this.canWrite;
    }
}

