/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.api.util;

import com.sun.istack.Nullable;
import com.sun.tools.xjc.api.util.ToolsJarNotFoundException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;

public final class APTClassLoader
extends URLClassLoader {
    private final String[] packagePrefixes;

    public APTClassLoader(@Nullable ClassLoader parent, String[] packagePrefixes) throws ToolsJarNotFoundException {
        super(APTClassLoader.getToolsJar(parent), parent);
        this.packagePrefixes = this.getURLs().length == 0 ? new String[0] : packagePrefixes;
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        for (String prefix : this.packagePrefixes) {
            if (!className.startsWith(prefix)) continue;
            return this.findClass(className);
        }
        return super.loadClass(className);
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        StringBuilder sb = new StringBuilder(name.length() + 6);
        sb.append(name.replace('.', '/')).append(".class");
        InputStream is = this.getResourceAsStream(sb.toString());
        if (is == null) {
            throw new ClassNotFoundException("Class not found" + sb);
        }
        try {
            String pkgname;
            Package pkg;
            int len;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buf = new byte[1024];
            while ((len = is.read(buf)) >= 0) {
                baos.write(buf, 0, len);
            }
            buf = baos.toByteArray();
            int i = name.lastIndexOf(46);
            if (i != -1 && (pkg = this.getPackage(pkgname = name.substring(0, i))) == null) {
                this.definePackage(pkgname, null, null, null, null, null, null, null);
            }
            return this.defineClass(name, buf, 0, buf.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    private static URL[] getToolsJar(@Nullable ClassLoader parent) throws ToolsJarNotFoundException {
        try {
            Class.forName("com.sun.tools.javac.Main", false, parent);
            Class.forName("com.sun.tools.apt.Main", false, parent);
            return new URL[0];
        }
        catch (ClassNotFoundException e) {
            File jreHome = new File(System.getProperty("java.home"));
            File toolsJar = new File(jreHome.getParent(), "lib/tools.jar");
            if (!toolsJar.exists()) {
                throw new ToolsJarNotFoundException(toolsJar);
            }
            try {
                return new URL[]{toolsJar.toURL()};
            }
            catch (MalformedURLException e2) {
                throw new AssertionError((Object)e2);
            }
        }
    }
}

