/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.io.IOException;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTDriverImpl;
import org.netbeans.modules.cnd.apt.structure.APTFile;
import org.netbeans.modules.cnd.apt.support.APTFileBuffer;
import org.netbeans.modules.cnd.apt.support.APTFileCache;
import org.openide.filesystems.FileSystem;

public final class APTDriver {
    private static final Map<FileSystem, APTDriverImpl> drivers = new WeakHashMap<FileSystem, APTDriverImpl>();
    private static final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private static final Lock rLock = rwLock.readLock();
    private static final Lock wLock = rwLock.writeLock();

    private APTDriver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static APTDriverImpl getInstance(APTFileBuffer buffer) {
        APTDriverImpl impl;
        FileSystem fs2 = buffer.getFileSystem();
        rLock.lock();
        try {
            impl = drivers.get(fs2);
        }
        finally {
            rLock.unlock();
        }
        if (impl == null) {
            wLock.lock();
            try {
                impl = drivers.get(fs2);
                if (impl == null) {
                    impl = new APTDriverImpl();
                    drivers.put(fs2, impl);
                }
            }
            finally {
                wLock.unlock();
            }
        }
        return impl;
    }

    public static APTFile findAPTLight(APTFileBuffer buffer) throws IOException {
        assert (!APTTraceFlags.USE_CLANK);
        APTFile out = null;
        if (buffer instanceof APTFileCache) {
            out = ((APTFileCache)((Object)buffer)).getCachedAPTLight();
        }
        if (out == null) {
            out = APTDriver.getInstance(buffer).findAPT(buffer, false, "Unknown Language", "");
        }
        return out;
    }

    public static APTFile findAPT(APTFileBuffer buffer, String lang, String flavor) throws IOException {
        assert (!APTTraceFlags.USE_CLANK);
        APTFile out = null;
        if (buffer instanceof APTFileCache) {
            out = ((APTFileCache)((Object)buffer)).getCachedAPT();
        }
        if (out == null) {
            out = APTDriver.getInstance(buffer).findAPT(buffer, true, lang, flavor);
        }
        return out;
    }

    public static void invalidateAPT(APTFileBuffer buffer) {
        if (buffer instanceof APTFileCache) {
            ((APTFileCache)((Object)buffer)).invalidate();
        }
        APTDriver.getInstance(buffer).invalidateAPT(buffer);
    }

    public static void invalidateAll() {
        wLock.lock();
        try {
            for (APTDriverImpl driver : drivers.values()) {
                driver.invalidateAll();
            }
            drivers.clear();
        }
        finally {
            wLock.unlock();
        }
    }

    public static void close() {
        wLock.lock();
        try {
            for (APTDriverImpl driver : drivers.values()) {
                driver.close();
            }
            drivers.clear();
        }
        finally {
            wLock.unlock();
        }
    }

    public static void dumpStatistics() {
        wLock.lock();
        try {
            for (APTDriverImpl driver : drivers.values()) {
                driver.traceActivity();
            }
        }
        finally {
            wLock.unlock();
        }
    }
}

