/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.indexing.impl;

import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.indexing.impl.DiskTextIndexLayer;
import org.netbeans.modules.cnd.indexing.spi.TextIndexLayer;
import org.netbeans.modules.cnd.indexing.spi.TextIndexLayerFactory;
import org.netbeans.modules.cnd.repository.impl.spi.LayerDescriptor;
import org.netbeans.modules.parsing.lucene.support.DocumentIndex;
import org.netbeans.modules.parsing.lucene.support.IndexManager;

public final class DistTextIndexLayerFactory
implements TextIndexLayerFactory {
    private static final String INDEX_FOLDER_NAME = "text_index";

    @Override
    public boolean canHandle(LayerDescriptor layerDescriptor) {
        String scheme = layerDescriptor.getURI().getScheme();
        return "file".equals(scheme);
    }

    @Override
    public TextIndexLayer createLayer(LayerDescriptor layerDescriptor) {
        try {
            File indexRoot = new File(new File(layerDescriptor.getURI().getPath()), INDEX_FOLDER_NAME);
            boolean isWritable = layerDescriptor.isWritable();
            if (!indexRoot.exists() && isWritable) {
                indexRoot.mkdirs();
            }
            if (!indexRoot.exists()) {
                return null;
            }
            DocumentIndex index = IndexManager.createDocumentIndex((File)indexRoot, (boolean)isWritable);
            return new DiskTextIndexLayer(layerDescriptor, index);
        }
        catch (IOException ex) {
            Logger.getLogger(DistTextIndexLayerFactory.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }
}

