/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.server;

import java.util.HashMap;
import java.util.Map;

public abstract class StopWatch {
    private static final StopWatch DUMMY = new Dummy();
    private static final Object lock = new Object();
    private static final Map<String, Integer> indents = new HashMap<String, Integer>();

    public abstract void stop();

    public static StopWatch createAndStart(boolean enabled, String category, Object key, String message, Object ... arguments) {
        if (!enabled) {
            return DUMMY;
        }
        StringBuilder text = new StringBuilder();
        text.append(category).append(" [").append(key).append("]: ");
        String indentKey = category + key;
        int indent = StopWatch.indent(indentKey, 1);
        for (int i = 0; i < indent; ++i) {
            text.append("    ");
        }
        text.append(String.format(message, arguments));
        return new Impl(text, indentKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int indent(String indentKey, int delta) {
        Object object = lock;
        synchronized (object) {
            Integer indent = indents.get(indentKey);
            indent = indent == null ? 0 : indent + delta;
            indents.put(indentKey, indent);
            return indent;
        }
    }

    private static class Impl
    extends StopWatch {
        private long time;
        private final CharSequence text;
        private final String indentKey;

        private Impl(CharSequence text, String indentKey) {
            this.text = text;
            this.indentKey = indentKey;
            this.time = System.currentTimeMillis();
            System.err.printf("[%d] %s starting...%n", System.currentTimeMillis(), text);
        }

        @Override
        public void stop() {
            this.time = System.currentTimeMillis() - this.time;
            System.err.printf("[%d] %s finished in %s ms%n", System.currentTimeMillis(), this.text, this.time);
            StopWatch.indent(this.indentKey, -1);
        }
    }

    private static class Dummy
    extends StopWatch {
        private Dummy() {
        }

        @Override
        public void stop() {
        }
    }
}

