/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URI;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import org.netbeans.modules.git.remote.FileStatusCache;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.GitModuleConfig;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionListener;
import org.netbeans.modules.remotefs.versioning.api.RemoteFileSystemConnectionManager;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSHistoryProvider;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.core.spi.VersioningSystem;
import org.netbeans.spi.queries.CollocationQueryImplementation2;
import org.openide.filesystems.FileSystem;
import org.openide.util.NbBundle;

public class GitVCS
extends VersioningSystem
implements PropertyChangeListener,
PreferenceChangeListener,
RemoteFileSystemConnectionListener {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.git.remote.GitVCS");
    private final CollocationQueryImplementation2 collocationQueryImplementation = new CollocationQueryImplementation2(){

        public boolean areCollocated(URI a, URI b) {
            VCSFileProxy fra = VCSFileProxySupport.fromURI((URI)a);
            VCSFileProxy frb = VCSFileProxySupport.fromURI((URI)b);
            if (fra == null || frb == null) {
                return false;
            }
            fra = GitVCS.this.getTopmostManagedAncestor(fra);
            frb = GitVCS.this.getTopmostManagedAncestor(frb);
            return fra != null && fra.equals((Object)frb);
        }

        public URI findRoot(URI file) {
            VCSFileProxy topmostManagedAncestor;
            VCSFileProxy fromURI = VCSFileProxySupport.fromURI((URI)file);
            if (fromURI != null && (topmostManagedAncestor = GitVCS.this.getTopmostManagedAncestor(fromURI)) != null) {
                return VCSFileProxySupport.toURI((VCSFileProxy)topmostManagedAncestor);
            }
            return null;
        }
    };

    public GitVCS() {
        RemoteFileSystemConnectionManager.getInstance().addRemoteFileSystemConnectionListener((RemoteFileSystemConnectionListener)this);
        GitModuleConfig.getDefault().getPreferences().addPreferenceChangeListener(this);
        Git.getInstance().registerGitVCS(this);
    }

    public static String getDisplayName() throws MissingResourceException {
        return NbBundle.getMessage(GitVCS.class, (String)"CTL_Git_DisplayName");
    }

    public VCSAnnotator getVCSAnnotator() {
        return Git.getInstance().getVCSAnnotator();
    }

    public VCSInterceptor getVCSInterceptor() {
        return Git.getInstance().getVCSInterceptor();
    }

    public void getOriginalFile(VCSFileProxy workingCopy, VCSFileProxy originalFile) {
        Git.getInstance().getOriginalFile(workingCopy, originalFile);
    }

    public VCSFileProxy getTopmostManagedAncestor(VCSFileProxy file) {
        return Git.getInstance().getTopmostManagedAncestor(file);
    }

    public CollocationQueryImplementation2 getCollocationQueryImplementation() {
        return this.collocationQueryImplementation;
    }

    public VCSHistoryProvider getVCSHistoryProvider() {
        return Git.getInstance().getHistoryProvider();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("status.changed")) {
            FileStatusCache.ChangedEvent changedEvent = (FileStatusCache.ChangedEvent)event.getNewValue();
            this.fireStatusChanged(changedEvent.getFile());
        } else if (event.getPropertyName().equals("annotationsChanged")) {
            this.fireAnnotationsChanged((Set)event.getNewValue());
        } else if (event.getPropertyName().equals("versionedFilesChanged")) {
            LOG.fine("cleaning unversioned parents cache");
            Git.getInstance().clearAncestorCaches();
            this.fireVersionedFilesChanged();
        }
    }

    void refreshStatus(Set<VCSFileProxy> files) {
        this.fireStatusChanged(files == null || files.isEmpty() ? null : files);
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            this.fireStatusChanged(null);
        }
    }

    public void connected(FileSystem fs) {
        Git.getInstance().clearAncestorCaches();
        this.postVersionedRootsChanged();
    }

    public void disconnected(FileSystem fs) {
        Git.getInstance().clearAncestorCaches();
        this.postVersionedRootsChanged();
    }

    private void postVersionedRootsChanged() {
        Git.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                VersioningSupport.versionedRootsChanged();
            }
        });
    }
}

