/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.actions;

import java.awt.EventQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.progress.ProgressUtils;
import org.netbeans.modules.git.remote.ui.actions.Bundle;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.LifecycleManager;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public abstract class GitAction
extends NodeAction {
    protected GitAction() {
        this(null);
    }

    protected GitAction(String iconResource) {
        if (iconResource == null) {
            this.setIcon(null);
            this.putValue("noIconInMenu", Boolean.TRUE);
        } else {
            this.setIcon(ImageUtilities.loadImageIcon((String)iconResource, (boolean)true));
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        VCSContext context = this.getCurrentContext(activatedNodes);
        return GitUtils.isFromGitRepository(context);
    }

    protected final void performAction(final Node[] nodes) {
        final AtomicBoolean canceled = new AtomicBoolean(false);
        Runnable run = new Runnable(){

            @Override
            public void run() {
                LifecycleManager.getDefault().saveAll();
                Utils.logVCSActionEvent((String)"Git");
                if (!canceled.get()) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitAction.this.performContextAction(nodes);
                        }
                    });
                }
            }
        };
        ProgressUtils.runOffEventDispatchThread((Runnable)run, (String)Bundle.MSG_GitAction_savingFiles_progress(), (AtomicBoolean)canceled, (boolean)false);
    }

    protected abstract void performContextAction(Node[] var1);

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)("LBL_" + ((Object)((Object)this)).getClass().getSimpleName() + "_Name"));
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(((Object)((Object)this)).getClass());
    }

    protected final VCSContext getCurrentContext(Node[] nodes) {
        return GitUtils.getCurrentContext(nodes);
    }

    protected final boolean asynchronous() {
        return false;
    }
}

