/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.revert;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.remote.ui.revert.RevertCommitPanel;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RevertCommit
implements ActionListener,
DocumentListener {
    private final RevertCommitPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean valid = true;

    RevertCommit(VCSFileProxy repository, VCSFileProxy[] roots, String initialRevision) {
        this.revisionPicker = new RevisionDialogController(repository, roots, initialRevision);
        this.panel = new RevertCommitPanel(this.revisionPicker.getPanel());
        this.attachListeners();
    }

    String getRevision() {
        return this.revisionPicker.getRevision().getRevision();
    }

    String getMessage() {
        return this.panel.txtCommitMessage.getText().trim();
    }

    boolean isCommitEnabled() {
        return this.panel.cbCommit.isSelected();
    }

    boolean show() {
        this.okButton = new JButton(NbBundle.getMessage(RevertCommit.class, (String)"LBL_RevertCommit.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(RevertCommit.class, (String)"LBL_RevertCommit.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx(RevertCommit.class), null);
        this.enableRevisionPanel();
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    RevertCommit.this.setValid(Boolean.TRUE.equals(evt.getNewValue()));
                }
            }
        });
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    private void enableRevisionPanel() {
        this.setValid(this.valid);
    }

    private void setValid(boolean flag) {
        this.valid = flag;
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }

    private void attachListeners() {
        this.panel.cbCommit.addActionListener(this);
        this.panel.txtCommitMessage.getDocument().addDocumentListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.cbCommit) {
            this.panel.commitMessagePanel.setVisible(this.panel.cbCommit.isSelected());
        }
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.messageChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.messageChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.messageChanged();
    }

    private void messageChanged() {
        this.panel.lblMessageWarning.setVisible(this.getMessage().isEmpty());
    }
}

