/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.v2.features;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import javax.swing.AbstractButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.ui.components.ProfilerToolbar;
import org.netbeans.lib.profiler.ui.monitor.MonitorView;
import org.netbeans.lib.profiler.ui.swing.GrayLabel;
import org.netbeans.lib.profiler.ui.swing.MultiButtonGroup;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.netbeans.modules.profiler.v2.features.Bundle;
import org.netbeans.modules.profiler.v2.features.FeatureUI;

abstract class MonitorFeatureUI
extends FeatureUI {
    private static final String CPU_GRAPH_FLAG = "CPU_GRAPH_FLAG";
    private static final String MEM_GRAPH_FLAG = "MEM_GRAPH_FLAG";
    private static final String GC_GRAPH_FLAG = "GC_GRAPH_FLAG";
    private static final String THCL_GRAPH_FLAG = "THCL_GRAPH_FLAG";
    private ProfilerToolbar toolbar;
    private MonitorView monitorView;
    private JLabel grLabel;

    MonitorFeatureUI() {
    }

    abstract Profiler getProfiler();

    abstract String readFlag(String var1, String var2);

    abstract void storeFlag(String var1, String var2);

    @Override
    ProfilerToolbar getToolbar() {
        if (this.toolbar == null) {
            this.initUI();
        }
        return this.toolbar;
    }

    @Override
    JPanel getResultsUI() {
        if (this.monitorView == null) {
            this.initUI();
        }
        return this.monitorView;
    }

    void cleanup() {
        if (this.monitorView != null) {
            this.monitorView.cleanup();
        }
    }

    @Override
    void sessionStateChanged(int sessionState) {
        this.refreshToolbar(sessionState);
    }

    private void initUI() {
        assert (SwingUtilities.isEventDispatchThread());
        this.monitorView = new MonitorView(this.getProfiler().getVMTelemetryManager());
        this.monitorView.putClientProperty((Object)"HelpCtx.Key", (Object)"ProfileTelemetry.HelpCtx");
        MultiButtonGroup group = new MultiButtonGroup();
        this.toolbar = ProfilerToolbar.create((boolean)true);
        this.toolbar.addSpace(2);
        this.toolbar.addSeparator();
        this.toolbar.addSpace(5);
        this.grLabel = new GrayLabel(Bundle.MonitorFeatureUI_graphs());
        this.toolbar.add((Component)this.grLabel);
        this.toolbar.addSpace(2);
        JToggleButton cpuView = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.Cpu")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                MonitorFeatureUI.this.monitorView.setupCPUView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                super.fireItemStateChanged(event);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.CPU_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        cpuView.putClientProperty("JButton.buttonType", "segmented");
        cpuView.putClientProperty("JButton.segmentPosition", "first");
        cpuView.setToolTipText(Bundle.MonitorFeatureUI_cpuGraph());
        group.add((AbstractButton)cpuView);
        boolean cpuGraphVisible = Boolean.parseBoolean(this.readFlag(CPU_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupCPUView(cpuGraphVisible);
        cpuView.setSelected(cpuGraphVisible);
        this.toolbar.add((Component)cpuView);
        JToggleButton memoryView = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.Memory")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                MonitorFeatureUI.this.monitorView.setupMemoryView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                super.fireItemStateChanged(event);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.MEM_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        memoryView.putClientProperty("JButton.buttonType", "segmented");
        memoryView.putClientProperty("JButton.segmentPosition", "middle");
        memoryView.setToolTipText(Bundle.MonitorFeatureUI_memoryGraph());
        group.add((AbstractButton)memoryView);
        boolean memGraphVisible = Boolean.parseBoolean(this.readFlag(MEM_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupMemoryView(memGraphVisible);
        memoryView.setSelected(memGraphVisible);
        this.toolbar.add((Component)memoryView);
        JToggleButton gcView = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.RunGC")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                MonitorFeatureUI.this.monitorView.setupGCView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                super.fireItemStateChanged(event);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.GC_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        gcView.putClientProperty("JButton.buttonType", "segmented");
        gcView.putClientProperty("JButton.segmentPosition", "middle");
        gcView.setToolTipText(Bundle.MonitorFeatureUI_gcGraph());
        group.add((AbstractButton)gcView);
        boolean gcGraphVisible = Boolean.parseBoolean(this.readFlag(GC_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupGCView(gcGraphVisible);
        gcView.setSelected(gcGraphVisible);
        this.toolbar.add((Component)gcView);
        JToggleButton threadsView = new JToggleButton(Icons.getIcon((String)"ProfilerIcons.WindowThreads")){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                super.fireActionPerformed(e);
                MonitorFeatureUI.this.monitorView.setupThreadsView(this.isSelected());
            }

            @Override
            protected void fireItemStateChanged(ItemEvent event) {
                super.fireItemStateChanged(event);
                MonitorFeatureUI.this.storeFlag(MonitorFeatureUI.THCL_GRAPH_FLAG, this.isSelected() ? null : Boolean.FALSE.toString());
            }
        };
        threadsView.putClientProperty("JButton.buttonType", "segmented");
        threadsView.putClientProperty("JButton.segmentPosition", "last");
        threadsView.setToolTipText(Bundle.MonitorFeatureUI_threadsGraph());
        group.add((AbstractButton)threadsView);
        boolean thclGraphVisible = Boolean.parseBoolean(this.readFlag(THCL_GRAPH_FLAG, Boolean.TRUE.toString()));
        this.monitorView.setupThreadsView(thclGraphVisible);
        threadsView.setSelected(thclGraphVisible);
        this.toolbar.add((Component)threadsView);
        this.sessionStateChanged(this.getSessionState());
    }

    private void refreshToolbar(int state) {
    }
}

