/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver;

import java.util.Iterator;
import org.clang.driver.Action;
import org.clang.driver.ToolChain;
import org.clang.driver.java.DriverFunctionPointers;
import org.clang.driver.types;
import org.clank.support.Destructors;
import org.clank.support.Native;
import org.clank.support.aliases.char;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.support.llvm;

public final class OffloadAction
extends Action
implements Destructors.ClassWithDestructor {
    private ToolChain HostTC;
    private SmallVector<ToolChain> DevToolChains;

    protected void anchor() {
    }

    public OffloadAction(HostDependence HDep) {
        super(Action.ActionClass.OffloadClass, HDep.getAction());
        this.HostTC = HDep.getToolChain();
        this.DevToolChains = new SmallVector(3, (Object)null);
        this.OffloadingArch = Native.$tryClone((char.ptr)HDep.getBoundArch());
        this.ActiveOffloadKindMask = HDep.getOffloadKinds();
        HDep.getAction().propagateHostOffloadInfo(HDep.getOffloadKinds(), HDep.getBoundArch());
    }

    public OffloadAction(DeviceDependences DDeps, types.ID Ty) {
        super(Action.ActionClass.OffloadClass, DDeps.getActions(), Ty);
        this.HostTC = null;
        this.DevToolChains = new SmallVector(DDeps.getToolChains());
        SmallVectorUInt OKinds = DDeps.getOffloadKinds();
        SmallVector<char.ptr> BArchs = DDeps.getBoundArchs();
        if (llvm.all_of((SmallVectorUInt)OKinds, K -> K == OKinds.front())) {
            this.OffloadingDeviceKind = OKinds.front();
        }
        if (OKinds.size() == 1) {
            this.OffloadingArch = Native.$tryClone((char.ptr)((char.ptr)BArchs.front()));
        }
        int e = this.getInputs().size();
        for (int i = 0; i != e; ++i) {
            ((Action)this.getInputs().$at(i)).propagateDeviceOffloadInfo(OKinds.$at(i), (char.ptr)BArchs.$at(i));
        }
    }

    public OffloadAction(HostDependence HDep, DeviceDependences DDeps) {
        super(Action.ActionClass.OffloadClass, HDep.getAction());
        this.HostTC = HDep.getToolChain();
        this.DevToolChains = new SmallVector(DDeps.getToolChains());
        this.OffloadingArch = Native.$tryClone((char.ptr)HDep.getBoundArch());
        this.ActiveOffloadKindMask = HDep.getOffloadKinds();
        HDep.getAction().propagateHostOffloadInfo(HDep.getOffloadKinds(), HDep.getBoundArch());
        int e = DDeps.getActions().size();
        for (int i = 0; i != e; ++i) {
            Action A = (Action)DDeps.getActions().$at(i);
            if (A == null) continue;
            this.getInputs().push_back((Object)A);
            A.propagateDeviceOffloadInfo(DDeps.getOffloadKinds().$at(i), (char.ptr)DDeps.getBoundArchs().$at(i));
        }
    }

    public void doOnHostDependence(DriverFunctionPointers.OffloadActionWorkTy Work) {
        if (this.HostTC == null) {
            return;
        }
        assert (!this.getInputs().empty()) : "No dependencies for offload action??";
        Action A = (Action)this.getInputs().front();
        Work.$call(A, this.HostTC, A.getOffloadingArch());
    }

    public void doOnEachDeviceDependence(DriverFunctionPointers.OffloadActionWorkTy Work) {
        SmallVectorImpl.iterator E;
        SmallVectorImpl.iterator I = this.getInputs().begin();
        if (I.$eq((Object)(E = this.getInputs().end()))) {
            return;
        }
        assert (this.getInputs().size() == this.DevToolChains.size() + (this.HostTC != null ? 1 : 0)) : "Sizes of action dependences and toolchains are not consistent!";
        if (this.HostTC != null) {
            I.$preInc();
        }
        SmallVectorImpl.iterator TI = this.DevToolChains.begin();
        while (I.$noteq((Object)E)) {
            Work.$call((Action)I.$arrow(), (ToolChain)TI.$arrow(), ((Action)I.$arrow()).getOffloadingArch());
            I.$preInc();
            TI.$preInc();
        }
    }

    public void doOnEachDependence(DriverFunctionPointers.OffloadActionWorkTy Work) {
        this.doOnHostDependence(Work);
        this.doOnEachDeviceDependence(Work);
    }

    public void doOnEachDependence(boolean IsHostDependence, DriverFunctionPointers.OffloadActionWorkTy Work) {
        if (IsHostDependence) {
            this.doOnHostDependence(Work);
        } else {
            this.doOnEachDeviceDependence(Work);
        }
    }

    public boolean hasHostDependence() {
        return this.HostTC != null;
    }

    public Action getHostDependence() {
        assert (this.hasHostDependence()) : "Host dependence does not exist!";
        assert (!this.getInputs().empty()) : "No dependencies for offload action??";
        return this.HostTC != null ? (Action)this.getInputs().front() : null;
    }

    public boolean hasSingleDeviceDependence() {
        return this.hasSingleDeviceDependence(false);
    }

    public boolean hasSingleDeviceDependence(boolean DoNotConsiderHostActions) {
        if (DoNotConsiderHostActions) {
            return this.getInputs().size() == (this.HostTC != null ? 2 : 1);
        }
        return this.HostTC == null && this.getInputs().size() == 1;
    }

    public Action getSingleDeviceDependence() {
        return this.getSingleDeviceDependence(false);
    }

    public Action getSingleDeviceDependence(boolean DoNotConsiderHostActions) {
        assert (this.hasSingleDeviceDependence(DoNotConsiderHostActions)) : "Single device dependence does not exist!";
        return this.HostTC != null ? (Action)this.getInputs().$at(1) : (Action)this.getInputs().front();
    }

    public static boolean classof(Action A) {
        return A.getKind() == Action.ActionClass.OffloadClass;
    }

    @Override
    public void $destroy() {
        this.DevToolChains.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "HostTC=" + this.HostTC + ", DevToolChains=" + this.DevToolChains + super.toString();
    }

    public static final class HostDependence {
        private Action HostAction;
        private ToolChain HostToolChain;
        private char.ptr HostBoundArch;
        private int HostOffloadKinds;

        public HostDependence(Action A, ToolChain TC, char.ptr BoundArch, int OffloadKinds) {
            this.HostAction = A;
            this.HostToolChain = TC;
            this.HostBoundArch = Native.$tryClone((char.ptr)BoundArch);
            this.HostOffloadKinds = OffloadKinds;
        }

        public HostDependence(Action A, ToolChain TC, char.ptr BoundArch, DeviceDependences DDeps) {
            this.HostAction = A;
            this.HostToolChain = TC;
            this.HostBoundArch = Native.$tryClone((char.ptr)BoundArch);
            this.HostOffloadKinds = 0;
            Iterator iterator2 = DDeps.getOffloadKinds().iterator();
            while (iterator2.hasNext()) {
                int K = (Integer)iterator2.next();
                this.HostOffloadKinds |= K;
            }
        }

        public Action getAction() {
            return this.HostAction;
        }

        public ToolChain getToolChain() {
            return this.HostToolChain;
        }

        public char.ptr getBoundArch() {
            return this.HostBoundArch;
        }

        public int getOffloadKinds() {
            return this.HostOffloadKinds;
        }

        public String toString() {
            return "HostAction=" + this.HostAction + ", HostToolChain=" + this.HostToolChain + ", HostBoundArch=" + this.HostBoundArch + ", HostOffloadKinds=" + this.HostOffloadKinds;
        }
    }

    public static final class DeviceDependences
    implements Destructors.ClassWithDestructor {
        private SmallVector<Action> DeviceActions = new SmallVector(3, (Object)null);
        private SmallVector<ToolChain> DeviceToolChains = new SmallVector(3, (Object)null);
        private SmallVector<char.ptr> DeviceBoundArchs = new SmallVector(3, null);
        private SmallVectorUInt DeviceOffloadKinds = new SmallVectorUInt(3, 0);

        public void add(Action A, ToolChain TC, char.ptr BoundArch, int OKind) {
            this.DeviceActions.push_back((Object)A);
            this.DeviceToolChains.push_back((Object)TC);
            this.DeviceBoundArchs.push_back((Object)BoundArch);
            this.DeviceOffloadKinds.push_back(OKind);
        }

        public SmallVector<Action> getActions() {
            return this.DeviceActions;
        }

        public SmallVector<ToolChain> getToolChains() {
            return this.DeviceToolChains;
        }

        public SmallVector<char.ptr> getBoundArchs() {
            return this.DeviceBoundArchs;
        }

        public SmallVectorUInt getOffloadKinds() {
            return this.DeviceOffloadKinds;
        }

        public void $destroy() {
            this.DeviceOffloadKinds.$destroy();
            this.DeviceBoundArchs.$destroy();
            this.DeviceToolChains.$destroy();
            this.DeviceActions.$destroy();
        }

        public String toString() {
            return "DeviceActions=" + this.DeviceActions + ", DeviceToolChains=" + this.DeviceToolChains + ", DeviceBoundArchs=" + this.DeviceBoundArchs + ", DeviceOffloadKinds=" + this.DeviceOffloadKinds;
        }
    }
}

