/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.remote.FileInformation;
import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgException;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.OutputLogger;
import org.netbeans.modules.mercurial.remote.WorkingCopyInfo;
import org.netbeans.modules.mercurial.remote.util.HgCommand;
import org.netbeans.modules.mercurial.remote.util.HgSearchHistorySupport;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.api.VersioningSupport;
import org.netbeans.modules.versioning.core.spi.VCSInterceptor;
import org.netbeans.modules.versioning.util.DelayScanRegistry;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MercurialInterceptor
extends VCSInterceptor {
    private final FileStatusCache cache;
    private final ConcurrentLinkedQueue<VCSFileProxy> filesToRefresh = new ConcurrentLinkedQueue();
    private final Map<VCSFileProxy, Set<VCSFileProxy>> lockedRepositories = new HashMap<VCSFileProxy, Set<VCSFileProxy>>(5);
    private final RequestProcessor.Task refreshTask;
    private final RequestProcessor.Task lockedRepositoryRefreshTask;
    private final RequestProcessor.Task refreshOwnersTask;
    private static final RequestProcessor rp = new RequestProcessor("MercurialRemoteRefresh", 1, true);
    private final HgFolderEventsHandler hgFolderEventsHandler;
    private final CommandUsageLogger commandLogger;
    private static final boolean AUTOMATIC_REFRESH_ENABLED = !"true".equals(System.getProperty("versioning.mercurial.autoRefreshDisabled", "false"));
    private final Mercurial hg;
    private static final int STATUS_VCS_MODIFIED_ATTRIBUTE = 4308;

    MercurialInterceptor(Mercurial hg, FileStatusCache cache) {
        this.cache = cache;
        this.hg = hg;
        this.refreshTask = rp.create((Runnable)new RefreshTask());
        this.lockedRepositoryRefreshTask = rp.create((Runnable)new LockedRepositoryRefreshTask());
        this.hgFolderEventsHandler = new HgFolderEventsHandler();
        this.commandLogger = new CommandUsageLogger();
        this.refreshOwnersTask = rp.create(new Runnable(){

            @Override
            public void run() {
                Mercurial hg = Mercurial.getInstance();
                hg.clearAncestorCaches();
                hg.versionedFilesChanged();
                VersioningSupport.versionedRootsChanged();
            }
        });
    }

    public boolean beforeDelete(VCSFileProxy file) {
        Mercurial.LOG.log(Level.FINE, "beforeDelete {0}", file);
        if (file == null) {
            return false;
        }
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        return !HgUtils.isIgnored(file, false);
    }

    public void doDelete(VCSFileProxy file) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doDelete {0}", file);
        if (file == null) {
            return;
        }
        VCSFileProxy root = this.hg.getRepositoryRoot(file);
        VCSFileProxySupport.delete((VCSFileProxy)file);
        if (file.exists()) {
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(MercurialInterceptor.class, (String)"MSG_DeleteFailed", (Object[])new Object[]{file}));
            throw ex;
        }
        try {
            HgCommand.doRemove(root, file, null);
        }
        catch (HgException ex) {
            Mercurial.LOG.log(Level.FINE, "doDelete(): File: {0} {1}", new Object[]{file.getPath(), ex.toString()});
        }
    }

    public void afterDelete(VCSFileProxy file) {
        Mercurial.LOG.log(Level.FINE, "afterDelete {0}", file);
        if (file == null) {
            return;
        }
        if (HgUtils.isPartOfMercurialMetadata(file) && "wlock".equals(file.getName())) {
            this.commandLogger.unlocked(file);
        }
        if (".hg".equals(file.getName())) {
            this.refreshOwnersTask.schedule(3000);
        }
        if (HgUtils.isIgnored(file, false)) {
            if (Mercurial.LOG.isLoggable(Level.FINER)) {
                Mercurial.LOG.log(Level.FINE, "skipping afterDelete(): File: {0} is ignored", new Object[]{file.getPath()});
            }
            return;
        }
        this.reScheduleRefresh(800, file, true);
    }

    public boolean beforeMove(VCSFileProxy from, VCSFileProxy to) {
        Mercurial.LOG.log(Level.FINE, "beforeMove {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        if (this.hg.isManaged(from)) {
            return this.hg.isManaged(to);
        }
        return super.beforeMove(from, to);
    }

    public void doMove(VCSFileProxy from, VCSFileProxy to) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doMove {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists() && !this.equalPathsIgnoreCase(from, to)) {
            return;
        }
        this.hgMoveImplementation(from, to);
    }

    public long refreshRecursively(VCSFileProxy dir, long lastTimeStamp, List<? super VCSFileProxy> children) {
        long retval = -1L;
        if (".hg".equals(dir.getName())) {
            Mercurial.STATUS_LOG.log(Level.FINER, "Interceptor.refreshRecursively: {0}", dir.getPath());
            children.clear();
            retval = this.hgFolderEventsHandler.handleHgFolderEvent(dir);
        }
        return retval;
    }

    public boolean isMutable(VCSFileProxy file) {
        return HgUtils.isPartOfMercurialMetadata(file) || super.isMutable(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void hgMoveImplementation(VCSFileProxy srcFile, VCSFileProxy dstFile) throws IOException {
        VCSFileProxy root = this.hg.getRepositoryRoot(srcFile);
        VCSFileProxy dstRoot = this.hg.getRepositoryRoot(dstFile);
        Mercurial.LOG.log(Level.FINE, "hgMoveImplementation(): File: {0} {1}", new Object[]{srcFile, dstFile});
        boolean result = VCSFileProxySupport.renameTo((VCSFileProxy)srcFile, (VCSFileProxy)dstFile);
        if (!result && this.equalPathsIgnoreCase(srcFile, dstFile)) {
            Mercurial.LOG.log(Level.FINE, "hgMoveImplementation: magic workaround for filename case change {0} -> {1}", new Object[]{srcFile, dstFile});
            VCSFileProxy temp = VCSFileProxySupport.generateTemporaryFile((VCSFileProxy)dstFile.getParentFile(), (String)srcFile.getName());
            Mercurial.LOG.log(Level.FINE, "hgMoveImplementation: magic workaround, step 1: {0} -> {1}", new Object[]{srcFile, temp});
            VCSFileProxySupport.renameTo((VCSFileProxy)srcFile, (VCSFileProxy)temp);
            Mercurial.LOG.log(Level.FINE, "hgMoveImplementation: magic workaround, step 2: {0} -> {1}", new Object[]{temp, dstFile});
            result = VCSFileProxySupport.renameTo((VCSFileProxy)temp, (VCSFileProxy)dstFile);
            Mercurial.LOG.log(Level.FINE, "hgMoveImplementation: magic workaround completed");
        }
        if (!result) {
            Mercurial.LOG.log(Level.WARNING, "Cannot rename file {0} to {1}", new Object[]{srcFile, dstFile});
            IOException ex = new IOException();
            Exceptions.attachLocalizedMessage((Throwable)ex, (String)NbBundle.getMessage(MercurialInterceptor.class, (String)"MSG_MoveFailed", (Object[])new Object[]{srcFile, dstFile}));
            throw ex;
        }
        if (root == null) {
            return;
        }
        OutputLogger logger = OutputLogger.getLogger(root);
        try {
            if (root.equals((Object)dstRoot) && !HgUtils.isIgnored(dstFile, false)) {
                HgCommand.doRenameAfter(root, srcFile, dstFile, logger);
            } else {
                HgCommand.doRemove(root, srcFile, logger);
            }
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.FINE, "Mercurial failed to rename: File: {0} {1}", new Object[]{srcFile.getPath(), dstFile.getPath()});
        }
        finally {
            logger.closeLog();
        }
    }

    private boolean equalPathsIgnoreCase(VCSFileProxy srcFile, VCSFileProxy dstFile) {
        return VCSFileProxySupport.isMac((VCSFileProxy)srcFile) && srcFile.getPath().equalsIgnoreCase(dstFile.getPath());
    }

    public void afterMove(VCSFileProxy from, VCSFileProxy to) {
        VCSFileProxy parent;
        Mercurial.LOG.log(Level.FINE, "afterMove {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || !to.exists()) {
            return;
        }
        if (from.equals((Object)Mercurial.getInstance().getRepositoryRoot(from)) || to.equals((Object)Mercurial.getInstance().getRepositoryRoot(to))) {
            this.refreshOwnersTask.schedule(0);
        }
        if ((parent = from.getParentFile()) != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, from, true);
        }
        if ((parent = to.getParentFile()) != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, to, true);
        }
    }

    public boolean beforeCopy(VCSFileProxy from, VCSFileProxy to) {
        Mercurial.LOG.log(Level.FINE, "beforeCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return true;
        }
        return this.hg.isManaged(from) && this.hg.isManaged(to);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doCopy(VCSFileProxy from, VCSFileProxy to) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doCopy {0}->{1}", new Object[]{from, to});
        if (from == null || to == null || to.exists()) {
            return;
        }
        VCSFileProxy root = this.hg.getRepositoryRoot(from);
        VCSFileProxy dstRoot = this.hg.getRepositoryRoot(to);
        if (from.isDirectory()) {
            VCSFileProxySupport.copyDirFiles((VCSFileProxy)from, (VCSFileProxy)to, (boolean)false);
        } else {
            VCSFileProxySupport.copyFile((VCSFileProxy)from, (VCSFileProxy)to);
        }
        if (root == null || HgUtils.isIgnored(to, false)) {
            return;
        }
        OutputLogger logger = OutputLogger.getLogger(root);
        try {
            if (root.equals((Object)dstRoot)) {
                HgCommand.doCopy(root, from, to, true, logger);
            }
        }
        catch (HgException e) {
            Mercurial.LOG.log(Level.FINE, "Mercurial failed to copy: File: {0} {1}", new Object[]{from.getPath(), to.getPath()});
        }
        finally {
            logger.closeLog();
        }
    }

    public void afterCopy(VCSFileProxy from, VCSFileProxy to) {
        Mercurial.LOG.log(Level.FINE, "afterCopy {0}->{1}", new Object[]{from, to});
        if (to == null) {
            return;
        }
        VCSFileProxy parent = to.getParentFile();
        if (parent != null && !HgUtils.isIgnored(parent, false)) {
            this.reScheduleRefresh(800, to, true);
        }
    }

    public boolean beforeCreate(VCSFileProxy file, boolean isDirectory) {
        Mercurial.LOG.log(Level.FINE, "beforeCreate {0} {1}", new Object[]{file, isDirectory});
        if (HgUtils.isPartOfMercurialMetadata(file)) {
            return false;
        }
        if (!isDirectory && !file.exists()) {
            VCSFileProxy root = this.hg.getRepositoryRoot(file);
            FileInformation info = null;
            try {
                Map<VCSFileProxy, FileInformation> statusMap = HgCommand.getStatus(root, Arrays.asList(file), null, null);
                info = statusMap != null ? statusMap.get(file) : null;
            }
            catch (HgException ex) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): getStatus failed for file: {0} {1}", new Object[]{file.getPath(), ex.toString()});
            }
            if (info != null && info.getStatus() == 256) {
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): LocallyDeleted: {0}", file);
                if (root == null) {
                    return false;
                }
                OutputLogger logger = this.hg.getLogger(root.getPath());
                try {
                    ArrayList<VCSFileProxy> revertFiles = new ArrayList<VCSFileProxy>();
                    revertFiles.add(file);
                    HgCommand.doRevert(root, revertFiles, null, false, logger);
                }
                catch (HgException ex) {
                    Mercurial.LOG.log(Level.FINE, "beforeCreate(): File: {0} {1}", new Object[]{file.getPath(), ex.toString()});
                }
                Mercurial.LOG.log(Level.FINE, "beforeCreate(): afterWaitFinished: {0}", file);
                logger.closeLog();
                VCSFileProxySupport.delete((VCSFileProxy)file);
            }
        }
        return false;
    }

    public void doCreate(VCSFileProxy file, boolean isDirectory) throws IOException {
        Mercurial.LOG.log(Level.FINE, "doCreate {0} {1}", new Object[]{file, isDirectory});
        super.doCreate(file, isDirectory);
    }

    public void afterCreate(VCSFileProxy file) {
        Mercurial.LOG.log(Level.FINE, "afterCreate {0}", file);
        if (HgUtils.isPartOfMercurialMetadata(file) && "wlock".equals(file.getName())) {
            this.commandLogger.locked(file);
        }
        if (HgUtils.isAdministrative(file)) {
            this.refreshOwnersTask.schedule(0);
        }
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file, true);
        }
    }

    public void afterChange(VCSFileProxy file) {
        if (file.isDirectory()) {
            return;
        }
        Mercurial.LOG.log(Level.FINE, "afterChange(): {0}", file);
        if (!HgUtils.isIgnored(file, false)) {
            this.reScheduleRefresh(800, file, true);
        }
    }

    public Object getAttribute(final VCSFileProxy file, String attrName) {
        if ("ProvidedExtensions.RemoteLocation".equals(attrName)) {
            return this.getRemoteRepository(file);
        }
        if ("ProvidedExtensions.Refresh".equals(attrName)) {
            return new Runnable(){

                @Override
                public void run() {
                    FileStatusCache cache = MercurialInterceptor.this.hg.getFileStatusCache();
                    cache.refresh(file);
                }
            };
        }
        if ("ProvidedExtensions.SearchHistorySupport".equals(attrName)) {
            return new HgSearchHistorySupport(file);
        }
        if ("ProvidedExtensions.VCSIsModified".equals(attrName)) {
            VCSFileProxy repoRoot = Mercurial.getInstance().getRepositoryRoot(file);
            Boolean modified = null;
            if (repoRoot != null) {
                Set<VCSFileProxy> coll = Collections.singleton(file);
                this.cache.refreshAllRoots(Collections.singletonMap(repoRoot, coll));
                modified = this.cache.containsFileOfStatus(coll, 4308, true);
            }
            return modified;
        }
        return super.getAttribute(file, attrName);
    }

    private String getRemoteRepository(VCSFileProxy file) {
        return HgUtils.getRemoteRepository(file);
    }

    private void reScheduleRefresh(int delayMillis, VCSFileProxy fileToRefresh, boolean log) {
        Mercurial.STATUS_LOG.log(Level.FINE, "reScheduleRefresh: adding {0}", fileToRefresh.getPath());
        if (!HgUtils.isPartOfMercurialMetadata(fileToRefresh)) {
            this.filesToRefresh.add(fileToRefresh);
            if (log) {
                this.commandLogger.logModification(fileToRefresh);
            }
        }
        this.refreshTask.schedule(delayMillis);
    }

    private void reScheduleRefresh(int delayMillis, Set<VCSFileProxy> filesToRefresh) {
        Mercurial.STATUS_LOG.log(Level.FINE, "reScheduleRefresh: adding {0}", filesToRefresh);
        this.filesToRefresh.addAll(filesToRefresh);
        this.refreshTask.schedule(delayMillis);
    }

    void pingRepositoryRootFor(VCSFileProxy file) {
        if (!AUTOMATIC_REFRESH_ENABLED) {
            return;
        }
        this.hgFolderEventsHandler.initializeFor(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T runWithoutExternalEvents(VCSFileProxy repository, String commandName, Callable<T> callable) throws Exception {
        assert (repository != null);
        try {
            if (repository != null) {
                this.hgFolderEventsHandler.enableEvents(repository, false);
                this.commandLogger.lockedInternally(repository, commandName);
            }
            T t = callable.call();
            return t;
        }
        finally {
            if (repository != null) {
                this.commandLogger.unlockedInternally(repository);
                this.hgFolderEventsHandler.refreshRepositoryTimestamps(repository);
                this.hgFolderEventsHandler.enableEvents(repository, true);
            }
        }
    }

    Set<VCSFileProxy> getSeenRoots(VCSFileProxy repositoryRoot) {
        return this.hgFolderEventsHandler.getSeenRoots(repositoryRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<VCSFileProxy> checkLockedRepositories(Collection<VCSFileProxy> additionalFilesToRefresh, boolean keepCached) {
        LinkedList<VCSFileProxy> retval = new LinkedList<VCSFileProxy>();
        Map<VCSFileProxy, Set<VCSFileProxy>> sortedFiles = this.sortByRepository(additionalFilesToRefresh);
        for (Map.Entry<VCSFileProxy, Set<VCSFileProxy>> e : sortedFiles.entrySet()) {
            Set<VCSFileProxy> alreadyPlanned = this.lockedRepositories.get(e.getKey());
            if (alreadyPlanned == null) {
                alreadyPlanned = new HashSet<VCSFileProxy>();
                this.lockedRepositories.put(e.getKey(), alreadyPlanned);
            }
            alreadyPlanned.addAll((Collection<VCSFileProxy>)e.getValue());
        }
        Iterator<Map.Entry<VCSFileProxy, Set<VCSFileProxy>>> it = this.lockedRepositories.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<VCSFileProxy, Set<VCSFileProxy>> entry = it.next();
            VCSFileProxy repository = entry.getKey();
            boolean unlocked = true;
            if (!repository.exists()) {
                it.remove();
            } else if (HgUtils.isRepositoryLocked(repository)) {
                unlocked = false;
                Mercurial.STATUS_LOG.log(Level.FINE, "checkLockedRepositories(): Repository {0} locked, status refresh delayed", repository);
            } else {
                retval.addAll((Collection<VCSFileProxy>)entry.getValue());
                if (!keepCached) {
                    it.remove();
                }
            }
            if (!unlocked) continue;
            CommandUsageLogger commandUsageLogger = this.commandLogger;
            synchronized (commandUsageLogger) {
                this.commandLogger.notifyAll();
            }
        }
        return retval;
    }

    private Map<VCSFileProxy, Set<VCSFileProxy>> sortByRepository(Collection<VCSFileProxy> files) {
        HashMap<VCSFileProxy, Set<VCSFileProxy>> sorted = new HashMap<VCSFileProxy, Set<VCSFileProxy>>(5);
        for (VCSFileProxy f : files) {
            VCSFileProxy repository = this.hg.getRepositoryRoot(f);
            if (repository == null) continue;
            HashSet<VCSFileProxy> repoFiles = (HashSet<VCSFileProxy>)sorted.get(repository);
            if (repoFiles == null) {
                repoFiles = new HashSet<VCSFileProxy>();
                sorted.put(repository, repoFiles);
            }
            repoFiles.add(f);
        }
        return sorted;
    }

    private class HgFolderEventsHandler {
        private final HashMap<VCSFileProxy, HgFolderTimestamps> hgFolders = new HashMap(5);
        private final HashMap<VCSFileProxy, FileChangeListener> hgFolderRLs = new HashMap(5);
        private final HashMap<VCSFileProxy, Set<VCSFileProxy>> seenRoots = new HashMap(5);
        private final HashSet<VCSFileProxy> disabledEvents = new HashSet(5);
        private final HashSet<VCSFileProxy> filesToInitialize = new HashSet();
        private final RequestProcessor rp = new RequestProcessor("MercurialInterceptorEventsHandlerRP", 1);
        private final RequestProcessor.Task initializingTask = this.rp.create(new Runnable(){

            @Override
            public void run() {
                HgFolderEventsHandler.this.initializeFiles();
            }
        });
        private final RequestProcessor.Task refreshOpenFilesTask = this.rp.create(new Runnable(){

            @Override
            public void run() {
                Set openFiles = VCSFileProxySupport.getOpenFiles();
                for (VCSFileProxy file : openFiles) {
                    MercurialInterceptor.this.hg.notifyFileChanged(file);
                }
            }
        });
        private final Set<VCSFileProxy> historyChandegRepositories = new HashSet<VCSFileProxy>(5);
        private final RequestProcessor.Task refreshHistoryTabTask = this.rp.create(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList toRefresh;
                Set set = HgFolderEventsHandler.this.historyChandegRepositories;
                synchronized (set) {
                    toRefresh = new ArrayList(HgFolderEventsHandler.this.historyChandegRepositories);
                    HgFolderEventsHandler.this.historyChandegRepositories.clear();
                }
                if (!toRefresh.isEmpty()) {
                    for (VCSFileProxy repo : toRefresh) {
                        Mercurial.getInstance().historyChanged(repo);
                    }
                }
            }
        });

        private HgFolderEventsHandler() {
        }

        private HgFolderTimestamps scanHgFolderTimestamps(VCSFileProxy hgFolder) {
            return new HgFolderTimestamps(hgFolder);
        }

        public void refreshRepositoryTimestamps(VCSFileProxy repository) {
            this.refreshHgFolderTimestamp(this.scanHgFolderTimestamps(HgUtils.getHgFolderForRoot(repository)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshHgFolderTimestamp(HgFolderTimestamps newTimestamps) {
            final VCSFileProxy hgFolder = newTimestamps.getHgFolder();
            boolean exists = newTimestamps.repositoryExists();
            HashMap<VCSFileProxy, HgFolderTimestamps> hashMap = this.hgFolders;
            synchronized (hashMap) {
                if (exists && !newTimestamps.isNewer(this.hgFolders.get(hgFolder))) {
                    return;
                }
            }
            hashMap = this.hgFolders;
            synchronized (hashMap) {
                this.hgFolders.remove(hgFolder);
                FileChangeListener list = this.hgFolderRLs.remove(hgFolder);
                if (exists) {
                    this.hgFolders.put(hgFolder, newTimestamps);
                    if (list == null) {
                        list = new FileChangeAdapter();
                        FileChangeAdapter fList = list;
                        this.rp.post(new Runnable((FileChangeListener)fList){
                            final /* synthetic */ FileChangeListener val$fList;
                            {
                                this.val$fList = fileChangeListener;
                            }

                            @Override
                            public void run() {
                                FileObject fo = hgFolder.toFileObject();
                                if (fo != null) {
                                    fo.addRecursiveListener(this.val$fList);
                                }
                            }
                        });
                    }
                    this.hgFolderRLs.put(hgFolder, list);
                } else {
                    if (list != null) {
                        final FileChangeListener fList = list;
                        this.rp.post(new Runnable(){

                            @Override
                            public void run() {
                                FileObject fo = hgFolder.toFileObject();
                                if (fo != null) {
                                    fo.removeRecursiveListener(fList);
                                }
                            }
                        });
                    }
                    Mercurial.STATUS_LOG.log(Level.FINE, "refreshHgFolderTimestamp: {0} no longer exists", hgFolder.getPath());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long handleHgFolderEvent(VCSFileProxy hgFolder) {
            long lastModified = 0L;
            if (AUTOMATIC_REFRESH_ENABLED && !"false".equals(System.getProperty("mercurial.handleDirstateEvents", "true"))) {
                hgFolder = hgFolder.normalizeFile();
                Mercurial.STATUS_LOG.log(Level.FINER, "handleHgFolderEvent: special FS event handling for {0}", hgFolder.getPath());
                boolean refreshNeeded = false;
                if (this.isEnabled(hgFolder)) {
                    HgFolderTimestamps cached;
                    MercurialInterceptor.this.commandLogger.locked(VCSFileProxy.createFileProxy((VCSFileProxy)hgFolder, (String)"wlock"));
                    HashMap<VCSFileProxy, HgFolderTimestamps> hashMap = this.hgFolders;
                    synchronized (hashMap) {
                        cached = this.hgFolders.get(hgFolder);
                    }
                    if (cached == null || !cached.repositoryExists() || cached.isOutdated()) {
                        this.refreshHgFolderTimestamp(this.scanHgFolderTimestamps(hgFolder));
                        refreshNeeded = true;
                    }
                    if (refreshNeeded) {
                        VCSFileProxy repository = hgFolder.getParentFile();
                        Mercurial.STATUS_LOG.log(Level.FINE, "handleDirstateEvent: planning repository scan for {0}", repository.getPath());
                        MercurialInterceptor.this.reScheduleRefresh(3000, this.getSeenRoots(repository));
                        this.refreshOpenFilesTask.schedule(3000);
                        WorkingCopyInfo.refreshAsync(repository);
                        this.refreshHistoryTab(repository);
                    }
                }
            }
            return lastModified;
        }

        public void initializeFor(VCSFileProxy file) {
            if (this.addFileToInitialize(file)) {
                this.initializingTask.schedule(500);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<VCSFileProxy> getSeenRoots(VCSFileProxy repositoryRoot) {
            Set<VCSFileProxy> seenRootsForRepository;
            HashSet<VCSFileProxy> retval = new HashSet<VCSFileProxy>();
            Set<VCSFileProxy> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                retval.addAll(seenRootsForRepository);
            }
            return retval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VCSFileProxy addSeenRoot(VCSFileProxy repositoryRoot, VCSFileProxy rootToAdd) {
            Set<VCSFileProxy> seenRootsForRepository;
            VCSFileProxy addedRoot = null;
            Set<VCSFileProxy> set = seenRootsForRepository = this.getSeenRootsForRepository(repositoryRoot);
            synchronized (set) {
                if (!seenRootsForRepository.contains(repositoryRoot)) {
                    rootToAdd = rootToAdd.normalizeFile();
                    addedRoot = HgUtils.prepareRootFiles(repositoryRoot, seenRootsForRepository, rootToAdd);
                }
            }
            return addedRoot;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<VCSFileProxy> getSeenRootsForRepository(VCSFileProxy repositoryRoot) {
            HashMap<VCSFileProxy, Set<VCSFileProxy>> hashMap = this.seenRoots;
            synchronized (hashMap) {
                Set<VCSFileProxy> seenRootsForRepository = this.seenRoots.get(repositoryRoot);
                if (seenRootsForRepository == null) {
                    seenRootsForRepository = new HashSet<VCSFileProxy>();
                    this.seenRoots.put(repositoryRoot, seenRootsForRepository);
                }
                return seenRootsForRepository;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addFileToInitialize(VCSFileProxy file) {
            HashSet<VCSFileProxy> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                return this.filesToInitialize.add(file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private VCSFileProxy getFileToInitialize() {
            VCSFileProxy nextFile = null;
            HashSet<VCSFileProxy> hashSet = this.filesToInitialize;
            synchronized (hashSet) {
                Iterator<VCSFileProxy> iterator = this.filesToInitialize.iterator();
                if (iterator.hasNext()) {
                    nextFile = iterator.next();
                    iterator.remove();
                }
            }
            return nextFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void initializeFiles() {
            VCSFileProxy file = null;
            while ((file = this.getFileToInitialize()) != null) {
                VCSFileProxy newlyAddedRoot;
                VCSFileProxy repositoryRoot = MercurialInterceptor.this.hg.getRepositoryRoot(file);
                if (repositoryRoot == null || (newlyAddedRoot = this.addSeenRoot(repositoryRoot, file)) == null) continue;
                Mercurial.STATUS_LOG.log(Level.FINE, "pingRepositoryRootFor: planning a scan for {0} - {1}", new Object[]{repositoryRoot.getPath(), file.getPath()});
                MercurialInterceptor.this.reScheduleRefresh(4000, newlyAddedRoot, false);
                VCSFileProxy hgFolder = HgUtils.getHgFolderForRoot(repositoryRoot).normalizeFile();
                boolean refreshNeeded = false;
                HashMap<VCSFileProxy, HgFolderTimestamps> hashMap = this.hgFolders;
                synchronized (hashMap) {
                    if (!this.hgFolders.containsKey(hgFolder) && hgFolder.isDirectory()) {
                        this.hgFolders.put(hgFolder, null);
                        refreshNeeded = true;
                    }
                }
                if (!refreshNeeded) continue;
                this.refreshHgFolderTimestamp(this.scanHgFolderTimestamps(hgFolder));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void enableEvents(VCSFileProxy repository, boolean enabled) {
            VCSFileProxy hgFolder = HgUtils.getHgFolderForRoot(repository).normalizeFile();
            HashSet<VCSFileProxy> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                if (enabled) {
                    this.disabledEvents.remove(hgFolder);
                } else {
                    this.disabledEvents.add(hgFolder);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean isEnabled(VCSFileProxy hgFolder) {
            HashSet<VCSFileProxy> hashSet = this.disabledEvents;
            synchronized (hashSet) {
                return !this.disabledEvents.contains(hgFolder);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshHistoryTab(VCSFileProxy repository) {
            boolean refresh;
            Set<VCSFileProxy> set = this.historyChandegRepositories;
            synchronized (set) {
                refresh = this.historyChandegRepositories.add(repository);
            }
            if (refresh) {
                this.refreshHistoryTabTask.schedule(3000);
            }
        }
    }

    private static class HgFolderTimestamps {
        private final VCSFileProxy hgFolder;
        private final Map<String, Long> interestingTimestamps;
        private final long dirstateSize;
        private final VCSFileProxy dirstateFile;
        private static final String DIRSTATE = "dirstate";
        private static final String[] INTERESTING_FILENAMES = new String[]{"branch", "branchheads.cache", "localtags", "tags.cache", "undo.branch", "undo.dirstate"};

        public HgFolderTimestamps(VCSFileProxy hgFolder) {
            this.hgFolder = hgFolder;
            HashMap<String, Long> ts = new HashMap<String, Long>(INTERESTING_FILENAMES.length);
            for (String fn : INTERESTING_FILENAMES) {
                ts.put(fn, VCSFileProxy.createFileProxy((VCSFileProxy)hgFolder, (String)fn).lastModified());
            }
            this.dirstateFile = VCSFileProxy.createFileProxy((VCSFileProxy)hgFolder, (String)DIRSTATE);
            this.dirstateSize = VCSFileProxySupport.length((VCSFileProxy)this.dirstateFile);
            this.interestingTimestamps = Collections.unmodifiableMap(ts);
        }

        private boolean isNewer(HgFolderTimestamps other) {
            boolean newer = true;
            if (other != null) {
                newer = this.dirstateSize != other.dirstateSize;
                for (Map.Entry<String, Long> e : this.interestingTimestamps.entrySet()) {
                    if (e.getValue() <= other.interestingTimestamps.get(e.getKey()) && (e.getValue() != 0L || other.interestingTimestamps.get(e.getKey()).longValue() == e.getValue().longValue())) continue;
                    newer = true;
                    break;
                }
            }
            return newer;
        }

        private VCSFileProxy getHgFolder() {
            return this.hgFolder;
        }

        private boolean repositoryExists() {
            return this.dirstateSize > 0L || this.hgFolder.exists();
        }

        private boolean isOutdated() {
            boolean upToDate;
            boolean bl = upToDate = this.dirstateSize == VCSFileProxySupport.length((VCSFileProxy)this.dirstateFile);
            if (upToDate) {
                for (Map.Entry<String, Long> e : this.interestingTimestamps.entrySet()) {
                    VCSFileProxy f = VCSFileProxy.createFileProxy((VCSFileProxy)this.hgFolder, (String)e.getKey());
                    long ts = f.lastModified();
                    if (e.getValue() >= ts && (e.getValue() <= ts || ts != 0L)) continue;
                    upToDate = false;
                    break;
                }
            }
            return !upToDate;
        }
    }

    private class LockedRepositoryRefreshTask
    implements Runnable {
        private LockedRepositoryRefreshTask() {
        }

        @Override
        public void run() {
            if (!MercurialInterceptor.this.checkLockedRepositories(Collections.emptySet(), true).isEmpty()) {
                MercurialInterceptor.this.refreshTask.schedule(0);
            } else if (!MercurialInterceptor.this.lockedRepositories.isEmpty()) {
                MercurialInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        @Override
        public void run() {
            VCSFileProxy file;
            Thread.interrupted();
            if (DelayScanRegistry.getInstance().isDelayed(MercurialInterceptor.this.refreshTask, Mercurial.STATUS_LOG, "MercurialInterceptor.refreshTask")) {
                return;
            }
            HashSet<VCSFileProxy> files = new HashSet<VCSFileProxy>(MercurialInterceptor.this.filesToRefresh.size());
            while ((file = (VCSFileProxy)MercurialInterceptor.this.filesToRefresh.poll()) != null) {
                files.add(file);
            }
            if (!"false".equals(System.getProperty("versioning.mercurial.delayStatusForLockedRepositories"))) {
                files = MercurialInterceptor.this.checkLockedRepositories(files, false);
            }
            if (!files.isEmpty()) {
                MercurialInterceptor.this.cache.refreshAllRoots(files);
            }
            if (!MercurialInterceptor.this.lockedRepositories.isEmpty()) {
                MercurialInterceptor.this.lockedRepositoryRefreshTask.schedule(5000);
            }
        }
    }

    private static class Events {
        long timeStarted;
        long timeFinished;
        long modifications;
        String commandName;

        private Events() {
        }

        private boolean isExternal() {
            return this.commandName == null;
        }
    }

    private class CommandUsageLogger {
        private final Map<VCSFileProxy, Events> events = new HashMap<VCSFileProxy, Events>();

        private CommandUsageLogger() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void locked(VCSFileProxy file) {
            VCSFileProxy hgFolder = this.getHgFolderFor(file);
            if (hgFolder != null && HgUtils.isRepositoryLocked(hgFolder.getParentFile())) {
                long time = System.currentTimeMillis();
                Map<VCSFileProxy, Events> map = this.events;
                synchronized (map) {
                    Events ev = this.events.get(hgFolder);
                    if (ev == null || ev.timeFinished > 0L && ev.timeFinished < time - 10000L) {
                        ev = new Events();
                        ev.timeStarted = time;
                        this.events.put(hgFolder, ev);
                        this.scheduleUnlock(hgFolder.getParentFile());
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void lockedInternally(VCSFileProxy repository, String commandName) {
            VCSFileProxy hgFolder = HgUtils.getHgFolderForRoot(repository);
            Events ev = new Events();
            ev.timeStarted = System.currentTimeMillis();
            ev.commandName = commandName;
            Map<VCSFileProxy, Events> map = this.events;
            synchronized (map) {
                this.events.put(hgFolder, ev);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlocked(VCSFileProxy file) {
            VCSFileProxy hgFolder = this.getHgFolderFor(file);
            if (hgFolder != null) {
                Events ev;
                Map<VCSFileProxy, Events> map = this.events;
                synchronized (map) {
                    ev = this.events.remove(hgFolder);
                    if (ev != null && !ev.isExternal()) {
                        this.events.put(hgFolder, ev);
                        return;
                    }
                }
                if (ev != null) {
                    long time = System.currentTimeMillis() - ev.timeStarted;
                    Utils.logVCSCommandUsageEvent((String)"HG", (long)time, (long)ev.modifications, (String)ev.commandName, (boolean)ev.isExternal());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unlockedInternally(VCSFileProxy repository) {
            Events ev;
            VCSFileProxy hgFolder = HgUtils.getHgFolderForRoot(repository);
            Map<VCSFileProxy, Events> map = this.events;
            synchronized (map) {
                ev = this.events.get(hgFolder);
                if (ev == null) {
                    return;
                }
                if (ev.isExternal()) {
                    this.events.remove(hgFolder);
                }
            }
            ev.timeFinished = System.currentTimeMillis();
            long time = ev.timeFinished - ev.timeStarted;
            Utils.logVCSCommandUsageEvent((String)"HG", (long)time, (long)ev.modifications, (String)ev.commandName, (boolean)ev.isExternal());
        }

        private VCSFileProxy getHgFolderFor(VCSFileProxy wlockFile) {
            VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(wlockFile);
            VCSFileProxy hgFolder = HgUtils.getHgFolderForRoot(repository);
            return hgFolder.equals((Object)wlockFile.getParentFile()) ? hgFolder : null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void logModification(VCSFileProxy file) {
            if (HgUtils.isPartOfMercurialMetadata(file)) {
                return;
            }
            VCSFileProxy repository = Mercurial.getInstance().getRepositoryRoot(file);
            if (repository == null) {
                return;
            }
            VCSFileProxy hgFolder = HgUtils.getHgFolderForRoot(repository);
            if (hgFolder != null) {
                long time = System.currentTimeMillis();
                Map<VCSFileProxy, Events> map = this.events;
                synchronized (map) {
                    Events ev = this.events.get(hgFolder);
                    if ((ev == null || ev.timeFinished > 0L && ev.timeFinished < time - 10000L) && HgUtils.isRepositoryLocked(repository)) {
                        ev = new Events();
                        ev.timeStarted = time;
                        this.events.put(hgFolder, ev);
                        this.scheduleUnlock(repository);
                    }
                    if (ev != null) {
                        ++ev.modifications;
                    }
                }
            }
        }

        private void scheduleUnlock(final VCSFileProxy repository) {
            Mercurial.getInstance().getParallelRequestProcessor().post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    long timeout = 1000L;
                    while (HgUtils.isRepositoryLocked(repository)) {
                        long t = System.currentTimeMillis();
                        CommandUsageLogger commandUsageLogger = MercurialInterceptor.this.commandLogger;
                        synchronized (commandUsageLogger) {
                            try {
                                MercurialInterceptor.this.commandLogger.wait(timeout);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        if (timeout > System.currentTimeMillis() - t) continue;
                        timeout = Math.min(30000L, timeout << 1);
                    }
                    CommandUsageLogger.this.unlocked(VCSFileProxy.createFileProxy((VCSFileProxy)HgUtils.getHgFolderForRoot(repository), (String)"wlock"));
                }
            });
        }
    }
}

