/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.update;

import org.netbeans.modules.mercurial.remote.FileStatusCache;
import org.netbeans.modules.mercurial.remote.HgProgressSupport;
import org.netbeans.modules.mercurial.remote.Mercurial;
import org.netbeans.modules.mercurial.remote.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.remote.ui.update.ResolveConflictsExecutor;
import org.netbeans.modules.mercurial.remote.util.HgUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResolveConflictsAction
extends ContextAction {
    private static final String ICON_RESOURCE = "org/netbeans/modules/mercurial/remote/resources/icons/conflict-resolve.png";

    public ResolveConflictsAction() {
        super(ICON_RESOURCE);
    }

    protected String iconResource() {
        return ICON_RESOURCE;
    }

    @Override
    protected boolean enable(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        return cache.containsFileOfStatus(context, 64, false);
    }

    @Override
    protected String getBaseName(Node[] nodes) {
        return "CTL_MenuItem_Resolve";
    }

    @Override
    protected void performContextAction(Node[] nodes) {
        VCSContext context = HgUtils.getCurrentContext(nodes);
        ResolveConflictsAction.resolve(context);
    }

    public static void resolve(VCSContext ctx) {
        FileStatusCache cache = Mercurial.getInstance().getFileStatusCache();
        VCSFileProxy[] files = cache.listFiles(ctx, 64);
        ResolveConflictsAction.resolveConflicts(files);
    }

    static void resolveConflicts(final VCSFileProxy[] files) {
        if (files.length == 0) {
            NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_NoConflictsFound"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
        } else {
            new HgProgressSupport(){

                @Override
                protected void perform() {
                    for (int i = 0; i < files.length; ++i) {
                        VCSFileProxy file = files[i];
                        ResolveConflictsExecutor executor = new ResolveConflictsExecutor(file);
                        executor.exec();
                        if (this.isCanceled()) break;
                    }
                }
            }.start(Mercurial.getInstance().getRequestProcessor(), files[0], NbBundle.getMessage(ResolveConflictsAction.class, (String)"MSG_PreparingMerge"));
        }
    }
}

