/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.jdbc;

import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.lib.profiler.results.jdbc.StringCache;

class SQLParser {
    Object[] commands = new Object[]{"ALTER", 0, "CREATE", 1, "DELETE", 2, "DESCRIBE", 3, "INSERT", 4, "SELECT", 5, "SET", 6, "UPDATE", 7};
    private static final String fromRegexp = "(^\\bSELECT\\b)|(\\bFROM\\b)|(\\bWHERE\\b)|(\\bGROUP\\sBY\\b)|(\\bORDER\\sBY\\b)|(^\\bUPDATE\\b)|(^\\bINSERT INTO\\b)|('[^']*')";
    private static final String wordRegexp = "\\b\\w+\\.?\\w*\\b";
    private final Pattern commandsPattern;
    private final Pattern fromPattern;
    private final Pattern wordPattern;
    private final StringCache strings;

    SQLParser() {
        StringBuffer pattern = new StringBuffer();
        for (int i = 0; i < this.commands.length; i += 2) {
            pattern.append("(^\\b");
            pattern.append(this.commands[i]);
            pattern.append("\\b)|");
        }
        this.commandsPattern = Pattern.compile(pattern.substring(0, pattern.length() - 1).toString(), 2);
        this.fromPattern = Pattern.compile(fromRegexp, 2);
        this.wordPattern = Pattern.compile(wordRegexp, 2);
        this.strings = new StringCache();
    }

    int extractSQLCommandType(String sql) {
        if (sql != null && sql.startsWith("[")) {
            return -2;
        }
        Matcher m = this.commandsPattern.matcher(sql);
        if (m.find()) {
            for (int i = 0; i < this.commands.length; i += 2) {
                if (m.start(i / 2 + 1) == -1) continue;
                return (Integer)this.commands[i + 1];
            }
            throw new IllegalArgumentException(m.toString());
        }
        return -1;
    }

    String[] extractTables(String sql) {
        String fromClause = this.extractFromClause(sql);
        if (fromClause != null) {
            String[] tablesRefs = fromClause.trim().split(",");
            HashSet<String> tables = new HashSet<String>(tablesRefs.length);
            for (int i = 0; i < tablesRefs.length; ++i) {
                Matcher m = this.wordPattern.matcher(tablesRefs[i]);
                if (!m.find()) continue;
                tables.add(this.strings.intern(m.group()));
            }
            return tables.toArray(new String[0]);
        }
        return new String[0];
    }

    String extractFromClause(String sql) {
        Matcher m = this.fromPattern.matcher(sql);
        if (m.find()) {
            Matcher mw;
            if (m.start(1) != -1) {
                int fromStart = -1;
                int fromEnd = -1;
                while (m.find()) {
                    if (m.end(2) != -1) {
                        fromStart = m.end(2);
                        continue;
                    }
                    if (m.start(3) != -1) {
                        fromEnd = m.start(3);
                        break;
                    }
                    if (m.start(4) != -1) {
                        fromEnd = m.start(4);
                        break;
                    }
                    if (m.start(5) == -1) continue;
                    fromEnd = m.start(5);
                    break;
                }
                if (fromStart < fromEnd) {
                    return sql.substring(fromStart + 1, fromEnd);
                }
                if (fromStart != -1 && fromEnd == -1) {
                    return sql.substring(fromStart + 1);
                }
            } else if (m.start(6) != -1) {
                Matcher mw2 = this.wordPattern.matcher(sql.substring(m.end(6) + 1));
                if (mw2.find()) {
                    return mw2.group();
                }
            } else if (m.start(7) != -1 && (mw = this.wordPattern.matcher(sql.substring(m.end(7) + 1))).find()) {
                return mw.group();
            }
        }
        return null;
    }
}

