/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.classdetector;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.source.util.Trees;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.openide.filesystems.FileObject;

public class TypeFinder
implements CancellableTask<CompilationController> {
    private volatile boolean cancelled;
    private final ClassPath classpath;
    private final String fqn;
    private Callback callback;
    private final Logger LOG = Logger.getLogger(TypeFinder.class.getName());

    public TypeFinder(String fqn, ClassPath path) {
        this.classpath = path;
        this.fqn = fqn;
        this.LOG.log(Level.FINER, "Create a TypeFinder for {0} on {1}", new Object[]{fqn, path});
    }

    public void findTypes(Callback callback) {
        assert (!EventQueue.isDispatchThread());
        this.callback = callback;
        for (FileObject fo : this.classpath.getRoots()) {
            this.LOG.log(Level.FINER, "Scan {0} for {1}", new Object[]{fo, this.fqn});
            this.analyze(fo);
        }
    }

    private void analyze(FileObject fo) {
        block4: {
            block3: {
                this.LOG.log(Level.FINEST, "Analyze {0}", new Object[]{fo});
                if (!fo.isFolder()) break block3;
                for (FileObject child : fo.getChildren()) {
                    this.analyze(child);
                }
                break block4;
            }
            if (!"text/x-java".equals(fo.getMIMEType())) break block4;
            JavaSource src = JavaSource.forFileObject((FileObject)fo);
            try {
                this.LOG.log(Level.FINEST, "Check java source {0}", new Object[]{fo});
                src.runUserActionTask((Task)this, true);
            }
            catch (IOException ex) {
                Logger.getLogger(TypeFinder.class.getName()).log(Level.INFO, "Problem scanning " + fo.getPath(), ex);
            }
        }
    }

    public void reset() {
        this.cancelled = false;
    }

    public void cancel() {
        this.cancelled = true;
    }

    public void run(CompilationController compiler) throws Exception {
        if (this.cancelled) {
            return;
        }
        compiler.toPhase(JavaSource.Phase.RESOLVED);
        if (this.cancelled) {
            return;
        }
        List<? extends Tree> types = compiler.getCompilationUnit().getTypeDecls();
        for (Tree tree : types) {
            if (this.cancelled) {
                return;
            }
            TypeMirror mirror = compiler.getTrees().getTypeMirror(TreePath.getPath(compiler.getCompilationUnit(), tree));
            this.LOG.log(Level.FINEST, "Check type {0}", mirror);
            if (!(tree instanceof ClassTree) || !this.match(mirror, compiler.getTypes())) continue;
            this.callback.foundFileObject(compiler.getFileObject(), mirror.toString());
        }
    }

    boolean match(Trees trees, Types types, CompilationUnitTree unit, Tree t) {
        TypeMirror mirror = trees.getTypeMirror(TreePath.getPath(unit, t));
        return this.match(mirror, types);
    }

    boolean match(TypeMirror mirror, Types types) {
        boolean result = false;
        if (mirror != null && !"java.lang.Object".equals(mirror.toString()) && !(result = this.fqn.equals(mirror.toString()))) {
            List<? extends TypeMirror> l = types.directSupertypes(mirror);
            for (TypeMirror typeMirror : l) {
                result = this.match(typeMirror, types);
                if (this.cancelled) {
                    return result;
                }
                if (!result) continue;
                break;
            }
        }
        this.LOG.log(Level.FINEST, "Match {0}? ", new Object[]{mirror, result});
        return result;
    }

    public static interface Callback {
        public void foundFileObject(FileObject var1, String var2);
    }
}

