/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.templates;

import com.sun.javacard.AID;
import com.sun.javacard.filemodels.DeploymentXmlAppletEntry;
import com.sun.javacard.filemodels.DeploymentXmlInstanceEntry;
import com.sun.javacard.filemodels.DeploymentXmlModel;
import com.sun.javacard.filemodels.FileModelEntry;
import com.sun.javacard.filemodels.ParseErrorHandler;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.javacard.common.Utils;
import org.netbeans.modules.javacard.project.JCProject;
import org.netbeans.modules.javacard.project.refactoring.AppletXMLRefactoringSupport;
import org.netbeans.modules.javacard.spi.ProjectKind;
import org.netbeans.modules.javacard.templates.ClassicAppletDeploymentWizardPanel;
import org.netbeans.modules.javacard.templates.ErrorPanel;
import org.netbeans.modules.javacard.wizard.ProjectWizardIterator;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Document;

public final class ClassicAppletWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private boolean needsToCancel;
    private boolean isClassicAppletTemplate;
    private ProjectKind kind;

    private WizardDescriptor.Panel createJavaSourcePanel(WizardDescriptor wizardDescriptor) {
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] groups = sources.getSourceGroups("java");
        assert (groups != null) : "Cannot return null from Sources.getSourceGroups: " + sources;
        if (groups.length == 0) {
            groups = sources.getSourceGroups("generic");
            return Templates.createSimpleTargetChooser((Project)project, (SourceGroup[])groups);
        }
        FakePanel pnl = new FakePanel();
        WizardDescriptor.Panel p = JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])groups, (WizardDescriptor.Panel)pnl, (boolean)true);
        return p;
    }

    private WizardDescriptor.Panel<WizardDescriptor>[] getPanels() {
        if (this.needsToCancel) {
            return new WizardDescriptor.Panel[]{new ErrorPanel(NbBundle.getMessage(ClassicAppletWizardIterator.class, (String)(this.isClassicAppletTemplate ? "CLASSIC_APPLET_APPLICATIONS" : "EXTENDED_APPLET_APPLICATIONS")))};
        }
        if (this.panels == null) {
            WizardDescriptor.Panel javaSourcePanel = this.createJavaSourcePanel(this.wizard);
            ClassicAppletDeploymentWizardPanel servletPanel = new ClassicAppletDeploymentWizardPanel(this.wizard);
            this.panels = new WizardDescriptor.Panel[]{javaSourcePanel, servletPanel};
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component c = this.panels[i].getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jc.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    public Set instantiate() throws IOException {
        JCProject jcProject;
        FileObject dir = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        String targetName = Templates.getTargetName((WizardDescriptor)this.wizard);
        DataFolder df = DataFolder.findFolder((FileObject)dir);
        FileObject template = Templates.getTemplate((WizardDescriptor)this.wizard);
        FileObject createdFile = null;
        Project p = Templates.getProject((WizardDescriptor)this.wizard);
        JCProject jCProject = jcProject = p == null ? null : (JCProject)p.getLookup().lookup(JCProject.class);
        if (jcProject != null && dir != null) {
            boolean found = false;
            for (FileObject fo : jcProject.getSourceClassPath().getRoots()) {
                if (fo == null) continue;
                if (fo.equals(dir)) {
                    throw new IOException(NbBundle.getMessage(ClassicAppletWizardIterator.class, (String)"ERR_NO_DEFAULT_PACKAGE"));
                }
                found |= FileUtil.isParentOf((FileObject)fo, (FileObject)dir);
            }
            if (jcProject.getProjectDirectory().equals(dir)) {
                throw new IOException(NbBundle.getMessage(ClassicAppletWizardIterator.class, (String)"ERR_NO_DEFAULT_PACKAGE"));
            }
            if (!found) {
                throw new IOException(NbBundle.getMessage(ClassicAppletWizardIterator.class, (String)"ERR_NOT_ON_CLASSPATH", (Object)dir.getName()));
            }
        }
        DataObject dTemplate = DataObject.find((FileObject)template);
        DataObject dobj = dTemplate.createFromTemplate(df, targetName);
        createdFile = dobj.getPrimaryFile();
        if (jcProject != null) {
            this.addInfoToWebDescriptor(createdFile, jcProject);
            this.createScriptFile(createdFile, jcProject);
            this.updatePropertiesToCreateInstance(createdFile, jcProject);
        }
        return Collections.singleton(createdFile);
    }

    private void updatePropertiesToCreateInstance(FileObject cls, JCProject jcProject) {
        if ("false".equals(this.wizard.getProperty("_createinstance_"))) {
            return;
        }
        EditableProperties props = jcProject.getAntProjectHelper().getProperties("nbproject/project.properties");
        jcProject.getAntProjectHelper().putProperties("nbproject/project.properties", props);
    }

    private void createScriptFile(FileObject cls, JCProject jcProject) {
        if ("false".equals(this.wizard.getProperty("_createscript_"))) {
            return;
        }
        String clsName = cls.getName();
        File f = FileUtil.toFile((FileObject)jcProject.getProjectDirectory());
        f = new File(f, "scripts/" + clsName.toLowerCase() + ".scr");
        Utils.createAPDUScript((File)f, (String)clsName, (String)((String)this.wizard.getProperty("appletName")));
    }

    private void addInfoToWebDescriptor(final FileObject createdFile, final JCProject jcProject) {
        Project p = Templates.getProject((WizardDescriptor)this.wizard);
        final String appletAid = (String)this.wizard.getProperty("appletName");
        if (appletAid != null) {
            final String instanceAid = AID.parse((String)appletAid).increment().toString();
            ProjectManager.mutex().postWriteRequest(new Runnable(){

                @Override
                public void run() {
                    try {
                        ClassPathProvider cpProvider = (ClassPathProvider)jcProject.getLookup().lookup(ClassPathProvider.class);
                        String className = createdFile.getName();
                        if (cpProvider != null) {
                            className = cpProvider.findClassPath(createdFile, "classpath/source").getResourceName(createdFile, '.', false);
                        }
                        FileObject webObj = jcProject.getProjectDirectory().getFileObject("APPLET-INF/applet.xml");
                        AppletXMLRefactoringSupport web = AppletXMLRefactoringSupport.fromFile(FileUtil.toFile((FileObject)webObj));
                        web.addAppletInfo(appletAid, className);
                        OutputStream out = webObj.getOutputStream();
                        XMLUtil.write((Document)web.getDocument(), (OutputStream)out, (String)"UTF-8");
                        out.close();
                        ClassicAppletWizardIterator.this.updateDeploymentXml(jcProject, appletAid, className, instanceAid, createdFile);
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDeploymentXml(JCProject jcProject, String appletAid, String className, String instanceAid, FileObject createdFile) throws IOException {
        DeploymentXmlModel mdl;
        FileObject depl = jcProject.getProjectDirectory().getFileObject("nbproject/deployment.xml");
        if (depl == null) {
            depl = FileUtil.createData((FileObject)jcProject.getProjectDirectory(), (String)"nbproject/deployment.xml");
            mdl = new DeploymentXmlModel();
        } else {
            InputStream in = depl.getInputStream();
            mdl = new DeploymentXmlModel(in, ParseErrorHandler.NULL);
            DeploymentXmlModel nue = new DeploymentXmlModel();
            for (DeploymentXmlAppletEntry e : mdl.getData()) {
                nue.add((FileModelEntry)((DeploymentXmlAppletEntry)e.clone()));
            }
            mdl = nue;
        }
        DeploymentXmlAppletEntry toAdd = new DeploymentXmlAppletEntry();
        toAdd.setAppletAid(AID.parse((String)appletAid));
        toAdd.setClazzHint(className);
        toAdd.setDisplayNameHint(ProjectWizardIterator.unbicapitalize(createdFile.getName()));
        DeploymentXmlInstanceEntry instance = new DeploymentXmlInstanceEntry(AID.parse((String)instanceAid), "", mdl.getData().size());
        toAdd.add((FileModelEntry)instance);
        mdl.add((FileModelEntry)toAdd);
        mdl.close();
        FileLock lock = depl.lock();
        OutputStream outStream = depl.getOutputStream(lock);
        PrintWriter p = new PrintWriter(outStream);
        try {
            p.println(mdl.toXml());
        }
        finally {
            p.close();
            outStream.close();
            lock.releaseLock();
        }
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
        Project project = Templates.getProject((WizardDescriptor)wizard);
        FileObject template = Templates.getTemplate((WizardDescriptor)wizard);
        this.isClassicAppletTemplate = "ClassicApplet".equals(template.getName());
        if (project != null) {
            JCProject jc = (JCProject)project.getLookup().lookup(JCProject.class);
            this.kind = jc == null ? null : jc.kind();
        }
        this.needsToCancel = this.isClassicAppletTemplate && this.kind != ProjectKind.CLASSIC_APPLET || !this.isClassicAppletTemplate && this.kind != ProjectKind.EXTENDED_APPLET || this.kind == null;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (this.index == 0) {
            this.panels[0].storeSettings((Object)this.wizard);
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = null;
        Object prop = this.wizard.getProperty("WizardPanel_contentData");
        if (prop != null && prop instanceof String[]) {
            beforeSteps = (String[])prop;
        }
        if (beforeSteps == null) {
            beforeSteps = new String[]{};
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.length];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels[i - beforeSteps.length + 1].getComponent().getName();
        }
        return res;
    }

    private static final class FakePanel
    implements WizardDescriptor.Panel<WizardDescriptor> {
        private FakePanel() {
        }

        public Component getComponent() {
            return new JLabel("");
        }

        public HelpCtx getHelp() {
            return HelpCtx.DEFAULT_HELP;
        }

        public void readSettings(WizardDescriptor settings) {
        }

        public void storeSettings(WizardDescriptor settings) {
        }

        public boolean isValid() {
            return true;
        }

        public void addChangeListener(ChangeListener l) {
        }

        public void removeChangeListener(ChangeListener l) {
        }
    }
}

